/*
 * Entry.c
 *
 * Copyright 2008, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 *Գס
 *
 *
 *
 *ԸƤ
 */


#include <sys/config.h>
#include <sys/types.h>
#include <sys/param.h>
#include <i386/interrupt.h>

#include <kern/debug.h>


//#define DEBUG_ENTRY 1
#ifdef DEBUG_ENTRY
	#define STATIC
	#define INLINE
#else
	#define STATIC	static
	#define INLINE	inline
#endif


//=====================================  ===================================================

enum {
	EXEPT_ENTRY_NUM = 20,		// 㳰ߥȥ꡼
	DEVINTR_ENTRY_NUM = 20,		// ǥХߥȥ꡼
};

//===================================== Х륤ݡ =======================================

extern void except0();
extern void except1();
extern void except2();
extern void except3();
extern void except4();
extern void except5();
extern void except6();
extern void except7();
extern void except8();
extern void except9();
extern void except10();
extern void except11();
extern void except12();
extern void except13();
extern void except14();
extern void except15();
extern void except16();
extern void except17();
extern void except18();
extern void except19();
extern void devIrq0();
extern void devIrq1();
extern void devIrq2();
extern void devIrq3();
extern void devIrq4();
extern void devIrq5();
extern void devIrq6();
extern void devIrq7();
extern void devIrq8();
extern void devIrq9();
extern void devIrq10();
extern void devIrq11();
extern void devIrq12();
extern void devIrq13();
extern void devIrq14();
extern void devIrq15();
extern void devIrq16();
extern void devIrq17();
extern void devIrq18();
extern void devIrq19();

extern int doUserIntrHandler(const int);

//===================================== PRIVATE ====================================================

/*
 * 㳰ȥ꡼ơ֥
 */
static void *exceptEntry[EXEPT_ENTRY_NUM] = {
	except0,
	except1,
	except2,
	except3,
	except4,
	except5,
	except6,
	except7,
	except8,
	except9,
	except10,
	except11,
	except12,
	except13,
	except14,
	except15,
	except16,
	except17,
	except18,
	except19,
};

/*
 * ǥХߥȥ꡼ơ֥
 */
static void *devIntrEntry[DEVINTR_ENTRY_NUM] = {
	devIrq0,
	devIrq1,
	devIrq2,
	devIrq3,
	devIrq4,
	devIrq5,
	devIrq6,
	devIrq7,
	devIrq8,
	devIrq9,
	devIrq10,
	devIrq11,
	devIrq12,
	devIrq13,
	devIrq14,
	devIrq15,
	devIrq16,
	devIrq17,
	devIrq18,
	devIrq19,
};

//===================================== PUBLIC =====================================================

/*
 * 㳰ϥɥơ֥
 */
void *exceptHandler[EXEPT_ENTRY_NUM];

/*
 * ǥХߥϥɥơ֥
 */
void *devIntrHandler[DEVINTR_ENTRY_NUM];

/*
 * ǥХEOIơ֥
 */
void (*devEoi)(const int i_irq);

/*
 * 󥹥ȥ饯
 */
void EntryConstructor()
{
}

/*
 * ǥȥ饯
 */
void EntryDestructor()
{
}

/*
 * 㳰ȥ꡼
 */
void setExceptEntry(
	const int i_intr,		// ID
	void *i_handler)		// 㳰ϥɥ
{
	ASSERT(0 <= i_intr && i_intr < EXEPT_ENTRY_NUM);

	exceptHandler[i_intr] = i_handler;

	// Ͽ
	set_idt(i_intr, exceptEntry[i_intr], IDT_TRAP);

}

/*
 * 㳰߶ػߥȥ꡼
 */
void setExceptIntrEntry(
	const int i_intr,		// ID
	void *i_handler)		// 㳰ϥɥ
{
	ASSERT(0 <= i_intr && i_intr < EXEPT_ENTRY_NUM);

	exceptHandler[i_intr] = i_handler;

	// Ͽ
	set_idt(i_intr, exceptEntry[i_intr], IDT_INTR);
}

/*
 * ǥХߤ
 */
void setDevIntrEntry(
	const int i_intr,		// ID
	const int i_irq,		// IRQ
	void *i_handler,		// ߥϥɥ
	void *i_eoi)			// EOIȯ
{
	ASSERT(0 <= i_irq && i_irq < DEVINTR_ENTRY_NUM);

	devIntrHandler[i_irq] = i_handler;
	devEoi = i_eoi;

	// Ͽ
	set_idt(i_intr, devIntrEntry[i_irq], IDT_INTR);
}

/*
 * ǥХߥϥɥ򥻥åȤ
 */
void setDevIntrHandler(
	const int i_irq,		// IRQ
	void *i_handler)		// ߥϥɥ
{
	ASSERT((0 <= i_irq) & (i_irq <= DEVINTR_ENTRY_NUM));
	
	devIntrHandler[i_irq] = i_handler;
}

/*
 * ɥ롼פ򳫻Ϥ
 */
void startIdle()
{
	sti();
	asm volatile(
		"movl	%0, %%esp\n"
		"jmp	idle"
		::"i"(KERNEL_ESP_BEG)
	);
}

//*************************************************************************************************
#ifdef DEBUG
void testEntry(
	const int i_intr,		// ID
	const int i_irq)		// IRQ
{
	devIntrHandler[i_irq] = doUserIntrHandler;
	set_idt(i_intr, devIntrEntry[i_irq], IDT_USER);
}
#endif
//*************************************************************************************************
