/*
 * Switch_asm.S
 *
 * Copyright 2008, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 *Գסեͥ롦桼⡼ɡְܹ
 *
 *
 *
 *ԸƤ
 */


#define ASM_FILE


#include <sys/config.h>
#include <sys/param.h>
#include <sys/syscall.h>
#include <kern/debug.h>
#include <i386/segment.h>
#include <i386/interrupt.h>


//--------------------------------------------------------------------------------------------------
// ޥ
//--------------------------------------------------------------------------------------------------

#define GLOBAL(x)	.globl x; x:

/*
 * ƥȥ֤ѹϡproc.cset_context()˱ƶ
 */
.macro SAVE
	pushal
	pushl	%es
	pushl	%ds
/*	pushl	%fs
	pushl	%gs*/
	movl	$KERNEL_DATA_DES, %eax
	movl	%eax, %es
	movl	%eax, %ds
	cld
.endm

/*
 * ƥᤷ
 */
.macro RESTORE
/*	popl	%gs
	popl	%fs*/
	popl	%ds
	popl	%es
	popal
	addl	$4, %esp		// 顼ʬ
	iret
.endm

/*
 * ƥȥƬESPΥ
 */
.macro SAVE_ESP
	pushl	KERNEL_SWITCH_ESP
	movl	%esp, KERNEL_SWITCH_ESP
.endm

/*
 * ƥȥƬESPᤷ
 */
.macro RESTORE_ESP
	movl	KERNEL_SWITCH_ESP, %esp
	popl	KERNEL_SWITCH_ESP
.endm

/*
 * ۥ꡼֤Υå
 * in   : eax = ڡǥ쥯ȥ
 * work : ecx, edx
 */
.macro SWITCH
	call	switchTask
	SAVE_ESP

	// ۥ꡼֤򥹥å
	movl	%eax, %cr3

	RESTORE_ESP

	// FPUԲ㳰Ĥˤ
	call	setTs
.endm

/*
 * ƥȤܹԤʤۥ꡼֤Υå
 * in   : eax = ڡǥ쥯ȥ
 * work : ecx, edx
 */
.macro SWITCH_VM
	call	switchTask

	// ۥ꡼֤򥹥å
	movl	%eax, %cr3

	// FPUԲ㳰Ĥˤ
	call	setTs
.endm

/*
 * Υƥȥ
 * parameter : esp = ʪåɥ쥹
 */
.macro SAVE_CREATE_ESP
	pushl	$0							// 
	movl	%esp, %eax
	andl	$~(PAGE_SIZE - 1), %eax
	orl		$(KERNEL_SWITCH_ESP & (PAGE_SIZE - 1)), %eax
	movl	%esp, %edx
	andl	$(PAGE_SIZE - 1), %edx
	addl	$(KERNEL_STACK_END - PAGE_SIZE), %edx
	movl	%edx, (%eax)
.endm

/*
 * 㳰ϥɥ顼ƤӽФ
 */
.macro EXCEPT intr
	SAVE
	call	incrementNest

	call	*(exceptHandler + (\intr * 4))

	call	doSignal
	movl	%eax, %esi

	cli
	call	decrementNest
	cmpl	$YES, %esi		// åġԲĥե饰
	jne		1f
	SWITCH
1:
	RESTORE
.endm

/*
 * ǥХ
 *ճԲĤǸƤӽФ
 */
.macro TRAP irq
	pushl	$0				// 顼
	SAVE
	call	incrementNest
	sti

	// 桼ߤǥܹԤ뤿ᤳesp¸Ƥ
//	SAVE_ESP

	pushl	$\irq
	call	*(devIntrHandler + (\irq * 4))
	addl	$4, %esp
	movl	%eax, %esi		// ֤ͤ¸

//	RESTORE_ESP

	call	doSignal
	orl		%eax, %esi		// ϥɥ֤ͤȥӥå

	// Υ˰ܹԤޤǳ߶ػ
	cli
	call	decrementNest

	cmpl	$YES, %esi
	jne		1f
	SWITCH
1:
	pushl	$\irq
	call	*devEoi
	addl	$4, %esp

	RESTORE
.endm


.text


//--------------------------------------------------------------------------------------------------
// 㳰
//--------------------------------------------------------------------------------------------------

GLOBAL(except0)
	pushl	$0
	EXCEPT 0
GLOBAL(except1)
	pushl	$0
	EXCEPT 1
GLOBAL(except2)
	pushl	$0
	EXCEPT 2
GLOBAL(except3)
	pushl	$0
	EXCEPT 3
GLOBAL(except4)
	pushl	$0
	EXCEPT 4
GLOBAL(except5)
	pushl	$0
	EXCEPT 5
GLOBAL(except6)
	pushl	$0
	EXCEPT 6
GLOBAL(except7)
	pushl	$0
	EXCEPT 7
GLOBAL(except8)
	EXCEPT 8
GLOBAL(except9)
	pushl	$0
	EXCEPT 9
GLOBAL(except10)
	EXCEPT 10
GLOBAL(except11)
	EXCEPT 11
GLOBAL(except12)
	EXCEPT 12
GLOBAL(except13)
	EXCEPT 13
GLOBAL(except14)
	EXCEPT 14
GLOBAL(except15)
	pushl	$0
	EXCEPT 15
GLOBAL(except16)
	pushl	$0
	EXCEPT 16
GLOBAL(except17)
	EXCEPT 17
GLOBAL(except18)
	pushl	$0
	EXCEPT 18
GLOBAL(except19)
	pushl	$0
	EXCEPT 19

//--------------------------------------------------------------------------------------------------
// ǥХ
//--------------------------------------------------------------------------------------------------

GLOBAL(devIrq0)
	TRAP 0
GLOBAL(devIrq1)
	TRAP 1
GLOBAL(devIrq2)
	TRAP 2
GLOBAL(devIrq3)
	TRAP 3
GLOBAL(devIrq4)
	TRAP 4
GLOBAL(devIrq5)
	TRAP 5
GLOBAL(devIrq6)
	TRAP 6
GLOBAL(devIrq7)
	TRAP 7
GLOBAL(devIrq8)
	TRAP 8
GLOBAL(devIrq9)
	TRAP 9
GLOBAL(devIrq10)
	TRAP 10
GLOBAL(devIrq11)
	TRAP 11
GLOBAL(devIrq12)
	TRAP 12
GLOBAL(devIrq13)
	TRAP 13
GLOBAL(devIrq14)
	TRAP 14
GLOBAL(devIrq15)
	TRAP 15
GLOBAL(devIrq16)
	TRAP 16
GLOBAL(devIrq17)
	TRAP 17
GLOBAL(devIrq18)
	TRAP 18
GLOBAL(devIrq19)
	TRAP 19

//--------------------------------------------------------------------------------------------------
// ƥॳ
//--------------------------------------------------------------------------------------------------

/*
 *աեå¸ѹ"SYSCALL_PARAM""SYSCALL*_FRAME"ѹɬ
 * eax = ƥॳֹ
 */
#define SYSCALL_PARAM 44			// ƥॳѥ᡼
GLOBAL(syscall)
	pushl	%esi
	pushl	%edi
	pushl	%ebp
	movl	%eax, %esi				// ƥॳֹesi¸
	movl	$KERNEL_DATA_DES, %edx
	movl	%edx, %ds
	movl	%edx, %es
	cld

	call	incrementNest
	call	calcTaskUserTime
	call	setTaskCurrentTime
#ifdef DEBUG
	pushl	syscall_table(,%esi, 4)
	call	saveSyscallEntry
	addl	$4, %esp
#endif

	movl	SYSCALL_PARAM(%esp), %eax
	pushl	%eax
	movl	SYSCALL_PARAM(%esp), %ecx
	pushl	%ecx
	movl	SYSCALL_PARAM(%esp), %edx
	pushl	%edx
	movl	SYSCALL_PARAM(%esp), %eax
	pushl	%eax
	movl	SYSCALL_PARAM(%esp), %ecx
	pushl	%ecx
	movl	SYSCALL_PARAM(%esp), %edx
	pushl	%edx
	call	*syscall_table(, %esi, 4)
	addl	$4 * 6, %esp
	movl	%eax, %esi				// ͤesi¸
	movl	%edx, %edi				// ͤedi¸

	call	calcTaskSysTime
	call	setTaskCurrentTime
#ifdef DEBUG
	call	displaySyscallEnd
#endif
	call    doSignal
	movl	%eax, %ebp				// ͤesi¸
	call	decrementNest

	// å
	cmpl	$YES, %ebp
	jne		1f
	call	wait_task
1:
	movl	$USER_DATA_DES, %edx
	movl	%edx, %ds
	movl	%edx, %es
	movl	%esi, %eax
	movl	%edi, %edx
	popl	%ebp
	popl	%edi
	popl	%esi
	lret	$4 * 7

/*
 * ⥸塼ѥƥॳ
 * eax = ƥॳֹ
 */
#define SYSCALL_PARAM_MODULE 32			// ƥॳѥ᡼
GLOBAL(syscallModule)
	movl	$KERNEL_DATA_DES, %edx
	movl	%edx, %ds
	movl	%edx, %es
	cld

	pushl	%eax
	call	incrementNest
	popl	%eax

	movl	SYSCALL_PARAM_MODULE(%esp), %ecx
	pushl	%ecx
	movl	SYSCALL_PARAM_MODULE(%esp), %edx
	pushl	%edx
	movl	SYSCALL_PARAM_MODULE(%esp), %ecx
	pushl	%ecx
	movl	SYSCALL_PARAM_MODULE(%esp), %edx
	pushl	%edx
	movl	SYSCALL_PARAM_MODULE(%esp), %ecx
	pushl	%ecx
	movl	SYSCALL_PARAM_MODULE(%esp), %edx
	pushl	%edx
	call	*syscall_table(, %eax, 4)
	addl	$4 * 6, %esp

	pushl	%eax
	call	decrementNest
	popl	%eax

	movl	$USER_DATA_DES, %edx
	movl	%edx, %ds
	movl	%edx, %es
	lret	$4 * 7

/*
 * ⥸塼ĥƥॳ
 * eax = ƥॳֹ
 * ebx = 
 * ecx = 
 * edx = 
 * esi = 
 * edi = 
 * ebp = 
 */
GLOBAL(moduleInit)
	pushl	$0
	pushal
	pushl	%es
	pushl	%ds
/*	pushl	%fs
	pushl	%gs*/
	pushl	%eax			// ƥॳֹ
	movl	$KERNEL_DATA_DES, %eax
	movl	%eax, %es
	movl	%eax, %ds
	cld
	popl	%eax

	// 桼ESP¸
	movl	14 * 4(%esp), %edx
	movl	%edx, %ss: KERNEL_USER_ESP

	pushl	%ebp			// 
	pushl	%edi			// 
	pushl	%esi			// 
	pushl	%edx			// 
	pushl	%ecx			// 
	pushl	%ebx			// 
	call	*syscall_table(,%eax,4)

	addl	$4 * 6, %esp

	RESTORE

/*
 * ưǽEXEC
 */
GLOBAL(startExec)
	pushl	12(%esp)
	pushl	12(%esp)
	pushl	12(%esp)
	pushl	$0					// 桼ƥॳEIPʬ
	pushl	$KERNEL_CODE_DES
	movl	$SYS_EXEC, %eax
	call	syscall
	addl	$4 * 5, %esp
	ret

//--------------------------------------------------------------------------------------------------
// å
//--------------------------------------------------------------------------------------------------

/*
 *ճ߶ػߤǸƤФ뤳
 * void wait_task()
 */
GLOBAL(wait_task)
	// åΥƥȤ
	popl	%eax				// ƤӽФeip
	pushfl
	orl		$0x200, (%esp)		// äƤȤ߲Ĥˤ
	pushl	$KERNEL_CODE_DES
	pushl	%eax
	pushl	$0					// 顼
	SAVE
	SWITCH
	RESTORE

/*
 * forkλҥץΥƥȤۤ롣
 * ҥץϤδؿ꤫鳫Ϥ롣
 * int setChildContext(
 *	void*);				// ҥץͥ륹åʪɥ쥹
 * return : YES = ҥץ or NO = ƥץ
 */
GLOBAL(setChildContext)
	// åƤҥåإԡ
	movl	$KERNEL_STACK_END, %eax
	subl	%esp, %eax				// ԡ
	movl	4(%esp), %edx			// ҥץåѥ꡼
	addl	$PAGE_SIZE, %edx
	subl	%eax, %edx				// ԡ襢ɥ쥹
	movl	%esp, %ecx
	pushl	%eax
	pushl	%ecx
	pushl	%edx
	call	memcpy
	addl	$12, %esp

	// espҥץå꡼
	movl	%esp, %edx				// setChildContextƤӽФesp
	addl	$4, %edx				// setChildContextƤӽФesp
	andl	$0xfff, %edx
	movl	4(%esp), %eax			// ҥץåѥ꡼
	orl		%edx, %eax

	// ƥȤ
	movl	%esp, %ecx				// esp¸
	cli
	movl	%eax, %esp
	pushfl
	orl		$0x200, (%esp)			// ߲Ĥ˥å
	pushl	%cs
	pushl	(%ecx)					// setChildContexteip
	movl	$YES, %eax				// ҥץ꥿ = YES
	pushl	$0						// 顼
	SAVE
	SAVE_CREATE_ESP
	movl	%ecx, %esp				// esp᤹
	sti

	movl	$NO, %eax
	ret

/*
 * ʪåɥ쥹˥ƥȤꤹ
 * void saveStackEsp(
 *	void *)		// ʪåƥȥƬݥ
 */
GLOBAL(saveStackEsp)
	movl	%esp, %ebx
	movl	4(%esp), %esp
	SAVE_CREATE_ESP
	movl	%ebx, %esp
	ret

//--------------------------------------------------------------------------------------------------
// Ʊͥ桼֥å
//--------------------------------------------------------------------------------------------------

/*
 * 桼᥽åɤƤӽФ
 * void doCallUserMethod(
 *	const void *method,				// user method pointa
 *	const uint param1,				// parameter 1
 *	const uint param2,				// parameter 2
 *	const uint param3,				// parameter 3
 *	const uint param4,				// parameter 4
 *	const uint param5,				// parameter 5
 *	const uint param6,				// parameter 6
 *	const void *taskChangeMethod,	// ܹԥ᥽å
 *	const void *taskRestoreMethod)	// ᥽å
 */
#define PARAM_NUM 8
GLOBAL(doCallUserMethod)
	pushl	%ebp
	pushl	%esi
	pushl	%edi
	pushl	%ebx

	pushl	$PARAM_NUM
	call	getTaskParamBuf
	addl	$4, %esp
	movl	%eax, %ebx					// parameter buffer
	
	// ѥ᡼򥳥ԡ
	movl	20(%esp), %eax
	movl	%eax, 4 * 0(%ebx)			// user method pointa
	movl	24(%esp), %ecx              
	movl	%ecx, 4 * 1(%ebx)			// parameter 1
	movl	28(%esp), %edx	            
	movl	%edx, 4 * 2(%ebx)			// parameter 2
	movl	32(%esp), %esi	            
	movl	%esi, 4 * 3(%ebx)			// parameter 3
	movl	36(%esp), %edi	            
	movl	%edi, 4 * 4(%ebx)			// parameter 4
	movl	40(%esp), %ebp	            
	movl	%ebp, 4 * 5(%ebx)			// parameter 5
	movl	44(%esp), %eax	            
	movl	%eax, 4 * 6(%ebx)			// parameter 6
	movl	52(%esp), %ecx	            
	movl	%ecx, 4 * 7(%ebx)			// ᥽å

	cli

	// ܹԤ
	call	*48(%esp)					// eax = Page directory

	// ۥ꡼֤ܹԤ
	movl	%esp, KERNEL_SAVE_ESP		// åľESP¸
	movl	%eax, %cr3

	// FPUԲ㳰Ĥˤ
	call	setTs

	// 桼å˥ѥ᡼ꤹ
	movl	%esp, %ebp					// ͥ륹åݥ󥿤
	movl	KERNEL_USER_ESP, %esp		// user esp
	pushl	4 * 6(%ebx)					// parameter 6
	pushl	4 * 5(%ebx)					// parameter 5
	pushl	4 * 4(%ebx)					// parameter 4
	pushl	4 * 3(%ebx)					// parameter 3
	pushl	4 * 2(%ebx)					// parameter 2
	pushl	4 * 1(%ebx)					// parameter 1
	pushl	KERNEL_USER_RET				// user return method pointa
	movl	%esp, %edi					// user esp    edi = userCall parameter
	movl	%ebp, %esp					// ͥ륹åݥ󥿤᤹

	sti

	movl	4 * 0(%ebx), %esi			// user method esi = userCall parameter
	movl	4 * 7(%ebx), %eax			// ᥽å
	movl	%eax, KERNEL_RESTORE_METHOD

	// 桼˰ܹ
	jmp		*userCall					// changeUserCall()ꤵ

/*
 * 桼ɥ饤Сߥ᥽åɤƤӽФ
 * void sendUserIntrMethod(
 *	VmTaskObj *moduleVmTask,		// ⥸塼륿ۥ꡼¤
 *	void *method,					// ߥ᥽å
 *	uint esp,						// ɥ饤СåESP
 *	void *taskChangeMethod,			// ܹԥ᥽å
 *	void *taskRestoreMethod)		// ᥽å
 */
GLOBAL(sendUserIntrMethod)
	pushl	%ebp
	pushl	%esi
	pushl	%edi
	pushl	%ebx

	// ѥ᡼쥸˥ԡ
	movl	4 * 5(%esp), %eax			// moduleVmTask
	movl	4 * 6(%esp), %esi			// user method esi = userCall parameter
	movl	4 * 7(%esp), %edi			// user esp    edi = userCall parameter
	movl	4 * 8(%esp), %edx			// taskChangeMethod
	movl	4 * 9(%esp), %ebx			// taskRestoreMethod

	cli

	// ܹԤ
	pushl	%eax
	call	*%edx						// eax = Page directory
	addl	$4, %esp

	// ۥ꡼ֹ
	movl	%esp, KERNEL_SAVE_ESP		// åľESP¸
	movl	%eax, %cr3

	// FPUԲ㳰Ĥˤ
	call	setTs

	sti

	// ܹԸ奫ͥ륹å
	movl	%ebx, KERNEL_RESTORE_METHOD	// taskRestoreMethod

	// 桼᥽åɤƤӽФ
	jmp		*userCall					// changeUserCall()ꤵ

/*
 * 桼᥽åɤ
 */
GLOBAL(returnUserMethod)
	movl	$KERNEL_DATA_DES, %edx
	movl	%edx, %ds
	movl	%edx, %es
	cld

	// ֤ͤ
	movl	%eax, %ebp

	cli

	// FPU֥ɥ쥹򥯥ꥢ
	call	clearFpuSaveAddr

	// ۥ꡼֤᤹
	call	*KERNEL_RESTORE_METHOD		// eax = Page directory
	movl	%eax, %cr3
	movl	KERNEL_SAVE_ESP, %esp		// ͥ륹åݥ󥿤᤹

	sti

	// ǥХԲ㳰
	call	setTs

	// ֤᤹ͤ
	movl	%ebp, %eax

	// callUserMethodƤӽФ
	popl	%ebx
	popl	%edi
	popl	%esi
	popl	%ebp
	ret

/*
 * 桼ܹԥ롼󥢥ɥ쥹ѹ
 * changeUserCall()
 */
GLOBAL(changeUserCall)
	movl	$userCallSysexit, userCall
	ret

// 桼ܹԥ롼󥢥ɥ쥹
GLOBAL(userCall)
	.long	userCallRet

/*
 * ̾桼ϥɥܹ
 * in   : esi = ⥸塼ɥ쥹, edi = 桼ESP
 * work : eax
 */
GLOBAL(userCallRet)
	movl	$USER_DATA_DES, %eax
	movl	%eax, %ds
	movl	%eax, %es
	pushl	$USER_DATA_DES				// 桼SS
	pushl	%edi						// 桼ESP
	pushl	$USER_CODE_DES				// 桼CS
	pushl	%esi						// ⥸塼ɥ쥹
	lret

/*
 * sysexit桼ϥɥܹ
 * in   : esi = user method, edi = user esp
 * work : eax
 */
GLOBAL(userCallSysexit)
	movl	$USER_DATA_DES, %eax
	movl	%eax, %ds
	movl	%eax, %es
	movl	%edi, %ecx					// 桼ESP
	movl	%esi, %edx					// ⥸塼ɥ쥹
	sysexit
