/*
 * UserHandler.c
 *
 * Copyright 2008, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 *Գסեʥ桼ϥɥƤӽФ
 *
 *
 *
 *ԸƤ
 */


#include <sys/config.h>
#include <sys/types.h>
#include <sys/param.h>
#include <kern/physical_mem.h>
#include <kern/Thread.h>
#include <kern/vm.h>
#include <i386/vm.h>
#include <i386/interrupt.h>
#include <i386/tss.h>
#include <i386/fpu.h>
#include <i386/UserHandler.h>

#include <kern/debug.h>


//#define DEBUG_USER_HANDLER 1
#ifdef DEBUG_USER_HANDLER
	#define STATIC
	#define INLINE
#else
	#define STATIC	static
	#define INLINE	inline
#endif


//=====================================  ===================================================

//===================================== Х륤ݡ =======================================

extern int doCallUserMethod(
	const void *,
	const uint, 
	const uint, 
	const uint, 
	const uint, 
	const uint, 
	const uint, 
	const void*,
	const void*);

//===================================== PRIVATE ====================================================

//===================================== PUBLIC =====================================================

/*
 * 桼ϥɥƤӽФ
 */
void callUserHandler(
	void *i_handler,		// 桼ϥɥ
	void *i_returnMethod,	// 桼ϥɥ餫᥽å
	const int i_param)		// ʥֹ
{
	char *handlerStack = getUserHandlerStack(getVmTask(getCurrentTask()));
	
	*(uint*) (handlerStack + (KERNEL_USER_ESP & (PAGE_SIZE - 1))) = USER_ESP_BEG;
	*(void**) (handlerStack + (KERNEL_USER_RET & (PAGE_SIZE - 1))) = i_returnMethod;

	// 桼᥽åɤƤӽФ
	doCallUserMethod(
		i_handler,
		i_param,
		0,0,0,0,0,
		vmChangeSignalHandlerStack,
		vmChangeSignalHandlerStack);
}

/*
 * ̥桼᥽åɤƤӽФ
 */
int callUserMethod(
	void *i_callTask,		// 桼
	void *i_method,			// 桼᥽å
	const uint i_param1,	// ѥ᡼
	const uint i_param2,	// ѥ᡼
	const uint i_param3,	// ѥ᡼
	const uint i_param4,	// ѥ᡼
	const uint i_param5,	// ѥ᡼
	const uint i_param6)	// ѥ᡼
{
	int error;

	setCallTask(i_callTask);

	// 桼⡼ɤɣľܤǤ褦ꤹ
	setUserModeIo();

	// 桼᥽åɤƤӽФ
	error = doCallUserMethod(
		i_method,
		i_param1,
		i_param2,
		i_param3,
		i_param4,
		i_param5,
		i_param6,
		changeCallTask,
		restoreCallTask);

	// ͥ⡼ɣɣϤ᤹
	setKernelModeIo();
	
	return error;
}

/*
 * åХåեݥ󥿤
 * return : ȤΥХѥ᡼ݥ
 */
uint *getTaskParamBuf(
	const int i_paramNum)
{
	ASSERT(i_paramNum < TASK_PARAM_BUF);

	return getParamBuf(getCurrentTask());
}

//**************************************************************************************************

#ifdef DEBUG
void testUserHnadler(uint *value)
{
	static int cnt = 0;

	printk("testUserHnadler %d\n", ++cnt);
}
#endif
