/*
 * apm_asm.S
 *
 * Copyright 2004, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#define ASM_FILE


#include <i386/segment.h>
#include "apm.h"


.text
.code32

/*
 * ץƥȥ⡼APM BIOS CALL
 * int apmBiosCall(
 *	APM_FUNC_ARGS *args)	function args
 * return : 0 or apm error number
 */
.globl apmBiosCall
apmBiosCall:
	pushl	%ebx
	pushl	%esi
	pushl	%edi
	pushl	%ebp

//	movl	$APM_DATA_DES,%eax
//	movl	%eax,%ds
//	movl	%eax,%es

	// 쥸
	movl	20(%esp), %ebp			/* args address. */
	movl	(%ebp), %eax
	movl	4(%ebp), %ebx
	movl	8(%ebp), %ecx
	movl	12(%ebp), %edx
	movl	16(%ebp), %esi
	movl	20(%ebp), %edi
	movb	$APM_FUNC, %ah

	lcall	*%ss: apmfarCall		/* Invoke APM function. */
	jc		1f						// 顼ʤ饸

	movl	20(%esp), %ebp			/* args address. */
	movl	%eax, (%ebp)
	movl	%ebx, 4(%ebp)
	movl	%ecx, 8(%ebp)
	movl	%edx, 12(%ebp)
	movl	%esi, 16(%ebp)
	movl	%edi, 20(%ebp)
	xorl	%eax, %eax
1:
//	movl	$KERNEL_DATA_DES, %edx
//	movl	%edx, %ds
//	movl	%edx, %es

	shrl	$8, %eax
	andl	$0xff, %eax
	popl	%ebp
	popl	%edi
	popl	%esi
	popl	%ebx
	ret

/*
 * ꥢ⡼APM BIOS CALL
 * int apmBiosCallReal(
 *	APM_FUNC_ARGS *args)	function args
 * return : 0 or apm error number
 */
.globl apmBiosCallReal
apmBiosCallReal:
	pushl	%ebx
	pushl	%esi
	pushl	%edi
	pushl	%ebp

	// 쥸
	movl	20(%esp), %ebp			/* args address. */
	movl	(%ebp), %eax
	movb	$APM_FUNC, %ah
	movl	4(%ebp), %ebx
	movl	8(%ebp), %ecx
	movl	12(%ebp), %edx
	movl	16(%ebp), %esi
	movl	20(%ebp), %edi

	movw	%ax, realModeArgs
	movw	%bx, realModeArgs + 2
	movw	%cx, realModeArgs + 4
	movw	%dx, realModeArgs + 6
	movw	%si, realModeArgs + 8
	movw	%di, realModeArgs + 10

	// ꥢ⡼ɤ˰ܹ
	pushl	$realModeCall
	call	switchRealMode
	// äƤʤϤ

.code16
realModeCall:
	movw	realModeArgs,      %ax
	movw	realModeArgs + 2,  %bx
	movw	realModeArgs + 4,  %cx
	movw	realModeArgs + 6,  %dx
	movw	realModeArgs + 8,  %si
	movw	realModeArgs + 10, %di
	int		$APM_BIOS
loop:
	jmp		loop					// ʵץ롼

realModeArgs:
	.word
	.word
	.word
	.word
	.word
	.word
