/*
 * i386/lib.c
 *
 * Copyright 2007, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 *
 */


#include <sys/config.h>
#include <sys/types.h>
#include <sys/param.h>
#include <kern/proc.h>
#include <i386/segment.h>
#include <i386/lib.h>

#include <kern/debug.h>


//#define DEBUG_I386_LIB 1
#ifdef DEBUG_I386_LIB
	#define STATIC
	#define INLINE
#else
	#define STATIC	static
	#define INLINE	inline
#endif


//==================================  ===========================================

//================================== Х륤ݡ ===============================

extern void switchRealMode(void *);
extern void jumpToBios();

//================================== PRIVATE ============================================

/*
 * ꥢ⡼IDTơ֥륻ΰ
 */
static char realIdt[0x400];

//================================== PROTECT ============================================

//================================== PUBLIC =============================================

void saveRealIdt()
{
	memcpy(realIdt, (void*) 0, 0x400);
}

void storeRealIdt()
{
	memcpy((void*) 0, realIdt, 0x400);
}

void reboot()
{
	switchRealMode(jumpToBios);
}
