/*
 * lib.h
 *
 * Copyright 2007, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#ifndef i386_lib_h
#define i386_lib_h


#ifndef ASM_FILE


static inline u_int bsfl(u_int mask)
{
	u_int	result;

	asm volatile("bsfl %0,%0" : "=r" (result) : "0" (mask));
	return (result);
}

static inline int ffs(int mask)
{
	/*
	* Note that gcc-2's builtin ffs would be used if we didn't declare
	* this inline or turn off the builtin.  The builtin is faster but
	* broken in gcc-2.4.5 and slower but working in gcc-2.5 and later
	* versions.
	*/
	return (mask == 0 ? mask : bsfl((u_int)mask) + 1);
}

extern void reboot();
extern void saveRealIdt();


#endif


#endif
