/*
 * segmnet.c
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#include <sys/types.h>
#include <i386/syscall.h>
#include <i386/UserHandler.h>
#include <i386/Entry.h>
#include <i386/segment.h>

#include <kern/debug.h>


//#define DEBUG_I386_SEGMENT 1
#ifdef DEBUG_I386_SEGMENT
	#define STATIC
	#define INLINE
#else
	#define STATIC	static
	#define INLINE	inline
#endif


//===================================== Х륤ݡ =======================================

//===================================== PRIVATE ====================================================

/*
 * Set call gate discriptor
 */
STATIC void set_gate(
	int des,			// ǥץ
	void *addr,			// ᥽åɥɥ쥹
	uchar para_num)		// ѥ᡼
{
	gdt[des / 8].low = ((uint) addr & 0xffff) | (KERNEL_CODE_DES << 16);
	gdt[des / 8].high = ((uint) addr & 0xffff0000) | 0xec00 | para_num;
}

//===================================== PUBLIC =====================================================

/*
 * GDT
 */
DESCRIPTOR gdt[GDT_ENTRY]=
{
	{0,0},
	{0x0000ffff,0x00cf9a00},	/* ͥ륳ɥȡ */
	{0x0000ffff,0x00cf9200},	/* ͥǡȡ */
	{0x0000ffff,0x00cffa00},	/* 桼ɥȡ */
	{0x0000ffff,0x00cff200},	/* 桼ǡȡ */
	{0x0000ffff,0x00009a00},	/* ¥ɥ쥹⡼ѥɥȡ */
	{0x0000ffff,0x00009200},	/* ¥ɥ쥹⡼ѥǡȡ */
};

/*
 * ǥץ˥ɥ쥹ꤹ롣
 * ߥåȥ-1Τǡͤ0Ȥʤ롣
 */
void set_gdt(
	int des,		// ǥץ
	uint addr,		// ١ɥ쥹
	uint size,		// ߥåȥ
	int flag)		// ץե饰
{
	gdt[des/8].low=0;
	gdt[des/8].high=0;

	size-=1;

	/* ١ɥ쥹 */
	gdt[des/8].low|=addr<<16;
	gdt[des/8].high|=(addr>>16)&0xff;
	gdt[des/8].high|=addr&0xff000000;

	/* ߥåȥ */
	if(flag&0x100000)size>>=12;
	gdt[des/8].low|=size&0xffff;
	gdt[des/8].high|=size&0xf0000;

	/* ץե饰 */
	gdt[des/8].high|=flag;
}

void initSyscallGate()
{
	set_gate(SYSCALL_SEG, syscall, 7);
	set_gate(SYSCALL_MODULE_SEG, syscallModule, 7);
	set_gate(RETURN_METHOD_SEG, returnUserMethod, 0);
}
