/*
 * segment.h
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#ifndef i386_segment_h
#define i386_segment_h


#include <sys/types.h>
#include <sys/config.h>


// ꥢ⡼ɥȡ쥸
#define	REAL_DATA_SEG	0
#define	REAL_SS_SEG		0x9000				/* StackϰͤƻѲǽ꡼ΰü */
#define	REAL_SP_REG		(0x10000-0x400)		/* åݥ */

// ץƥȥ⡼ɥ
#define	KERNEL_CODE_DES	0x8					/* ͥ륳ɥǥץ͡ */
#define	KERNEL_DATA_DES	0x10				/* ͥǡǥץ͡ */
#define	USER_CODE_DES	0x1b				/* 桼ɥǥץ͡ */
#define	USER_DATA_DES	0x23				/* 桼ǡǥץ͡ */
#define REAL_CODE_DES	0x28				/* ¥ɥ쥹⡼ѥǥץ͡ */
#define REAL_DATA_DES	0x30				/* ¥ɥ쥹⡼ѥǥץ͡ */
#define APM_CODE_DES	0x38				/* APM BIOSɥǥץ͡ */
#define APM_CODE16_DES	0x40				// APM BIOS16bitɥǥץ͡APM_CODE_DESμɬɬ
#define APM_DATA_DES	0x48				/* APM BIOSǡǥץ͡ */
#define	TSS_DES			0x50				/* TSSǥץ͡ */
#define GATE_DES		(TSS_DES + MAX_CPU * 8)	/* value of Call gate discriptor. */

// ƥॳ륲ȥ
#define SYSCALL_SEG			GATE_DES
#define SYSCALL_MODULE_SEG	GATE_DES + 8
#define RETURN_METHOD_SEG	GATE_DES + 16

#ifdef KERNEL

#define GDT_ENTRY       256					/* GDȥ꡼ */

#endif


#ifndef ASM_FILE


#ifdef KERNEL

/* ǥץ¤ */
typedef struct{
	uint low;
	uint high;
} DESCRIPTOR;

/* ǥץơ֥쥸¤ */
typedef struct{
	ushort num;
	DESCRIPTOR *des __attribute__((packed));
}DTR;

/* far callѴܥɥ쥹 */
typedef struct{
	int addr;
	short des __attribute__((packed));
}FARCALL_ADDR;


enum{
	TYPE_KERNEL_CODE	= 0xc09a00,		/* ͥ륳ɥǥץѥץե饰 */
	TYPE_KERNEL_DATA	= 0xc09200,		/* ͥ륳ɥǥץѥץե饰 */
	TYPE_USER_CODE		= 0xc0fa00,		/* 桼ɥǥץѥץե饰 */
	TYPE_USER_DATA		= 0xc0f200,		/* 桼ɥǥץѥץե饰 */
	TYPE_KERNEL_CODE16	= 0x809a00,		/* 16bitͥ륳ɥǥץѥץե饰 */
	TYPE_KERNEL_DATA16	= 0x809200,		/* ͥ륳ɥǥץѥץե饰 */
	TYPE_TSS			= 0x8900,		/* TSSѥץե饰 */
};


extern DTR gdtr;
extern DESCRIPTOR gdt[];

extern void set_gdt(int, uint, uint, int);
extern void initSyscallGate();

#else	// !KERNEL

extern void returnUser(uint);

#endif	// KERNEL


#endif // ASM_FILE


#endif
