/*
 * syscall.c
 *
 * Copyright 2008, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 *Գס
 *
 *
 *
 *ԸƤ
 */


#include <sys/config.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/syscall.h>
#include <i386/segment.h>
#include <i386/Cpu.h>
#include <i386/interrupt.h>
#include <i386/syscall.h>

#include <kern/debug.h>


//#define DEBUG_MODE_SWITCH 1
#ifdef DEBUG_MODE_SWITCH
	#define STATIC
	#define INLINE
#else
	#define STATIC	static
	#define INLINE	inline
#endif


//=====================================  ===================================================

//===================================== Х륤ݡ =======================================

extern void moduleInit();

//===================================== PRIVATE ====================================================

//===================================== PUBLIC =====================================================

/*
 * Init system call
 */
void init_syscall()
{
	initSyscallGate();
	set_idt(SYSCALL_VECTOR, moduleInit, IDT_USER);
}

uint getFrame0UserEsp(
	const SYSCALL0_INTR_FRAME *i_frame)
{
	return i_frame->context.user_esp;
}

uint getFrame1UserEsp(
	const SYSCALL1_INTR_FRAME *i_frame)
{
	return i_frame->context.user_esp;
}

uint getFrame2UserEsp(
	const SYSCALL2_INTR_FRAME *i_frame)
{
	return i_frame->context.user_esp;
}
