/*
 * BufPool.c
 *
 * Copyright 2007, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 *Ū
 * ΥΥ꡼ˤ˳Ƥˡ֤ṳ̂롣
 *
 *Գס
 * ǽ礭ʥǳƤƤꥵڤФƤ
 *
 *
 * ֤ṳ̂뤿¾ϤƤʤΤǡޥϸƤӽФ¾򤫤ɬפ롣
 */


#include <sys/config.h>
#include <sys/types.h>
#include <sys/param.h>
#include <lib/lib.h>
#include <lib/bitmap.h>
#include <kern/vm.h>
#include <kern/kmalloc.h>
#include <kern/BufPool.h>

#include <kern/debug.h>


//#define DEBUG_BUFPOOL 1
#ifdef DEBUG_BUFPOOL
	#define STATIC
	#define INLINE
#else
	#define STATIC	static
	#define INLINE	inline
#endif


//==================================  ===========================================

//================================== PRIVATE ============================================

//================================== PUBLIC =============================================

/*
 * ̤ѥХåե
 * return : ̤ѥХåեɥ쥹 or NULL
 */
void *allocBufPool(
	BufPool *m_bufPool)
{
	int unusedUnit = getBitmapEmptyPos(0, m_bufPool->maxUnits, m_bufPool->bitmap);
	
	if (unusedUnit == ERR) {
		return NULL;
	}
	
	setBitmapBit(unusedUnit, m_bufPool->bitmap);
	
	return (void*) ((uint) m_bufPool->bufPool + m_bufPool->unitBytes * unusedUnit);
}

/*
 * Хåե
 */
void freeBufPool(
	const void *unitAddr,
	BufPool *m_bufPool)
{
	int freeUnit = ((uint) unitAddr - (uint) m_bufPool->bufPool) / m_bufPool->unitBytes;
	
	ASSERT(freeUnit <= m_bufPool->maxUnits);
	
	resetBitmapBit(freeUnit, m_bufPool->bitmap);
}

/*
 * 
 */
void BufPoolConstruct(
	BufPool *this,
	const int unitBytes,	// ñ̤ΥХȿ
	const int maxUnits)		// ǽ˳ƤĿ
{
	int bitmapSize;

	WARNING(unitBytes * maxUnits <= PAGE_SIZE);

	// Хåեסγ
	this->bufPool = kmalloc(unitBytes * maxUnits);

	ASSERT(this->bufPool != NULL);

	// ӥåȥޥåפγ
	bitmapSize = sizeof(char) * ROUNDUP_DIV(maxUnits, BYTE_BITNUM);
	this->bitmap = kmalloc(bitmapSize);

	ASSERT(this->bitmap != NULL);

	memset(this->bitmap, 0, bitmapSize);

	// С
	this->unitBytes = unitBytes;
	this->maxUnits = maxUnits;
}

/*
 * λ
 */
void BufPoolDestruct(
	BufPool *this)
{
	int bitmapBytes = ROUNDUP_DIV(this->maxUnits, BYTE_BITNUM);
	int i;
	
	// Υ꡼뤫
	for (i = 0; i < bitmapBytes; ++i) {
		if (this->bitmap[i] != 0) {
			WARNING(0);
			break;
		}
	}
	
	// ꡼
	kfree(this->bitmap);
	kfree(this->bufPool);
}
