/*
 * Hierarchy.c
 *
 * Copyright 2008, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 *Գסեץ
 *
 *¾ϸƤӽФ¦ǹԤ
 *
 *ԸƤ
 */


#include <sys/config.h>
#include <sys/types.h>
#include <sys/param.h>
#include <kern/lock.h>
#include <kern/ProcSignal.h>
#include <kern/Hierarchy.h>

#include <kern/debug.h>


//#define DEBUG_PROC_LIST 1
#ifdef DEBUG_PROC_LIST
	#define STATIC
	#define INLINE
#else
	#define STATIC	static
	#define INLINE	inline
#endif


//=====================================  ===================================================

/*
 * ץع¤
 *ԱƶեСѹHierarchyObjΥѹ뤳
 */
typedef struct {
	List			list;
	AggregateList	aggrChild;		// ҥץꥹȽ
	void 			*proc;			// ץ
	void 			*parent;		// ƥץ
} Hierarchy;

//===================================== Х륤ݡ =======================================

//===================================== PRIVATE ====================================================

//===================================== PUBLIC =====================================================

int HierarchyInit()
{
#ifdef DEBUG
	if (sizeof(Hierarchy) != sizeof(HierarchyObj)) {
		printk("HierarchyInit() object size error! Hierarchy=%d HierarchyObj=%d\n", sizeof(Hierarchy), sizeof(HierarchyObj));
		idle();
	}
#endif

	return NOERR;
}

void HierarchyConstructor(
	HierarchyObj *i_this,
	void *i_proc)
{
	Hierarchy *this = (Hierarchy*) i_this;

	listConstructor(&this->list, this);
	AggregateListConstructor(&this->aggrChild);
	this->proc = i_proc;
	this->parent = NULL;
}

void HierarchyDestructor(
	HierarchyObj *i_this)
{
	// ⤷ʤ
}

//--------------------------------------------------------------------------------------------------
// Getter
//--------------------------------------------------------------------------------------------------

/*
 * ץ
 * return : ץ
 */
void *HierarchyGetProc(
	HierarchyObj *i_this)
{
	Hierarchy *this = (Hierarchy*) i_this;
	return this->proc;
}

/*
 * ץ
 * return : ץ
 */
void *HierarchyGetParent(
	HierarchyObj *i_this)
{
	Hierarchy *this = (Hierarchy*) i_this;
	return this->parent;
}

//--------------------------------------------------------------------------------------------------
// Search
//--------------------------------------------------------------------------------------------------

/*
 * ǽλҥץ
 *HierarchyLock()ƤӽФƤ뤳
 * return : ҥץع¤ or NULL
 */
HierarchyObj *HierarchyGetFirstChild(
	HierarchyObj *i_this)
{
	Hierarchy *this = (Hierarchy*) i_this;

	return this->aggrChild.refHead(&this->aggrChild);
}

/*
 * λҥץ
 *HierarchyLock()ƤӽФƤ뤳
 * return : ҥץع¤ or NULL
 */
HierarchyObj *HierarchyGetNextChild(
	HierarchyObj *i_this,
	HierarchyObj *i_child)		// ҥץع¤
{
	Hierarchy *this = (Hierarchy*) i_this;
	Hierarchy *child = (Hierarchy*) i_child;

	return this->aggrChild.refNext(&this->aggrChild, &child->list);
}

//--------------------------------------------------------------------------------------------------
// ꥹȥ᥽å
//--------------------------------------------------------------------------------------------------

/*
 * ҥץɲä
 */
void HierarchyAddChild(
	HierarchyObj *i_this,
	HierarchyObj *i_child)
{
	Hierarchy *this = (Hierarchy*) i_this;
	Hierarchy *child = (Hierarchy*) i_child;
	AggregateList *aggrParent = &this->aggrChild;

	aggrParent->insertHead(aggrParent, &child->list);
	child->parent = this->proc;
}

/*
 * ҥץ
 *HierarchyLock()ƤӽФƤ뤳
 *Իպҥץ󥯤ν֤Ѥʤ
 */
void HierarchyRemoveChild(
	HierarchyObj *i_this,
	HierarchyObj *i_child)
{
	Hierarchy *this = (Hierarchy*) i_this;
	Hierarchy *child = (Hierarchy*) i_child;
	AggregateList *aggrParent = &this->aggrChild;

	aggrParent->removeEntry(aggrParent, &child->list);
	child->parent = NULL;
}
