/*
 * TaskSignal.h
 *
 * Copyright 2008, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#ifndef kern_TaskSignal_h
#define kern_TaskSignal_h


#ifndef ASM_FILE


/*
 *԰¸ProcHierarchyΥƱ
 */
typedef struct {
	char dummy[sizeof(int) * 5];
} TaskSignalObj;

extern void TaskSignalConstructor(TaskSignalObj*, void*);
extern void TaskSignalDestructor(TaskSignalObj*);
extern void sendSignalOnly(TaskSignalObj*, const int);
extern void sendSignal(TaskSignalObj*, const int);
extern void forceSendSignal(TaskSignalObj*, const int);
extern int isSigint(TaskSignalObj*);
extern int isEndSigint(TaskSignalObj*);

extern sigset_t *TaskSignalGetMask(TaskSignalObj*);
extern sigset_t *TaskSignalGetPending(TaskSignalObj*);

extern void setSigAllMask(TaskSignalObj*);
extern void TaskSignalStopHandler(TaskSignalObj*);
extern void TaskSignalRestartHandler(TaskSignalObj*);
extern void TaskSignalSetMask(TaskSignalObj*, const sigset_t *);
extern void TaskSignalSetPending(TaskSignalObj*, const sigset_t *);

#endif


#endif
