/*
 * devfs.c
 *
 * Copyright 2007, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 *ԳסեǥХե륷ƥ
 *
 * ¤
 *	inode¤Τǳ
 *		root inodeϣΩ
 */


#include <sys/config.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/errno.h>
#include <sys/conf.h>
#include <sys/stat.h>
#include <sys/systm.h>
#include <lib/lib.h>
#include <lib/lib_path.h>
#include <kern/vm.h>
#include <kern/kmalloc.h>
#include <kern/time.h>
#include <kern/block_cache.h>
#include <kern/device.h>
#include <kern/devfs.h>

#include <kern/debug.h>


//#define DEBUG_DEVFS 1
#ifdef DEBUG_DEVFS
	#define STATIC
	#define INLINE
#else
	#define STATIC	static
	#define INLINE	inline
#endif


//=====================================  ===================================================

//===================================== Х륤ݡ =======================================

//===================================== PRIVATE ====================================================

static int mountCount;

//----------------------------------------------------------
// ǥХINODE
//----------------------------------------------------------

enum{
	DEVICE_INODE_NUM = MAX_DEVICE_OPEN,		// ǥХinode
};

/*
 * ǥХinode
 */
typedef struct DEV_INODE {
	void	*dev;						// ǥХ
	ushort	major;						// ᥸㡼ֹ
	ushort	minor;						// ѡƥֹޥʡֹ
	uint	perms;						// եѡߥå
	int 	refCount;					// ȥ
	uint	creatTime;					// 
	char	name[MAX_DEVICE_NAME + 1];	// ǥХ̾
} DEV_INODE;

/*
 * inodeơ֥
 */
static DEV_INODE inodeTbl[DEVICE_INODE_NUM];

/*
 * ǥХ̾鸡
 * return : error number
 */
STATIC int searchByName(
	const char *i_devName,
	int *o_inodeNum)
{
	int i;

	// ǥХinodeơ֥򸡺
	for (i = 0; i < DEVICE_INODE_NUM; ++i) {
		if (0 < inodeTbl[i].refCount) {
			if (strcmp(inodeTbl[i].name, i_devName) == 0) {
				*o_inodeNum = i;
				return NOERR;
			}
		}
	}

	return -ENOENT;
}

/*
 * inode
 * return : error number
 */
STATIC int getFreeInode(
	int *o_inodeNum)
{
	int i;

	for (i = 0; i < DEVICE_INODE_NUM; ++i) {
		if (inodeTbl[i].refCount == 0) {
			*o_inodeNum = i;
			return NOERR;
		}
	}

	return -EMFILE;
}

/*
 * inodeλȥ󥿤䤹
 */
STATIC void linkInode(
	const int i_inodeNum)
{
	ASSERT(0 <= inodeTbl[i_inodeNum].refCount);

	inodeTbl[i_inodeNum].refCount += 1;
}

/*
 * inodeλȥ󥿤򣱸餹
 */
STATIC void unlinkInode(
	const int i_inodeNum)
{
	ASSERT(0 <= inodeTbl[i_inodeNum].refCount);

	// ȥȤ򸺤餹
	inodeTbl[i_inodeNum].refCount -= 1;
}

/*
 * inodeꤹ
 */
STATIC INLINE void initInode(
	const int i_inodeNum,
	void *i_dev,
	const char *i_devName,
	const int i_major,
	const int i_minor,
	const uint i_perms)
{
	// inode
	memset(&inodeTbl[i_inodeNum], 0, sizeof(inodeTbl[i_inodeNum]));
	inodeTbl[i_inodeNum].dev = i_dev;
	inodeTbl[i_inodeNum].major = i_major;
	inodeTbl[i_inodeNum].minor = i_minor;
	if (i_dev != NULL) {
		DEV_STAT devStat;

		statDev(i_dev, &devStat);
		inodeTbl[i_inodeNum].perms = i_perms | devStat.flags;
	}
	else {
		inodeTbl[i_inodeNum].perms = i_perms;
	}
	inodeTbl[i_inodeNum].creatTime = sys_time(NULL);
	strcpy(inodeTbl[i_inodeNum].name, i_devName);

	linkInode(i_inodeNum);
}

/*
 * ѥǥХ̾Ф
 * return : ǥХ̾
 */
STATIC const char *getDevName(
	const char *path)
{
	const char *devName = path;

	for (; ;) {
		if (cmpPath(".", devName, 1) == 0) {
			if (path[1] == '/') {
				devName = &path[2];
			}
			else {
				devName = &path[1];
			}
		}
		else if (cmpPath("..", devName, 2) == 0) {
			// ".."̤б
			break;
		}
		else if (cmpPath("\0", devName, 0) == 0) {
			// root inode
			if (path[0] == '/') {
				devName = &path[1];
			}
			else {
				break;
			}
		}
		else {
			break;
		}
	}
	
	return devName;
}

/*
 * ǥХθ
 * return : error number
 */
STATIC int lookupDevInode(
	const char *path,
	int *o_inodeNum)
{
	const char *devName;

	// ѥθ
	devName = getDevName(path);
	if (devName[0] == '\0') {
		*o_inodeNum = DEVICE_ROOT_INODE;
		return NOERR;
	}

	// ǥХinodeơ֥򸡺
	return searchByName(devName, o_inodeNum);
}

/*
 * Ϳ줿inodeμΥ󥯤inode֤
 * Ϳ줿inode-1ʤȥåץ󥯤inode֤
 * return : error number
 */
STATIC int getNextInode(
	int inodeNum,
	int *o_next)
{
	int i;

	if (inodeNum == -1) {
		i = DEVICE_ROOT_INODE;
	}
	else {
		i = inodeNum;
	}
	for (++i; i < DEVICE_INODE_NUM; ++i) {
		if (0 < inodeTbl[i].refCount) {
			*o_next = i;
			return NOERR;
		}
	}

	return -ENOENT;
}

/*
 * ǥХ̾
 * return : ǥХ̾
 */
STATIC const char *getName(
	int inodeNum)
{
	ASSERT((0 <= inodeNum) && (inodeNum < DEVICE_INODE_NUM));

	return inodeTbl[inodeNum].name;
}

/*
 * ե⡼ɤ֤
 * return : ե⡼
 */
STATIC INLINE uint getMode(
	int inodeNum)
{
	ASSERT((0 <= inodeNum) && (inodeNum < DEVICE_INODE_NUM));

	return inodeTbl[inodeNum].perms;
}

//----------------------------------------------------------
// ǥХǥץ
//----------------------------------------------------------

/*
 * ǥХǥץ
 *եǥХ򥪡ץ󤹤٤˺ǳ롣
 */
typedef struct {
	int inodeNum;
	void *privateData;
} DEV_DESCRIPTOR;

/*
 * ǥХǥץ
 * return : error number
 */
STATIC int createDescriptor(
	const int i_inodeNum,			// ǥХinodeֹ
	void *i_privateData,			// ǥХץ饤١ȥǡ
	DEV_DESCRIPTOR **o_descriptor)
{
	DEV_DESCRIPTOR *newDescriptor;
	
	newDescriptor = kmalloc(sizeof(*newDescriptor));
	if (newDescriptor == NULL) {
		return -ENOMEM;
	}
	newDescriptor->inodeNum = i_inodeNum;
	newDescriptor->privateData = i_privateData;
	*o_descriptor = newDescriptor;
	
	return NOERR;
}

/*
 * ǥХǥץ
 */
STATIC INLINE void destroyDescriptor(
	DEV_DESCRIPTOR *m_descriptor)
{
	kfree(m_descriptor);
}

/*
 * ǥХǥץinodeֹ
 */
STATIC INLINE int getInodeNumDsc(
	const DEV_DESCRIPTOR *i_descriptor)
{
	return i_descriptor->inodeNum;
}

/*
 * ǥХǥץץ饤١ȥǡ
 */
STATIC INLINE void *getPrivateDataDsc(
	DEV_DESCRIPTOR *i_descriptor)
{
	return i_descriptor->privateData;
}

//----------------------------------------------------------
// ե륪ڥ졼
//----------------------------------------------------------

STATIC int mount(void *i_devDsc, void **o_rootInodeObj)
{
	if (0 < mountCount) {
		return -EBUSY;
	}
	++mountCount;
	*o_rootInodeObj = i_devDsc;

	return NOERR;
}

STATIC int umount(void *i_devDsc, void *rootInodeObj)
{
	if (0 < mountCount) {
		--mountCount;
	}

	return NOERR;
}

STATIC int lookup(const char *path, void *i_devDsc, void *inodeObj, uint *o_inodeNum, const char **o_path)
{
	return lookupDevInode(path, o_inodeNum);
}

STATIC int creat(const char *path, void *i_devDsc, void *inodeObj, const int mode, uint *o_inodeNum)
{
	return -EOPNOTSUPP;
}

STATIC int open(void *i_devDsc, const uint inodeNum, int oflag, void **o_inodeObj, int *o_type)
{
	void *privateData;
	DEV_DESCRIPTOR *devDsc;
	int error;

	// ǥХopen
	if (inodeNum != DEVICE_ROOT_INODE){
		int error = openDev(inodeTbl[inodeNum].dev, oflag, &privateData);
		if (error != NOERR) {
			return error;
		}
	}

	error = createDescriptor(inodeNum, privateData, &devDsc);
	if (error != NOERR) {
		return error;
	}
	*o_inodeObj = devDsc;
	*o_type = getMode(inodeNum) & S_IFMT;
	linkInode(inodeNum);

	return NOERR;
}

STATIC int close(void *devDsc, void *i_inodeObj)
{
	int inodeNum = getInodeNumDsc(i_inodeObj);

	if (inodeNum != DEVICE_ROOT_INODE){
		int error = closeDev(inodeTbl[inodeNum].dev, getPrivateDataDsc(i_inodeObj));
		if (error != NOERR) {
			return error;
		}
	}
	unlinkInode(inodeNum);

	return NOERR;
}

STATIC int read(void *devDsc, void *i_inodeObj, void *buf, size_t size, size_t begin)
{
	int inodeNum = getInodeNumDsc(i_inodeObj);

	if (inodeNum == DEVICE_ROOT_INODE) {
		return 0;
	}
	else {
		return readDev(inodeTbl[inodeNum].dev, buf, size, begin, getPrivateDataDsc(i_inodeObj));
	}
}

STATIC int write(void *devDsc, void *i_inodeObj, void *buf, size_t size, size_t begin)
{
	int inodeNum = getInodeNumDsc(i_inodeObj);

	if (inodeNum == DEVICE_ROOT_INODE){
		return 0;
	}
	else {
		return writeDev(inodeTbl[inodeNum].dev, buf, size, begin, getPrivateDataDsc(i_inodeObj));
	}
}

STATIC int ioctl(void *devDsc, void *i_inodeObj, int cmd, caddr_t param, int fflag)
{
	int inodeNum = getInodeNumDsc(i_inodeObj);

	if (inodeNum == DEVICE_ROOT_INODE){
		return -ENOENT;
	}
	else {
		return ioctlDev(inodeTbl[inodeNum].dev, cmd, param, fflag, getPrivateDataDsc(i_inodeObj));
	}
}

STATIC int poll(void *i_inodeObj, int events)
{
	int inodeNum = getInodeNumDsc(i_inodeObj);

	if (inodeNum == DEVICE_ROOT_INODE){
		return -ENOENT;
	}
	else {
		return pollDev(inodeTbl[inodeNum].dev, events, getPrivateDataDsc(i_inodeObj));
	}
}

STATIC int opendir(void *devDsc, void *dirInode, uint *o_block, int *o_index)
{
	*o_block = 0;
	*o_index = -1;

	return NOERR;
}

STATIC int readdir(void *devDsc, void *i_inodeObj, uint *m_block, int *m_index, char *o_name)
{
	const char *name;
	int inodeNum = getInodeNumDsc(i_inodeObj);
	int nextInode;
	int error;

	if (inodeNum != DEVICE_ROOT_INODE){
		return -ENOENT;
	}

	/* Υȥ꡼򸡺 */
	error = getNextInode(*m_index, &nextInode);
	if (error != NOERR) {
		return error;
	}

	*m_index = nextInode;

	/* ̾ */
	name = getName(nextInode);
	strcpy(o_name, name);
	o_name[strlen(name)] = '\0';

	return 0;
}

STATIC int stat(void *devDsc, void *i_inodeObj, struct stat *m_stat)
{
	int inodeNum = getInodeNumDsc(i_inodeObj);
	DEV_STAT devStat;

	ASSERT((0 <= inodeNum) && (inodeNum < DEVICE_INODE_NUM));

	if (inodeTbl[inodeNum].refCount == 0) {
		return -ENOENT;
	}

	if (inodeNum == DEVICE_ROOT_INODE) {
		memset(&devStat, 0, sizeof(devStat));
	}
	else {
		statDev(inodeTbl[inodeNum].dev, &devStat);
	}

	m_stat->st_dev			= makeudev(inodeTbl[inodeNum].major, inodeTbl[inodeNum].minor);
	m_stat->st_ino			= inodeNum;
	m_stat->st_mode			= inodeTbl[inodeNum].perms;
	m_stat->st_nlink		= inodeTbl[inodeNum].refCount;
	m_stat->st_uid			= 0;
	m_stat->st_gid			= 0;
	m_stat->st_size			= devStat.all_sect * devStat.sect_size;
	m_stat->st_atime		= inodeTbl[inodeNum].creatTime;
	m_stat->st_mtime		= inodeTbl[inodeNum].creatTime;
	m_stat->st_ctime		= inodeTbl[inodeNum].creatTime;
	m_stat->st_crtpos		= 0;
	m_stat->st_blksize		= devStat.sect_size;
	m_stat->st_rdev			= m_stat->st_dev;
	m_stat->st_blocks		= devStat.all_sect;
	m_stat->st_flags		= 0;	//̤

	return NOERR;
}

STATIC int rename(void *devDsc, void *OldDirInodeObj, const char *oldPath, void *newDirInodeObj, const char *newPath)
{
	return -EOPNOTSUPP;
}

STATIC int mknod(const char *path, void *devDsc, void *dirInode, const int mode, const uint devnum)
{
	const char *devName;
	int inodeNum;
	int error;

	// ǤϿ뤫
	error = lookupDevInode(path, &inodeNum);
	if (error != NOERR) {
		return error ;
	}
	
	devName = getDevName(path);
	
	// ǥХ̾Υǧ
	if (MAX_DEVICE_NAME < strlen(devName)) {
		return -ENAMETOOLONG;
	}
	
	// inode
	error = getFreeInode(&inodeNum);
	if (error != NOERR) {
		return error;
	}

	// inodeꤹ
	initInode(inodeNum, getDevByDevnum(devnum), devName, getMajor(devnum), getMinor(devnum), mode);

	return NOERR;
}

STATIC int mkdir(const char *path, void *devDsc, void *i_inodeObj, int mode)
{
	return -EOPNOTSUPP;
}

STATIC int delete(const char *path, void *devDsc, void *i_inodeObj, int type)
{
	int inodeNum = getInodeNumDsc(i_inodeObj);

	unlinkInode(inodeNum);

	return -EOPNOTSUPP;
}

STATIC int chattr(void *devDsc, void *i_inodeObj, uint mode, uint uid, uint gid, uint atime, uint mtime)
{
	return -EOPNOTSUPP;
}

STATIC int link(void *devDsc, void *dstInodeObj, void *srcInodeObj, const char *srcPath)
{
	return -EOPNOTSUPP;
}

STATIC int symlink(const char *filePath, void *devDsc, void *i_inodeObj, char *linkPath)
{
	return -EOPNOTSUPP;
}

STATIC int statfs(void *devDsc, struct statfs *m_statfs)
{
	return -EOPNOTSUPP;
}

static FS devFsFunc = {
	DEV_FS_NAME,
	mount,
	umount,
	lookup,
	creat,
	open,
	close,
	read,
	write,
	ioctl,
	poll,
	opendir,
	readdir,
	rename,
	mknod,
	mkdir,
	stat,
	delete,
	chattr,
	link,
	symlink,
	statfs,
};

//================================== PUBLIC =============================================

/*
 * ǥХե륷ƥν
 * return : error number
 */
int initDeviceFs()
{
	int error;

	// root inode
//	inodeTbl[DEVICE_ROOT_INODE].minor = 0;
//	inodeTbl[DEVICE_ROOT_INODE].refCount = 2;
//	inodeTbl[DEVICE_ROOT_INODE].dev = NULL;
//	inodeTbl[DEVICE_ROOT_INODE].blockBeg = 0;
//	inodeTbl[DEVICE_ROOT_INODE].blocks = 0;
//	inodeTbl[DEVICE_ROOT_INODE].creatTime = sys_time(NULL);
//	inodeTbl[DEVICE_ROOT_INODE].perms = S_IFDIR | S_IRWXU | S_IRGRP | S_IXGRP | S_IROTH | S_IXOTH;
	initInode(
		DEVICE_ROOT_INODE,
		NULL,
		"\0",
		0,
		0,
		S_IFDIR | S_IRWXU | S_IRGRP | S_IXGRP | S_IROTH | S_IXOTH);
	linkInode(DEVICE_ROOT_INODE);

	/* ե륷ƥϿ롣 */
	error = regist_fs(&devFsFunc);
	if (error < 0) {
		return error;
	}

	return 0;
}

/*
 * ǥХե
 * return : error number
 */
int makeDevf(
	const char *i_devName,
	void *i_dev,
	const uint i_perms)
{
	int inodeNum;
	int dummy;
	DEV_STAT devStat;
	int error;

	// ǥХ̾Υǧ
	if (MAX_DEVICE_NAME < strlen(i_devName)) {
		return -ENAMETOOLONG;
	}
	
	// Ͽʤ
	if (searchByName(i_devName, &dummy) == NOERR) {
		return -EEXIST;
	}

	// inode
	error = getFreeInode(&inodeNum);
	if (error != NOERR) {
		return error;
	}

	// inodeꤹ
	statDev(i_dev, &devStat);
	initInode(inodeNum, i_dev, i_devName, devStat.major, devStat.minor, i_perms);

	return NOERR;
}

/*
 * ǥХ򥪡ץ󤹤롣
 *ե֡Ȼե륷ƥޥȤΤ߻Ѥ
 * return : error number
 */
int openDevice(
	const char *i_devPath,
	void **o_devInode)
{
	const char *devPath;
	uint inodeNum;
	int type;
	int error;

	if (cmpPath("/dev", i_devPath, 4) != 0) {
		return -EINVAL;
	}

	//Υѥ˿ʤ
	devPath = i_devPath;
	if (devPath[4] == '/') {
		devPath += 5;
	}
	else {
		devPath += 4;
	}

	error = lookup(devPath, 0, 0, &inodeNum, NULL);
	if (error != NOERR){
		return error;
	}
	error = open(0, inodeNum, O_RDWR, o_devInode, &type);
	if (error != NOERR){
		return error;
	}

	return NOERR;
}

/*
 * ǥХ󥪥֥Ȥ
 * return : ǥХ󥪥֥
 */
void *getDevInfo(
	const void *i_devDsc)
{
	int inodeNum = getInodeNumDsc(i_devDsc);

	ASSERT((0 <= inodeNum) && (inodeNum < DEVICE_INODE_NUM));

	return inodeTbl[inodeNum].dev;
}

/*
 * ǥХinodeֹ
 * return : inodeֹ
 */
int getDevInodeNum(
	const void *i_devDsc)
{
	return getInodeNumDsc(i_devDsc);
}

/*
 * եǥץü̾롣
 * return : error number
 */
int getTtyname(
	void *i_inodeObj,
	char *m_name)
{
	int inodeNum = getInodeNumDsc(i_inodeObj);
	void *dev;
	DEV_STAT devStat;

	if (checkMem(m_name, MAX_DEVICE_NAME) == ERR) {
		return -EFAULT;
	}

	dev = inodeTbl[inodeNum].dev;
	if (dev != NULL) {
		statDev(dev, &devStat);
		if (devStat.flags | D_TTY) {
			strcpy(m_name, getName(inodeNum));
			return NOERR;
		}
		else {
			return -ENOTTY;
		}
	}
	else {
		return -ENODEV;
	}
}
