/*
 * device.h
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#ifndef device_h
#define device_h


#include <sys/types.h>
#include <sys/bus.h>
#include <sys/conf.h>
#include <kern/fs.h>
#include <kern/dev_common.h>


#ifndef ASM_FILE


// Ԥѹ¤
struct waitIntr {
	void *task;		// Ԥץ
	int isIntr;		// ǥХߤ
	int lock;
};

typedef struct waitIntr WAIT_INTR;

extern int initDevice();
extern struct specinfo *makeBlkDev(struct cdevsw *, const size_t, const size_t, const int);
extern struct specinfo *makeBlkPartDev(struct cdevsw *, const size_t, const size_t, const int, const int, const int, const int);
extern struct specinfo *getDevByDevnum(const int);
extern void devInitWait(WAIT_INTR *);
extern void devWaitIntr(WAIT_INTR*,uint);
extern int devWakeIntr(WAIT_INTR*);
extern void setupIntr(struct resource *, void (*handler)(void *), void *);
extern int read_direct(void *, void*, size_t, size_t, size_t*);
extern int write_direct(void *, void*, size_t, size_t, size_t*);

extern int devOpenDev(struct specinfo *, const int, void**);
extern int devCloseDev(struct specinfo *, void*);
extern int devReadDev(struct specinfo *, void *, const size_t, const size_t, void*);
extern int devWriteDev(struct specinfo *, void *, const size_t, const size_t, void*);
extern int devIoctlDev(struct specinfo *, const int, caddr_t, const int, void*);
extern int devPollDev(struct specinfo *, const int, void*);
extern void devStatDev(struct specinfo *, DEV_STAT *);


#endif


#endif
