/*
 * fs.h
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#ifndef fs_h
#define fs_h


#include <sys/config.h>
#include <sys/types.h>
#include <sys/limits.h>
#include <sys/stat.h>
#include <sys/fcntl.h>
#include <sys/unistd.h>
#include <sys/select.h>
#include <sys/poll.h>
#include <sys/ttycom.h>
#include <kern/vfs.h>
#include <kern/lock.h>


#ifndef ASM_FILE


#include<sys/mount.h>


enum{
	/* եǥץѥեμࡣ */
	FD_FORM_LOCALFILE=1,
	FD_FORM_DIRSTREAM,
	FD_FORM_NETSOKET,
};


#define I_TRUNC		5	/* ե륵ڤͤᡢftruncate()  : */

/* ե¹ѥեǥץ */
typedef struct{
	void	*vent;		// ۥȥ꡼
	off_t	offset;		// ɤ߽񤭳ϥեå
} EXEC_FD;

/* եǥץ */
typedef struct{
	uchar  form;		/* ࡣ */
	uchar  refCount;	/* ȥȡ */
	ushort accessMode;	/* Access mode. */
	off_t f_pos;		/* ɤ߽񤭳ϥեåȡ */
	void *vent;		/* ۥȥ꡼ */
} F_DSC;

/*
 * ǥ쥯ȥꥹȥ꡼
 *աեեǥץȶѤƻȤΤ"fd"ΰ֤ɬƬˤ
 */
typedef struct{
	F_DSC	fd;
	uint	block;		/* directory block. */
	int		index;		/* directory index. */
}DIR_STRAEM;

/* ץѥե빽¤ */
typedef struct{
	void	*current_dir;			// ȥǥ쥯ȥ
	F_DSC	*fd[_POSIX_OPEN_MAX];
	uchar	flag[_POSIX_OPEN_MAX];	// եǥץե饰
	uchar	fd_count;				// եǥץץ
	uchar	next_fd;				// ζեǥץ
}FILE_STRUCT;


extern FS *fs_info[];


extern void			initExecFs();
extern FILE_STRUCT	*copyFileStruct(FILE_STRUCT *);
extern void			releaseFileStruct(FILE_STRUCT *);
extern int			initFileStruct(void *);
extern void			initFd(void*, const int, const int ,F_DSC*);
extern int			setFd(F_DSC*, const int flag);
extern F_DSC		*getFd(int);
extern void			*getVentFromFdsc(const F_DSC *);
extern int			isFileOpenMax();
extern void			*getCurrentDir();
extern int			setInitProcFs();
extern int			exec_open(const char*, EXEC_FD*);
extern int			exec_read(EXEC_FD*,void*, size_t);
extern void			exec_close(EXEC_FD*);

extern int			sys_open();
extern int			sys_close();
extern int			sys_read();
extern int			sys_write();
extern int			sys_ioctr();
extern off_t		sys_lseek();
extern int			sys_mkdir();
extern int			sys_creat();
extern int			sys_rename();
extern int			sys_unlink();
extern int			sys_rmdir();
extern int			sys_lock();
extern int			sys_mount();
extern int			sys_umount();
extern int			sys_opendir();
extern int			sys_closedir();
extern int			sys_readdir();
extern int			sys_rewinddir();
extern int			sys_chdir();
extern int			sys_fchdir();
extern int			sys_getcwd();
extern int			sys_stat();
extern int			sys_fstat();
extern int			sys_lstat();
extern int			sys_umount_root();
extern int			sys_fcntl();
extern int			sys_ioctl();
extern int			sys_link();
extern int			sys_symlink();
extern int			sys_readlink();
extern int			sys_select();
extern int			sys_poll();
extern int			sys_getstatfs();
extern int			sys_statfs();
extern int			sys_chmod();
extern int			sys_fchmod();
extern int			sys_chown();
extern int			sys_fchown();
extern int			sys_utimes();
extern int			sys_ttyname();


#endif


#endif
