/*
 * kmalloc.c
 *
 * Copyright 2007, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 *Գסեͥ꡼
 */


#include <sys/config.h>
#include <sys/types.h>
#include <sys/param.h>
#include <lib/lib.h>
#include <machine/interrupt.h>
#include <kern/vm.h>
#include <kern/physical_mem.h>

#include <kern/debug.h>


//#define DEBUG_KMALLOC 1
#ifdef DEBUG_KMALLOC
	#define STATIC
	#define INLINE
#else
	#define STATIC	static
	#define INLINE	inline
#endif


//==================================  ===========================================

//================================== Х륤ݡ ===============================

//================================== PRIVATE ============================================

#define HEAP_NUM() (sizeof(heapHead) / sizeof(HEAP_HEAD))

/* 
 * ҡץ꡼إå
 */
typedef struct MEM_HEAD{
	struct MEM_HEAD	*next;		/* ζ꡼Ƭ */
	uint			size;		// ʬ꡼
}MEM_HEAD;

/*
 * ҡץإå
 */
typedef struct{
	MEM_HEAD	*memTop;	/* ꡼Ƭ */
	uint		size;		/* ƥ */
	int			gate;		/* ԥåѥ */
}HEAP_HEAD;

/*
 * ҡץإå
 */
static HEAP_HEAD heapHead[]={
	{NULL, 0,      0},
	{NULL, 0x10,   0},
	{NULL, 0x20,   0},
	{NULL, 0x40,   0},
	{NULL, 0x80,   0},
	{NULL, 0x100,  0},
	{NULL, 0x200,  0},
	{NULL, 0x400,  0},
	{NULL, 0x800,  0},
	{NULL, 0x1000, 0},
};

/*
 * ҡץإå
 */
static uchar heapNum1[]={
	0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
	2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
	3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
	3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
	4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
	4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
	4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
	4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
	5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
	5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
	5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
	5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
	5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
	5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
	5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
};

static uchar heapNum2[]={
	0,5,6,7,7,8,8,8,8,9,9,9,9,9,9,9,
	9,
};

/*
 * ҡץإåͤ
 * return : 
 */
STATIC INLINE int getHeapArray(
	size_t size)		// Хȥ
{
	if (size < 0x100) {
		return heapNum1[size];
	}
	else {
		return heapNum2[ROUNDUP(size, 0x100) >> 8];
	}
}

/*
 * ڡʲΥ꡼μ
 */
STATIC void *getPageMem(
	const int array,
	uint *o_size)
{
	MEM_HEAD *mem;

	if (heapHead[array].memTop == NULL) {
		MEM_HEAD *head;

		// ڡ꡼
		head = allocKernelPage();
		if (head == NULL){
			return NULL;
		}

		// Ȥaddress狼褦ˤ롣
		setAllocNum(head, array);

		head->next = NULL;
		head->size = PAGE_SIZE;
		heapHead[array].memTop = head;
	}

	// ׵꡼
	mem = heapHead[array].memTop;
	if (heapHead[array].size < mem->size) {
		MEM_HEAD *next = (MEM_HEAD*) ((uint) mem + heapHead[array].size);

		next->next = mem->next;
		next->size = mem->size - heapHead[array].size;
		heapHead[array].memTop = next;
	}
	else {
		heapHead[array].memTop = mem->next;
	}

	*o_size = heapHead[array].size;

	return mem;
}

/*
 * ڡ礭꡼μ
 */
STATIC void *getBigMem(
	const uint i_size,
	uint *o_size)
{
	uint size = ROUNDUP(i_size, PAGE_SIZE);
	void *mem = allocMultiKernelPage(size / PAGE_SIZE);
	
	if (mem == NULL) {
		return NULL;
	}
	setAllocNum(mem, HEAP_NUM() + size / PAGE_SIZE);

	*o_size = size;

	return mem;
}

/*
 * ҡץ꡼ڡʾʤ餽ʬ
 * return : Υҡץ꡼Ƭݥ
 */
STATIC MEM_HEAD *freePageSize(
	MEM_HEAD *m_src)
{
	uint srcAddr = (uint) m_src;
	uint pageBoundAddr = ROUNDUP(srcAddr, PAGE_SIZE);	// ڡɥ쥹

	if (m_src == NULL) {
		return NULL;
	}

	if (PAGE_SIZE <= (int) m_src->size - (int) (pageBoundAddr - srcAddr)) {
		MEM_HEAD *top;

		if (pageBoundAddr + PAGE_SIZE < srcAddr + m_src->size) {
			MEM_HEAD *next = (MEM_HEAD*) (pageBoundAddr + PAGE_SIZE);
			
			next->next = m_src->next;
			next->size = srcAddr + m_src->size - pageBoundAddr - PAGE_SIZE;
			m_src->next = next;
		}

		if (srcAddr == pageBoundAddr) {
			top = m_src->next;
		}
		else {
			m_src->size = pageBoundAddr - srcAddr;
			top = m_src;
		}

		unlinkPhysTable((void*) pageBoundAddr);
		
		return top;
	}
	else {
		return m_src;
	}
}

/*
 * ڡʲΥ꡼
 */
STATIC void freePageMem(
	const int array,
	MEM_HEAD *i_src)
{
	MEM_HEAD *src = i_src;
	MEM_HEAD *next;
	MEM_HEAD *prev;

	/*
	 * ҡץ꡼³
	 * out : prev = ΥҡסNULLʤ鼡ΥҡפƬ src = Υҡ
	 */
	src->size = heapHead[array].size;
	prev = NULL;
	for (next = heapHead[array].memTop;; next = next->next) {
	// Ʊɥ쥹Ϥꤨʤ
		ASSERT(src != next);

		if (next == NULL) {
			src->next = NULL;
			break;
		}

		if ((uint) next + next->size == (uint) src) {
			// Υҡפȷ
			next->size += src->size;
			
			src = next;
		}
		else {
			if (src < next) {
				if ((uint) src + src->size == (uint) next) {
					// Υҡפȷ
					src->size += next->size;
					src->next = next->next;
				}
				else {
					src->next = next;
				}
				
				break;
			}

			prev = next;
		}
	}

	// ҡץ꡼ڡʾʤ餽ʬ
	src = freePageSize(src);
	if (prev == NULL) {
		heapHead[array].memTop = src;
	}
	else {
		prev->next = src;
	}
}

//================================== PUBLIC =============================================

/*
 * ׵᥵꡼ơ³֤
 * return : allocate memory or NULL
 */
void *kmallocSize(
	const uint i_size,
	uint *o_size)
{
	void *addr;
	int eflag;

	ASSERT(o_size != NULL);

	if (i_size == 0){
		*o_size = 0;
		return NULL;
	}

	if (i_size <= PAGE_SIZE) {
		int array = getHeapArray(i_size);

		eflag = enterCli();
		enter_spinlock(&heapHead[array].gate);
		{
			addr = getPageMem(array, o_size);
		}
		exit_spinlock(&heapHead[array].gate);
		exitCli(eflag);
	}
	else {
		addr = getBigMem(i_size, o_size);
	}
	
	return addr;
}

/*
 * ׵᥵꡼Ƥ
 * return : allocate address or NULL
 */
void *kmalloc(size_t size)
{
	int realSize;

	return kmallocSize(size, &realSize);
}

/*
 * ꡼
 * return : ꡼
 */
uint kfree(
	void *ptr)
{
	int array;
	uint size;
	int eflag;

	if (ptr == NULL) {
		return 0;
	}

	array = getAllocNum(ptr);
	if (array == 0){
#ifdef DEBUG
		printk("kfree() 0x%x did not allocated : call function=0x%x\n",ptr, *((uint*)&ptr - 1));
#endif
		return 0;
	}

	if (array < HEAP_NUM()) {
		eflag = enterCli();
		enter_spinlock(&heapHead[array].gate);
		{
			/*
			 * ڡʲ
			 */
#ifdef DEBUG
			// ݥ󥿤Ǥʤ
			if (0 < ((uint) ptr % heapHead[array].size)) {
				printk("kfree() 0x%x is wrong addres! : call function=0x%x\n",ptr, *((uint*)&ptr - 1));
				size = 0;
				goto EXIT;
			}

			// ȤȥڡեȤ򵯤ͤƤ
			memset(ptr, 0xf5, heapHead[array].size);
#endif
			freePageMem(array, ptr);
		}
EXIT:	exit_spinlock(&heapHead[array].gate);
		exitCli(eflag);

		return heapHead[array].size;
	}
	else {
		uint mem;
		int i;
#ifdef DEBUG
		// ݥ󥿤Ǥʤ
		if (0 < ((uint) ptr % PAGE_SIZE)) {
			printk("kfree() 0x%x is wrong addres! : call function=0x%x\n",ptr, *((uint*)&ptr - 1));
			return 0;
		}
#endif
		size = (array - HEAP_NUM()) * PAGE_SIZE;
		mem = (uint) ptr;
		for (i = array - HEAP_NUM(); 0 < i ; --i) {
			unlinkPhysTable((void*) mem);
			mem += PAGE_SIZE;
		}

		return size;
	}
}
