/*
 * listFunc.c
 *
 * Copyright 2006, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * ꥹ
 */


#include <sys/types.h>
#include <sys/param.h>
#include <kern/listFunc.h>

#include <kern/debug.h>


//#define DEBUG_LISTFUNC 1
#ifdef DEBUG_LISTFUNC
	#define STATIC
	#define INLINE
#else
	#define STATIC	static
	#define INLINE	inline
#endif


/*****************************************************************************************
* ꥹȶ
******************************************************************************************/

/*
 * Υ󥯤Υ֥Ȥ򻲾Ȥ
 * return : ֥ȥݥ
 */
void *refNextList(
	const size_t offset,		// ꥹȥСΥեå
	const OBJ_LIST *i_src)		// ꥹȥСݥ
{
	const LIST *src = (LIST*) i_src;

	ASSERT(i_src != NULL);

	return (src->next != NULL) ? (void*) ((size_t) src->next - offset) : NULL;
}

/*
 * 󥯥إåɤκǽΥ֥Ȥ򻲾Ȥ
 * return : ֥ȥݥ or NULL
 */
void *refHeadObj(
	const size_t offset,		// ꥹȥСΥեå
	const OBJ_LIST *head)		// إå
{
	return (head != NULL) ? (void*) ((size_t) head - offset) : NULL;
}

/*****************************************************************************************
* ñꥹ
******************************************************************************************/

//================================== PUBLIC =============================================

/*
 * ꥹǤν
 */
void initList(
	OBJ_LIST *m_src)		// ꥹȥСݥ
{
	LIST *src = (LIST*) m_src;

	src->next = NULL;
}

/*
 * ³
 */
void insertList(OBJ_LIST *m_dst, OBJ_LIST *m_src)
{
	LIST *dst = (LIST*)m_dst;
	LIST *src = (LIST*)m_src;

	dst->next = src;
}

/*
 * 󥯥إåɤ³
 */
void insertHeadList(OBJ_LIST **m_head, OBJ_LIST *m_src)
{
	LIST **head = (LIST**) m_head;
	LIST *src = (LIST*) m_src;
	
	src->next = *head;
	*head = src;
}

/******************************************************************************************************
* ξ۴ĥꥹ
 *******************************************************************************************************/

//================================== PRIVATE ============================================

/*
 * ³Ǥμ³
 */
STATIC INLINE void addNext(LIST *dst, LIST *src)
{
	src->next = dst->next;
	src->prev = dst;
	dst->next->prev = src;
	dst->next = src;
}

/*
 * ³Ǥ³
 */
STATIC INLINE void addPrev(
	LIST *dst,		// ³ꥹȥСݥ
	LIST *src)		// ³ꥹȥСݥ
{
	src->next = dst;
	src->prev = dst->prev;
	dst->prev->next = src;
	dst->prev = src;
}

/*
 * ꥹȤ
 */
STATIC INLINE void remove(LIST *src)
{
	src->prev->next = src->next;	// nextǽѤ
	src->next->prev = src->prev;
	src->next =  src;
	src->prev = src;
}

//================================== PUBLIC =============================================

/*
 * ξ󥯥ꥹǤν
 */
void initCirculList(
	OBJ_LIST *m_src)		// ꥹȥСݥ
{
	LIST *src = (LIST*) m_src;

	src->next = src->prev = src;
}

/*
 * Υ󥯤Υ֥Ȥ򻲾Ȥ
 * return : ֥ȥݥ or NULL
 */
void *refPrevList(
	const size_t offset,		// ꥹȥСΥեå
	const OBJ_LIST *i_src)		// ꥹȥСݥ
{
	const LIST *src = (LIST*) i_src;

	return (src != NULL) ? (void*) ((size_t) src->prev - offset) : NULL;
}

/*
 * ³Ǥμ³
 */
void insertNextList(
	OBJ_LIST *m_dst,		// ³ꥹȥСݥ
	OBJ_LIST *m_src)		// ³ꥹȥСݥ
{
	addNext((LIST*) m_dst, (LIST*) m_src);
}

/*
 * ³Ǥ³
 */
void insertPrevList(
	OBJ_LIST *m_dst,		// ³ꥹȥСݥ
	OBJ_LIST *m_src)		// ³ꥹȥСݥ
{
	addPrev((LIST*) m_dst, (LIST*) m_src);
}

/*
 * ξ󥯥ꥹȤ
 */
void removeList(
	OBJ_LIST *m_src)		// ꥹȥСݥ
{
	remove((LIST*) m_src);
}

/*
 * ³Ǥ˥󥯤³
 */
void insertLinkNextList(
	OBJ_LIST *m_dst,		// ³ꥹȥСݥ
	OBJ_LIST *m_srcLink)	// ³󥯥ݥ
{
	LIST *dst = (LIST*) m_dst;
	LIST *src = (LIST*) m_srcLink;
	
	src->prev->next = dst->next;
	dst->next->prev = src->prev;
	src->prev = dst;
	dst->next = src;
}

/*
 * ³ƥ󥯥إåɤꤹ
 */
void insertHeadCrclList(
	OBJ_LIST **m_head,		// ³إåݥ
	OBJ_LIST *m_src)		// ³ꥹȥСݥ
{
	LIST **head = (LIST**) m_head;
	LIST *src = (LIST*) m_src;

	if (*head == NULL) {
		src->next = src->prev = src;
		*head = src;
	}
	else {
		addPrev(*head, src);
		*head = src;
	}
}

/*
 * 󥯥إåɤ³
 */
void insertHeadPrevList(
	OBJ_LIST **m_head,		// إå
	OBJ_LIST *m_src)		// ³ꥹȥСݥ
{
	LIST **head = (LIST**) m_head;
	LIST *src = (LIST*) m_src;

	if (*head == NULL) {
		src->next = src->prev = src;
		*head = src;
	}
	else {
		addPrev(*head, src);
	}
}

/*
 * 󥯥إåɤؤ󥯥ꥹȤ
 */
void removeOutHeadList(
	OBJ_LIST **m_head,		// إå
	OBJ_LIST *m_src)		// ǥꥹȥСݥ
{
	LIST **head = (LIST**) m_head;
	LIST *src = (LIST*) m_src;

	if (*head == NULL) {
		return;
	}

	if (*head == src) {
		if (src->next == src) {
			*head = NULL;
		}
		else {
			*head = src->next;
			remove(src);
		}
	}
	else {
		remove(src);
	}
}

/*
 * 󥯥إåɤκǽΥ֥Ȥ
 * return : ֥ȥݥ or NULL
 */
void *getHeadList(
	const size_t offset,		// ꥹȥСΥեå
	OBJ_LIST **m_head)			// إå
{
	LIST **head = (LIST**) m_head;

	if (*head != NULL) {
		LIST *src = *head;
		LIST *next = src->next;
		remove(src);
		*head = (next == src) ? NULL : next;

		return (void*) ((uint) src - offset);
	}
	else {
		return NULL;
	}
}

/*
 * 󥯥إåɤκǸΥ֥Ȥ
 * return : ֥ȥݥ or NULL
 */
void *getHeadPrevList(
	const size_t offset,		// ꥹȥСΥեå
	OBJ_LIST **m_head)			// إå
{
	LIST **head = (LIST**) m_head;

	if (*head != NULL) {
		LIST *top = *head;
		LIST *prev = top->prev;
		remove(prev);
		if (prev == top) {
			*head = NULL;
		}

		return (void*) ((uint) prev - offset);
	}
	else {
		return NULL;
	}
}

/*
 * 󥯥إåɤκǸΥ֥Ȥ򻲾Ȥ
 * return : ֥ȥݥ or NULL
 */
void *refHeadPrevList(
	const size_t offset,		// ꥹȥСΥեå
	const OBJ_LIST *i_head)		// إå
{
	LIST *head = (LIST*) i_head;

	if (head != NULL) {
		return (void*) ((uint) head->prev - offset);
	}
	else {
		return NULL;
	}
}
