/*
 * lock.c
 *
 * Copyright 2006, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#include <sys/param.h>
#include <machine/interrupt.h>
#include <kern/Thread.h>
#include <kern/device.h>
#include <kern/lock.h>

#include <kern/debug.h>


//#define DEBUG_LOCK 1
#ifdef DEBUG_LOCK
	#define STATIC
	#define INLINE
#else
	#define STATIC static
	#define INLINE inline
#endif


/*****************************************************************************************
 * ȥȥå
 * δ֤ϻȽϥȤϹϥȤ롣
 *****************************************************************************************/

//================================== PUBLIC =============================================

/*
 * 
 */
void initModifyWaitLock(
	MODIFY_WAIT_LOCK *m_modifyLock)
{
	m_modifyLock->refCount = 0;
	m_modifyLock->modify = 0;
	m_modifyLock->gate = 0;
	AggregateSingleListConstructor(&m_modifyLock->aggregate);
}

/*
 * ̾ﹹå
 */
void modifyWaitLock(MODIFY_WAIT_LOCK *modifyLock)
{
	for (;;) {
		int eflag = enterCli();
		enter_spinlock(&modifyLock->gate);

		if (0 < modifyLock->refCount) {
			AggregateList *aggregate = &modifyLock->aggregate;
			aggregate->insertEnd(aggregate, getWaitList(getCurrentTask()));

			exit_spinlock(&modifyLock->gate);
			sleepTask(TASK_WAIT);
			exitCli(eflag);

		}
		else {
			modifyLock->modify = YES;
			modifyLock->refCount++;
			exit_spinlock(&modifyLock->gate);
			exitCli(eflag);

			break;
		}
	}
}

/*
 * ̾ﹹå
 */
void modifyWaitUnlock(MODIFY_WAIT_LOCK *modifyLock)
{
	int eflag;

	ASSERT(0 < modifyLock->refCount);

	eflag = enterCli();
	enter_spinlock(&modifyLock->gate);
	{
		AggregateList *aggregate = &modifyLock->aggregate;
		ThreadObj *waitTask = aggregate->getHead(aggregate);

		modifyLock->modify = NO;
		modifyLock->refCount--;
		if (waitTask != NULL) {
			wakeTask(getWaitTask(waitTask), TASK_WAIT);
		}
	}
	exit_spinlock(&modifyLock->gate);
	exitCli(eflag);
}

/*
 * 
 */
void modifyWaitRef(MODIFY_WAIT_LOCK *modifyLock)
{
	for (;;) {
		int eflag = enterCli();
		enter_spinlock(&modifyLock->gate);

		if (modifyLock->modify == YES) {
			AggregateList *aggregate = &modifyLock->aggregate;
			aggregate->insertEnd(aggregate, getWaitList(getCurrentTask()));
			exit_spinlock(&modifyLock->gate);

			sleepTask(TASK_WAIT);
			exitCli(eflag);

		}
		else {
			modifyLock->refCount++;
			exit_spinlock(&modifyLock->gate);
			exitCli(eflag);

			break;
		}
	}
}

/*
 * Ƚλ
 */
void modifyWaitRefEnd(MODIFY_WAIT_LOCK *modifyLock)
{
	int eflag;

	ASSERT(0 < modifyLock->refCount);

	eflag = enterCli();
	enter_spinlock(&modifyLock->gate);
	{
		AggregateList *aggregate = &modifyLock->aggregate;
		ThreadObj *waitTask = aggregate->getHead(aggregate);

		modifyLock->refCount--;
		if (waitTask != NULL) {
			wakeTask(getWaitTask(waitTask), TASK_WAIT);
		}
	}
	exit_spinlock(&modifyLock->gate);
	exitCli(eflag);
}

//*************************************************************************************************

#ifdef DEBUG
#include <kern/time.h>
void testLock(
	const uint caller)
{
	static uint before = 0;
	static uint64 beforeRdtsc = 0;

	if (caller == before) {
		if (1000 < calcMiliSecondFromClock(rdtsc() - beforeRdtsc)) {
			printk("testLock from=%x\n", before);
			beforeRdtsc = rdtsc();
		}
	}
	else {
		before = caller;
		beforeRdtsc = rdtsc();
	}
}	
#endif
