/*
 * page_swap.c
 *
 * Copyright 2007, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 *Գסեڡ꡼ǥХɤ߽񤭤
 *
 *
 *
 *ԸƤ
 */


#include <sys/config.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/errno.h>
#include <lib/lib.h>
#include <kern/vm.h>
#include <kern/devfs.h>
#include <kern/device.h>
#include <kern/block_cache.h>
#include <kern/physical_mem.h>

#include <kern/debug.h>


//#define DEBUG_PAGE_SWAP 1
#ifdef DEBUG_PAGE_SWAP
	#define STATIC
	#define INLINE
#else
	#define STATIC	static
	#define INLINE	inline
#endif


//==================================  ===========================================

//================================== Х륤ݡ ===============================

//================================== PRIVATE ============================================

enum {
	PT_TYPE_PAGING = 0x9a,	/* ڡХååץǥХѡƥֹʲˡ */
	PB_START_SECTER = 2,	/* Хåå׳ϥ */
};

/* ӥåȥޥåפǥХ֥ͤåΰ֤롣 */
static uchar emptyBlock[] = {
	0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,
	0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,
	0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,
	0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,6,
	0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,
	0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,
	0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,
	0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,7,
	0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,
	0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,
	0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,
	0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,6,
	0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,
	0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,
	0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,
	0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,0,
};

static uchar *pbBitMap;			// ֥åӥåȥޥå
static int pbBitMapCurrent;		// ӥåȥޥåθߤΥХȰ
static int pbBitMapSize;		// ӥåȥޥåץ
static void *pbDevDsc;				// ХååץǥХ inode
static int pbSectors;			// ڡ/

/*
 * ڡХååפ롣
 * return : ֥å or failed=-1
 */
STATIC int getEmptyBackup()
{
	int bit;
	int i;

	i = pbBitMapCurrent;

	do {
		if (pbBitMap[i] != 0xff) {
			bit = emptyBlock[pbBitMap[i]];
			pbBitMap[i] |= 1 << bit;
			pbBitMapCurrent = i;

			return (i * BYTE_BITNUM + bit) * pbSectors + PB_START_SECTER;
		}

		if (++i == pbBitMapSize) {
			i=0;
		}
	} while (i != pbBitMapCurrent);

	return -1;
}

/*
 * ֥å˥åȤ롣
 */
STATIC INLINE void setBlockEmpty(
	const uint i_block)
{
	int i;

	i = (i_block - PB_START_SECTER) / pbSectors;
	pbBitMap[i / BYTE_BITNUM] &= (uchar) ~(1 << (i % BYTE_BITNUM));
}

//================================== PUBLIC =============================================

/*
 * ڡХååѥǥХޥȤ
 * return : error number
 */
int initBackupDev(
	const char *dev_path)		// device path
{
	DEV_STAT dev_stat;
	int error;

	// Device open
	error = openDevice(dev_path, &pbDevDsc);
	if (error != NOERR) {
		return error;
	}

	// ѡƥ󥿥פγǧ
	devStatDev(getDevInfo(pbDevDsc), &dev_stat);
	if (dev_stat.prt_type != PT_TYPE_PAGING) {
		return -ENODEV;
	}
	pbSectors = PAGE_SIZE / dev_stat.sect_size;

	// ӥåȥޥåפγơ
	pbBitMapSize = (dev_stat.all_sect - PB_START_SECTER) / pbSectors / BYTE_BITNUM;
	pbBitMap = allocMultiKernelPage(ROUNDUP_DIV(pbBitMapSize, PAGE_SIZE));
	if (pbBitMap == NULL) {
		return -ENOMEM;
	}
	memset(pbBitMap, 0, pbBitMapSize);
	pbBitMapCurrent = 0;

	return NOERR;
}

/*
 * ꡼ڡХååפ
 * returns : error number
 */
int writePage(
	void *physMem,		// Хååʪɥ쥹
	uint *o_block)		// 񤭽Ф֥åֹ
{
	int block;
//	size_t ioSize;
	int error;

	// ֥å
	block = getEmptyBackup();
	if (block == -1) {
		return -ENOSPC;
	}

//	error = write_direct(getDevInfo(pbDevDsc), physMem, pbSectors, block, &ioSize);
	error = write_cache(getDevInfo(pbDevDsc), physMem, pbSectors, block);
	if (error != NOERR) {
		return error;
	}
	
	*o_block = block;

	return NOERR;
}

/*
 * Хååץڡ꡼᤹
 * return : error number
 */
int readPage(
	const uint i_block,		// device block
	void *buf)				// memory buffer
{
//	size_t ioSize;

//	return read_direct(getDevInfo(pbDevDsc), buf, pbSectors, i_block, &ioSize);
	return read_cache(getDevInfo(pbDevDsc), buf, pbSectors, i_block);
}

/*
 * ֥å
 */
void freePageBlock(
	const uint i_block)		// ֥åֹ
{
	setBlockEmpty(i_block);
}
