/*
 * physical_mem.c
 *
 * Copyright 2007, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 *Գסʪ꡼
 *
 *
 *
 *ԸƤ
 */


#include <sys/config.h>
#include <sys/types.h>
#include <sys/param.h>
#include <machine/interrupt.h>
#include <kern/vm.h>

#include <kern/debug.h>


//#define DEBUG_PHYSICAL_MEM 1
#ifdef DEBUG_PHYSICAL_MEM
	#define STATIC
	#define INLINE
#else
	#define STATIC	static
	#define INLINE	inline
#endif


//==================================  ===========================================

//================================== Х륤ݡ ===============================

//================================== PRIVATE ============================================

/*
 * ꡼ڡơ֥
 */
typedef struct PHYS_MEM {
	short			refCount;	// ȥ
	ushort			heap_num;	// Heap number
	int				lock;		// ԥå
	struct PHYS_MEM	*next;
	struct PHYS_MEM	*prev;
} PHYS_MEM;

enum{
	PHYSICAL_PAGE_TABLE_ADD = KERNEL_DATA_BEG,	// ʪ꡼ơ֥륢ɥ쥹 */
};

/*
 * ꡼ڡơ֥󥯥إå
 */
static PHYS_MEM *freeKernMem;	// ꥹȡͥʪ꡼󥯥ȥå
static PHYS_MEM *freeUserMem;	// ꥹȡ桼ʪ꡼󥯥
static int physMemLock;			// PHYS_MEMѥå

/*
 * ʪ꡼
 */
static uint all_memory_size;

#ifdef DEBUG
static int freeMem;

STATIC void addFreeMemSize()
{
	freeMem += PAGE_SIZE;
	printDebug(70, "%x", freeMem);
}

STATIC void subtractFreeMemSize()
{
	freeMem -= PAGE_SIZE;
	printDebug(70, "%x", freeMem);
}

uint getFreeMemSize()
{
	return freeMem;
}
#endif

/*
 * ꡼ڡơ֥륢ɥ쥹꡼ɥ쥹֤
 * return : Physical address
 */
STATIC INLINE void *getAddrFromPhysTable(
	PHYS_MEM *memtable)
{
	return (void*) (((uint) memtable - PHYSICAL_PAGE_TABLE_ADD) / sizeof(PHYS_MEM) * PAGE_SIZE);
}

/*
 * ꡼ɥ쥹꡼ڡơ֥륢ɥ쥹
 * return : PHYS_MEM address
 */
STATIC INLINE PHYS_MEM *getPhysTableFromAddr(
	void *addr)			// Physical address
{
	return (PHYS_MEM*) ((uint) addr / PAGE_SIZE * sizeof(PHYS_MEM) + PHYSICAL_PAGE_TABLE_ADD);
}

/*
 * ꡼ڡơ֥뤫åȤ
 * return : å
 */
STATIC INLINE int *getLockgate(
	PHYS_MEM *i_memTbl)
{
	return &i_memTbl->lock;
}

/*
 * ʪ꡼¬ꤹ
 */
STATIC uint findAllMemsize()
{
	enum {EXIST_MEM_SIZE = 0x800000};		/* ꡼¬ñ */
	uint volatile *point;

	/* ꡼ñ̤Ȥ¬ꤹ*/
	for (point = (uint*) EXIST_MEM_SIZE - 1; ; point += EXIST_MEM_SIZE / sizeof(uint)) {
		*point = 0x5a5a5a5a;
		if (*point != 0x5a5a5a5a) {
			break;
		}
		else {
			*point = 0xf0f0f0f0;
			if(*point != 0xf0f0f0f0) {
				break;
			}
		}
	}

	return (all_memory_size = (uint) point - EXIST_MEM_SIZE + sizeof(uint));
}

/*
 * ꡼ڡơ֥
 */
STATIC void initPhysMemTable()
{
	PHYS_MEM *p = (PHYS_MEM*) PHYSICAL_PAGE_TABLE_ADD;
	int c_mtbl, last;

	// ǽ1Mbyteʬ꡼Ƥ롣
	for (c_mtbl = 0; c_mtbl < 0x100000 / PAGE_SIZE; ++c_mtbl) {
		p[c_mtbl].refCount = 1;
	}

	// Ĥե꡼ꤹ롣
	freeKernMem = &p[c_mtbl];
	for (last = all_memory_size / PAGE_SIZE; c_mtbl < last; ++c_mtbl) {
		p[c_mtbl].refCount = 0;
		p[c_mtbl].heap_num = 0;
		p[c_mtbl].lock = 0;
		p[c_mtbl].next = &p[c_mtbl + 1];
#ifdef DEBUG
	addFreeMemSize();
#endif
	}
	p[--c_mtbl].next = NULL;

	// 桼ΰե꡼
	if ((void*) KERNEL_DATA_END <= getAddrFromPhysTable(&p[c_mtbl])) {
		freeUserMem = getPhysTableFromAddr((void*) KERNEL_DATA_END);
		(freeUserMem-1)->next = NULL;
	}
	else {
		freeUserMem = NULL;
	}

	// ꡼ơ֥ʬ꡼ƤʲԲġˡ
	last = ROUNDUP(PHYSICAL_PAGE_TABLE_ADD + all_memory_size / PAGE_SIZE * sizeof(PHYS_MEM), PAGE_SIZE) / PAGE_SIZE;
	for (c_mtbl = PHYSICAL_PAGE_TABLE_ADD / PAGE_SIZE; c_mtbl < last; ++c_mtbl) {
		p[c_mtbl].refCount = 1;
#ifdef DEBUG
	subtractFreeMemSize();
#endif
	}
	if (&p[PHYSICAL_PAGE_TABLE_ADD / PAGE_SIZE] == freeKernMem) {
		freeKernMem = &p[last];
	}
	else{
		p[PHYSICAL_PAGE_TABLE_ADD/PAGE_SIZE-1].next = &p[last];
	}
}

/*
 * ꡼ơ֥ե꡼󥯤Ф
 *"physMemLock"ǥå줿椫ƤӽФ뤳
 * return : ꡼ơ֥륢ɥ쥹
 */
STATIC INLINE PHYS_MEM *getFreeMem(
	PHYS_MEM **freeTop)		// ե꡼ȥåץɥ쥹ݥ
{
	PHYS_MEM *mtbl = *freeTop;

	mtbl->refCount = 1;
	*freeTop = mtbl->next;
	mtbl->prev = mtbl->next = mtbl;
#ifdef DEBUG
	subtractFreeMemSize();
#endif

	return mtbl;
}

/*
 * ꡼ơ֥ե꡼󥯤˲ä롣
 *"physMemLock"ǥå줿椫ƤӽФ뤳
 */
STATIC INLINE void addFreeMem(
	PHYS_MEM *mtbl,		// ɲå꡼ơ֥
	PHYS_MEM **freeTop)	// ե꡼󥯥ȥå
{
	mtbl->refCount = 0;
	mtbl->next = *freeTop;
	*freeTop = mtbl;
#ifdef DEBUG
	addFreeMemSize();
#endif
}

/*
 * allocMultiKernelPage()ѡ
 * ե꡼ͥ꡼󥯤ƳƤ롣
 */
STATIC INLINE void delFreeKrnLink(
	PHYS_MEM *mtbl)		// ʪ꡼ơ֥륢ɥ쥹
{
	PHYS_MEM *p;

	if (mtbl == freeKernMem) {
		freeKernMem = mtbl->next;
	}
	else {
		for (p = freeKernMem; p->next != mtbl; p = p->next);
		p->next = mtbl->next;
	}

	mtbl->refCount = 1;
	mtbl->next = mtbl;
#ifdef DEBUG
	subtractFreeMemSize();
#endif
}

//================================== PUBLIC =============================================

/*
 * ʪ꡼ν
 */
void initPhysMem()
{
	/* Find size of physical memory  */
	printk("Memory size = %d MB\n",findAllMemsize() / 0x100000);

	/* ʪ꡼ơ֥ */
	initPhysMemTable();
}

/*
 * ʪ꡼
 * return : ʪ꡼
 */
uint getPhysMemSize()
{
	return all_memory_size;
}

/*
 *꡼ȥإåֹꤹ
 */
void setAllocNum(
	void *addr,
	int num)
{
	getPhysTableFromAddr(addr)->heap_num = num;
}

/*
 *꡼ȥإåֹ
 * return : ȥإåֹ
 */
int getAllocNum(
	void *addr)
{
	return getPhysTableFromAddr(addr)->heap_num;
}

/*
 * ֤ͥإ꡼ڡƤ
 * ƤڡϲԲ
 * return : ʪ꡼ or NULL
 */
//void *allocKernelPage()
void *allocKernelPage(int dummy)
{
	void *newMem;
	int eflag;

	eflag = enterCli();
	enter_spinlock(&physMemLock);
	{
		if (freeKernMem != NULL) {
			PHYS_MEM *mtbl = getFreeMem(&freeKernMem);
			newMem = getAddrFromPhysTable(mtbl);
		}
		else {
			newMem = NULL;
		}
	}
	exit_spinlock(&physMemLock);
	exitCli(eflag);

	return newMem;
}

/*
 * 桼֤إ꡼ڡƤ
 * Ƥڡϲ
 * return : Allocate addres or NULL
 */
void *allocUserPage()
{
	void *newMem;
	int eflag;

	eflag = enterCli();
	enter_spinlock(&physMemLock);
	{
		if (freeUserMem != NULL) {
			PHYS_MEM *mtbl = getFreeMem(&freeUserMem);
			newMem = getAddrFromPhysTable(mtbl);
		}
		else if (freeKernMem != NULL) {
			PHYS_MEM *mtbl = getFreeMem(&freeKernMem);
			newMem = getAddrFromPhysTable(mtbl);
		}
		else{
			newMem = NULL;
		}
	}
	exit_spinlock(&physMemLock);
	exitCli(eflag);

	return newMem;
}

/*
 * ֤ͥϢ³꡼ڡƤ
 * return : ƥɥ쥹 or failed=NULL
 */
void *allocMultiKernelPage(int num)
{
	void *rest;
	int cnt;
	uint maxmem;
	PHYS_MEM *p;
	int eflag;

	maxmem = (all_memory_size < KERNEL_DATA_END) ? all_memory_size : KERNEL_DATA_END;
	p = (PHYS_MEM*) (PHYSICAL_PAGE_TABLE_ADD + maxmem / PAGE_SIZE * sizeof(PHYS_MEM)) - 1;
	rest = NULL;
	cnt = 0;
	eflag = enterCli();
	enter_spinlock(&physMemLock);
	{
		for(;(PHYS_MEM*) PHYSICAL_PAGE_TABLE_ADD <= p; --p) {
			if (p->refCount == 0) {
				if (++cnt == num) {
					while (0 <= --cnt) {
						delFreeKrnLink(p + cnt);
					}
					rest = getAddrFromPhysTable(p);
					break;
				}
			}
			else {
				cnt=0;
			}
		}
	}
	exit_spinlock(&physMemLock);
	exitCli(eflag);

	return rest;
}

/*
 * ʪ꡼ڡλȥȤ䤹
 */
void linkPhysTable(
	void *i_addr)		// ʪɥ쥹
{
	PHYS_MEM *mtbl = getPhysTableFromAddr(i_addr);

	++mtbl->refCount;
}

/*
 * ʪ꡼ڡλȥȤ򸺤餹
 */
void unlinkPhysTable(
	void *addr)		// ʪɥ쥹
{
	PHYS_MEM *mtbl = getPhysTableFromAddr(addr);
	int eflag;

	--mtbl->refCount;
#ifdef DEBUG
	if (mtbl->refCount < 0) {
		printk("Warning! A No reference PhysTable is unlinked : addr=0x%x function=0x%x\n",addr,*((uint*) &addr - 1));
	}
#endif
	eflag = enterCli();
	enter_spinlock(&physMemLock);
	{
		if (mtbl->refCount <= 0) {
			/* ȥإåֹ򥯥ꥢ */
			mtbl->heap_num = 0;

			if ((uint) addr < KERNEL_DATA_END) {
				addFreeMem(mtbl, &freeKernMem);
			}
			else {
				addFreeMem(mtbl, &freeUserMem);
			}
		}
	}
	exit_spinlock(&physMemLock);
	exitCli(eflag);
}

/*
 * ʪ꡼ڡλȥȤ
 * return : ȥ
 */
int getPhysPageLinkCount(
	void *i_addr)		// ʪɥ쥹
{
	return getPhysTableFromAddr(i_addr)->refCount;
}

/*
 * ʪ꡼ڡԥå
 */
void enterPhysMemLock(
	void *i_addr)
{
	int *lock = getLockgate(getPhysTableFromAddr(i_addr));
	
	enter_spinlock(lock);
}

/*
 * ʪ꡼ڡԥå
 */
void exitPhysMemLock(
	void *i_addr)
{
	int *lock = getLockgate(getPhysTableFromAddr(i_addr));
	
	exit_spinlock(lock);
}
