/*
 * shell.c
 *
 * Copyright 200@, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 *
 */


#include <sys/config.h>
#include <sys/types.h>
#include <sys/param.h>
#include <lib/lib_path.h>
#include <kern/kmalloc.h>
#include <kern/fs.h>
#include <kern/loader.h>

#include <kern/debug.h>


//#define DEBUG_SHELL 1
#ifdef DEBUG_SHELL
	#define STATIC
	#define INLINE
#else
	#define STATIC	static
	#define INLINE	inline
#endif


//==================================  ===========================================

#define SHELL_MAGIC "#!"

//================================== Х륤ݡ ===============================

//================================== PRIVATE ============================================

//================================== PROTECTED ==========================================

static const char *getPrgName(
	const char *i_path)
{
	const char *name = i_path;
	const char *path;

	for (path = i_path; *path != '\0'; path = getNextPath(path)) {
		name = path;
	}

	return name;
}

//================================== PUBLIC =============================================

int loadShell(
	EXEC_FD *fd,
	const char *path,		// ¹ԥեѥ
	char **argv,
	char **envp,
	uint *o_entryAddr,		// åϥ˥ɥ쥹
	uint *o_stackAddr)		// ¹Գϥ˥ɥ쥹
{
	enum {
		SHELL_MAGIC_SIZE = 2,	// ޥåХȥ
	};
	char *header;
	char **argvSehll;
	const char *shellPath;
	int size;
	int last;
	int argvCount;
	int error;

	/* إåɤ߹ */
	header = kmalloc(SHELL_MAGIC_SIZE + PATH_MAX + 1);
	if (header == NULL) {
		return -ENOMEM;
	}

	fd->offset = 0;
	size = exec_read(fd, header, SHELL_MAGIC_SIZE + PATH_MAX);
	if (size < SHELL_MAGIC_SIZE) {
		error = (0 <= size) ? -ENOEXEC : size;
		goto ERR;
	}

	// ޥåʥСǧ
	if (memcmp(SHELL_MAGIC, header, SHELL_MAGIC_SIZE) != 0) {
		error = -ENOEXEC;
		goto ERR;
	}

	// ץѥ
	for (last = SHELL_MAGIC_SIZE; last < size; ++last) {
		if (header[last] == '\n') {
			break;
		}
	}
	header[last] = '\0';
	shellPath = &header[SHELL_MAGIC_SIZE];

	// argvγ
	argvCount = 0;
	while (argv[argvCount++] != NULL);
	argvSehll = kmalloc(sizeof(char*) * argvCount + 1);
	if (argvSehll == NULL) {
		error = -ENOMEM;
		goto ERR;
	}

	// argv
	argvSehll[0] = (char*) getPrgName(shellPath);
	argvSehll[1] = (char*) path;
	memcpy(argvSehll + 2, argv + 1, sizeof(char*) * argvCount - 1);

	error = loadFile(shellPath, argvSehll, envp, o_entryAddr, o_stackAddr);

	kfree(argvSehll);
ERR:
	kfree(header);

	return error;
}
