/*
 * term.h
 *
 * Copyright 2004, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#ifndef term_h
#define term_h


#include<sys/types.h>
#include"proc.h"
#include<sys/ttycom.h>
#include<sys/termios.h>
#include<sys/time.h>


#ifndef ASM_FILE


enum{
	LINE_BUF_SIZE=90,	/* Line buffer size. */
	TERM_EOF=0xff,		/* EOF character. */

	/* ޥåץɡ */
	MIN_MAPKEY	= 0x7f,		/* ղåǾ͡ */
	TRM_UP,					/*  */
	TRM_LFT,				/*  */
	TRM_RHT,				/*  */
	TRM_DWN,				/*  */
};


typedef struct{
	uchar crt;					/* ȥݥ */
	uchar last;					/* 饹ȥݥ */
	uchar lineTop;				/* 饤ȥåץݥ */
	uchar pastCrt;				/* ľΥȥݥ */
	uchar pastLast;				/* ľΥ饹ȥݥ */
	char buf[LINE_BUF_SIZE];	/* 󥽡Хåե */
}LINE_BUF;

typedef struct{
	void *ctlProc;				// üץ
	gid_t foregrnd;				// ե饦ɥץ롼
	void *waitTask;				// üХåեɤ߹Ԥץ
	void (*leftCursor)(int);
	void (*rightCursor)(int);
	void (*inputStr)(void);
	void (*newLine)(void);
	void (*carriageRetun)(void);
	void (*eraseLine)(void);
	void (*delete)(void);
	void (*backSpace)(void);
	void (*tab)(void);
} TERM_CTL;


extern int isForeground(const void *);
extern int isCtlproc(const void *);
extern void releaseTerm(void *);
extern int canReadTerm(struct termios*, TERM_CTL*, LINE_BUF*);
extern int readTerm(uchar*, size_t, struct termios*, TERM_CTL*, LINE_BUF*);
extern int writeTerm(uchar, struct termios*, TERM_CTL*, LINE_BUF*);


#endif


#endif
