/*
 * vm.c
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 *Գסղۥ꡼
 *
 *¡ա ʳδ¸Υڡ꥽ѹƤϤʤʤ
 *         ȤƤʤڡȥ꡼ɬ0ꥢ롣
 *
 *Ե§եڡХåå׻Υڡȥ꡼Υ쥤
 *        0bit=0,123bit=¸֥åֹ,2431bit=֥åȥ
 */

#include <sys/config.h>
#include <sys/param.h>
#include <sys/types.h>
#include <machine/vm.h>
#include <machine/Except.h>
#include <machine/interrupt.h>
#include <lib/lib.h>
#include <machine/mp.h>
#include <kern/lock.h>
#include <kern/ProcSignal.h>
#include <kern/fs.h>
#include <kern/physical_mem.h>
#include <kern/kmalloc.h>
#include <kern/page_swap.h>
#include <kern/proc.h>
#include <kern/Thread.h>
#include <kern/vm.h>

#include <kern/debug.h>

//#define DEBUG_VM 1
#ifdef DEBUG_VM
	#define STATIC
	#define INLINE
#else
	#define STATIC static
	#define INLINE	inline
#endif

//=====================================  ===================================================

/*
 * ץۥ꡼¤
 * ץˣ
 *ԱƶեСѹVmProcObjΥѹ뤳
 */
typedef struct {
	uint firstAddr;					// ƺѤߥڡۥɥ쥹
	uint lastAddr;					// ƺѤߥڡۥɥ쥹饹
	uint firstStackAddr;			// ѤߥåƬۥɥ쥹
	AggregateList aggrVmTask;		// ۥ꡼
	int spinLock;					// ԥå
} VmProc;

/*
 * ۥ꡼¤
 * ˣġץۥ꡼¤Τʣꤨ
 *ԱƶեСѹVmTaskObjΥѹ뤳
 */
typedef struct VmTask {
	VmProc *vmProc;					// ץۥ꡼¤
	List list;						// ץۥ꡼󥯥ꥹ
	uint *pageDir;					// ڡǥ쥯ȥ
	uint *restorePageDir;			// ̲۴ĶܹԻθ¸ڡǥ쥯ȥ
	void *kernStack;				// 桼ϥɥѥͥ륹å
	void *userStack;				// 桼ϥɥѥ桼å

	// ߻¸ƥ
	int saveIndex;					// ¸ǥå
	VmProc *saveVmProc[IRQ_ENTRY];	// ¸ۥ꡼
	uint *savePageDir[IRQ_ENTRY];	// ¸ۥ꡼
} VmTask;

//===================================== Х륤ݡ =======================================

//===================================== PRIVATE ====================================================

STATIC int vmTaskConstructor(
	VmTask *this)
{
	memset(this, 0, sizeof(*this));

	this->pageDir = allocKernelPage();
	if (this->pageDir == NULL) {
		return -ENOMEM;
	}
	memset(this->pageDir, 0, PAGE_SIZE);

	listConstructor(&this->list, this);

	// 桼᥽åѥͥ륹åƤ
	this->kernStack = allocKernelPage();
	if (this->kernStack == NULL) {
		return -ENOMEM;
	}
	copyFpuSaveArea(this->kernStack);

	return NOERR;
}

STATIC void vmProcConstructor(
	VmProc *this)
{
	memset(this, 0, sizeof(*this));
	AggregateListConstructor(&this->aggrVmTask);
}

/*
 * 桼ϥɥѥ桼åƤ
 * return : error number
 */
STATIC int allocUserHandlerStack(
	VmTask *this)
{
	if (this->userStack == NULL) {
		this->userStack = allocUserPage();
		if (this->userStack == NULL) {
			return -ENOMEM;
		}
	}
	return NOERR;
}

/*
 * ۥ꡼¤Τե
 *եۥ꡼ե˸ƤФ
 * return : error number
 */
STATIC int vmTaskFork(
	VmTask *this,
	VmTask *src)
{
	int error;

	if (src->userStack != NULL) {
		error = allocUserHandlerStack(this);
		if (error != NOERR) {
			return error;
		}
	}

	return NOERR;
}

//--------------------------------------------------------------------------------------------------
// ڡХåå
//--------------------------------------------------------------------------------------------------

/*
 * ڡȥ꡼Хååץ֥åֹ롣
 * return : block number
 */
STATIC INLINE uint getBackBlock(
	const uint pageEnt)
{
	return (pageEnt & 0xffffff) >> 1;
}

/*
 * ڡȥ꡼˥Хååץ֥åֹꤹ롣
 */
STATIC INLINE void setBackBlock(
	uint *m_pageEnt,		// page entry address
	const uint i_block)		// Хååץ֥åֹ
{
	*m_pageEnt = i_block << 1;
}

//--------------------------------------------------------------------------------------------------
// ԡ饤
//--------------------------------------------------------------------------------------------------

/*
 * ڡȥ꡼ԡ饤ȤꤵƤ뤫
 * return : YES or NO
 */
STATIC INLINE int isCopyOnWritePage(
	uint *pageDir,
	const uint i_addr)		// ۥɥ쥹
{
	uint *entry = getPageEntryAddr(i_addr, pageDir);
	return isCopyOnWrite(*entry);
}

/*
 * ԡ饤Ȥ
 * return : error number
 */
STATIC int resetCopyOnWritePage(
	uint *pageDir,
	const uint i_virtAddr)
{
	uint *entry = getPageEntryAddr(i_virtAddr, pageDir);
	uint *physMem;

	ASSERT(isCopyOnWrite(*entry) == YES);

	// ڡȥ꡼Υԡ饤Ȥ
	resetCopyOnWrite(entry);

	// ɬפʤʪ꡼Ƥ
	physMem = getPhysMemFromEntry(*entry);
	enterPhysMemLock(physMem);
	{
		if (1 < getPhysPageLinkCount(physMem)) {
			uint *newPhysMem;

			unlinkPhysTable(physMem);
			newPhysMem = allocUserPage();
			if (newPhysMem == NULL) {
				exitPhysMemLock(physMem);
				return -ENOMEM;
			}
			memcpy(newPhysMem, physMem, PAGE_SIZE);
			setPhysMemEntry(entry, newPhysMem);
		}
	}
	exitPhysMemLock(physMem);

	return NOERR;
}

//--------------------------------------------------------------------------------------------------
// ۥ꡼
//--------------------------------------------------------------------------------------------------

static uint *flatPageDir;		// ǡžѥեåȥ꡼ǥڡǥ쥯ȥ

/*
 * ֥꡼ԡѥեåȥ꡼ǥڡǥ쥯ȥκ
 * return : error number
 */
STATIC int creatFlatPageDir()
{
	uint *pageDir;
	int i;
	
	pageDir = allocKernelPage();
	if (pageDir == NULL) {
		return -ENOMEM;
	}
	
	// 4Mեåȥ꡼ڡ
	for (i = 0; i < IOMAP_BEG / PAGE_DIR_SIZE; ++i) {
		set4mPageEntry(i * PAGE_DIR_SIZE, &pageDir[i]);
	}

	// ꡼ޥåץIOڡѥǥ쥯ȥ
	for (i = IOMAP_BEG / PAGE_DIR_SIZE; i < PAGE_SIZE / sizeof(uint); ++i) {
		setIomapPageEntry(i * PAGE_DIR_SIZE, &pageDir[i]);
	}
	
	flatPageDir = pageDir;

	return NOERR;
}

/*
 * Υ桼ǡΰ褫ʪ꡼
 * return : error number
 */
STATIC int getPhysMemFromUserPage(
	const uint i_lastVirtAddr,		// ƺѤߥڡ饹Ȳۥɥ쥹
	uint *m_pageDir,
	void **o_physMem)
{
	int lastDir;
	int lastPage;
	int c_dir;

	lastDir = ROUNDUP_DIV(i_lastVirtAddr, PAGE_DIR_SIZE);
	for (c_dir = USER_BEG / PAGE_DIR_SIZE; c_dir < lastDir; ++c_dir) {
		// Ĥäǽν߲ĥڡʪ꡼֤
		uint *pageTbl = getPhysMemFromEntry(m_pageDir[c_dir]);
		int c_tbl;
		
		lastPage = ROUNDUP_DIV(i_lastVirtAddr - c_dir * PAGE_DIR_SIZE, PAGE_SIZE);
		if (PAGE_SIZE / sizeof(uint) < lastPage) {
			lastPage = PAGE_SIZE / sizeof(uint);
		}
		for (c_tbl = 0; c_tbl < lastPage; ++c_tbl) {
			if (isPagePresenEntry(pageTbl[c_tbl]) == NO) {
				continue;
			}
			if (pageTbl[c_tbl] & PAGE_RW) {
				void *physMem = getPhysMemFromEntry(pageTbl[c_tbl]);
				uint block;
				int error;
				
				// ХååץǥХ˥֤
				error = writePage(physMem, &block);
				if (error != NOERR) {
					return error;
				}
				setBackBlock(&pageTbl[c_tbl], block);
				*o_physMem = physMem;
				return NOERR;
			}
		}
	}

	return -ENOMEM;
}

/*
 * ʪ꡼̤ڡʪ꡼Ƥ
 *ոƤӽФ˥ץñ̤¾椵Ƥ
 * return : error number
 */
STATIC int allocPageMem(
	const uint i_virtAddr,
	VmTask *vmTask,
	VmProc *vmProc)
{
	uint *pageDir = vmTask->pageDir;
	uint *pageDirEnt = getPageDirEntryAddr(i_virtAddr, pageDir);
	uint *pageEnt;
	int error;

	// ڡơ֥Ƥ
	if (*pageDirEnt == 0) {
		void *pageTbl;

		/*
		 * ¾åɤǴ˳ƤƤ饨ȥ꡼򥳥ԡ
		 */
		if (2 <= vmProc->aggrVmTask.getCount(&vmProc->aggrVmTask)) {
			IteratorList iterator;
			vmProc->aggrVmTask.iterator(&vmProc->aggrVmTask, &iterator);
			while (iterator.hasNext(&iterator) == BOOL_TRUE) {
				VmTask *next = iterator.next(&iterator);
				if (next->pageDir[i_virtAddr / PAGE_DIR_SIZE] != 0) {
					void *physMem  = getPhysMemFromEntry(next->pageDir[i_virtAddr / PAGE_DIR_SIZE]);
					*pageDirEnt = next->pageDir[i_virtAddr / PAGE_DIR_SIZE];
					linkPhysTable(physMem);
					break;
				}
			}
		}

		if (*pageDirEnt == 0) {
			pageTbl = allocKernelPage();
			if (pageTbl == NULL) {
				// Υ桼ǡΰ褫ʪ꡼
				error = getPhysMemFromUserPage(vmProc->lastAddr, pageDir, &pageTbl);
				if (error != NOERR) {
					return error;
				}
			}
			memset (pageTbl, 0, PAGE_SIZE);
			setUserRwPageDirEntry(pageTbl, pageDirEnt);
		}
	}

	// ڡƤ
	pageEnt = getPageEntryAddrFromPageTbl(i_virtAddr, getPhysMemFromEntry(*pageDirEnt));
	if (isPagePresenEntry(*pageEnt) == NO) {
		void *physMem = allocUserPage();
		if (physMem == NULL) {
			// Υ桼ǡΰ褫ʪ꡼
			error = getPhysMemFromUserPage(vmProc->lastAddr, pageDir, &physMem);
			if (error != NOERR) {
				return error;
			}
		}

		// Хååפ
		if (*pageEnt != 0) {
			error = readPage(getBackBlock(*pageEnt), physMem);
			if (error != NOERR) {
				return error;
			}
			freePageBlock(getBackBlock(*pageEnt));
		}

		setUserRwPageEntry(physMem, pageEnt);
	}
	else {
		// ¾åɤǴ˥ڡƤ硢⤷ʤ
	}

	return NOERR;
}

/*
 * ڡȥڡơ֥ʪƤ
 * return : error number
 */
STATIC int allocPage(
	uint *i_pageDir,
	const uint i_firstAddr,					// ɥ쥹
	const uint i_lastAddr,					// λɥ쥹
	void setPageDirEnt(const void*, uint*),	// ڡǥ쥯ȥꥨȥ꡼᥽å
	void setPageEnt(const void*, uint*))	// ڡȥ꡼᥽å
{
	int lastDir;
	int firstPage;
	int lastPage;
	int c_dir;

	lastDir = ROUNDUP_DIV(i_lastAddr, PAGE_DIR_SIZE);
	firstPage = (i_firstAddr & (PAGE_DIR_SIZE - 1)) / PAGE_SIZE;
	for (c_dir = i_firstAddr / PAGE_DIR_SIZE; c_dir < lastDir; ++c_dir) {
		int c_page;
		uint *pageTbl = getPhysMemFromEntry(i_pageDir[c_dir]);
		if (pageTbl == NULL) {
			// ڡơ֥ʪ꡼Ƥ
			pageTbl = allocKernelPage();
			if (pageTbl == NULL) {
				return -ENOMEM;
			}
			memset(pageTbl, 0, PAGE_SIZE);
			setPageDirEnt(pageTbl, &i_pageDir[c_dir]);
		}

		// ڡʪ꡼Ƥ
		lastPage = ROUNDUP_DIV(i_lastAddr - c_dir * PAGE_DIR_SIZE, PAGE_SIZE);
		if (PAGE_SIZE / sizeof(uint) < lastPage) {
			lastPage = PAGE_SIZE / sizeof(uint);
		}
		for (c_page = firstPage; c_page < lastPage; ++c_page) {
			if (pageTbl[c_page] == 0) {
				void *physMem = allocUserPage();
				if (physMem == NULL) {
					return -ENOMEM;
				}
				setPageEnt(physMem, &pageTbl[c_page]);
			}
		}
		firstPage = 0;
	}
	
	return NOERR;
}

/*
 * ڡȥڡơ֥ڡñ̤ǳ롣
 *ոƤӽФ˥ץñ̤¾椵Ƥ
 *Իեڡǥ쥯ȥñ̤ǳ
 */
STATIC void releasePage(
	uint *i_pageDir,
	const uint i_firstAddr,		// ڡեȥɥ쥹
	const uint i_lastAddr)		// ڡ饹ȥɥ쥹
{
	int lastDir;
	int firstPage;
	int lastPage;
	int c_dir;

	lastDir = ROUNDUP_DIV(i_lastAddr, PAGE_DIR_SIZE);
	firstPage = (i_firstAddr & (PAGE_DIR_SIZE - 1)) / PAGE_SIZE;
	for (c_dir = i_firstAddr / PAGE_DIR_SIZE; c_dir < lastDir; ++c_dir) {
		uint *pageTbl;
		int c_page;

		if (i_pageDir[c_dir] == 0) {
			continue;
		}

		pageTbl = getPhysMemFromEntry(i_pageDir[c_dir]);

		// ڡȥ꡼γ
		if (getPhysPageLinkCount(pageTbl) == 1) {
			lastPage = ROUNDUP_DIV(i_lastAddr - c_dir * PAGE_DIR_SIZE, PAGE_SIZE);
			if (PAGE_SIZE / sizeof(uint) < lastPage) {
				lastPage = PAGE_SIZE / sizeof(uint);
			}
			for (c_page = firstPage; c_page < lastPage; ++c_page) {
				if (pageTbl[c_page] == 0) {
					continue;
				}

				// ѤƤڡ
				if (isPagePresenEntry(pageTbl[c_page]) == YES) {
					void *physMem = getPhysMemFromEntry(pageTbl[c_page]);
					enterPhysMemLock(physMem);
					{
						unlinkPhysTable(physMem);
					}
					exitPhysMemLock(physMem);
				}
				else {
					/* ڡХååפƤ */
					freePageBlock(getBackBlock(pageTbl[c_page]));
				}
			}
		}

		// ڡǥ쥯ȥñ̤ǳΤǥڡơ֥
		unlinkPhysTable(pageTbl);
		i_pageDir[c_dir] = 0;

		firstPage = 0;
	}
}

/*
 * ڡ򥳥ԡ
 *եԡڡϤ٤ʪ꡼ƤƤ뤳
 * return : error number
 */
STATIC int copyPage(
	uint *dstPageDir,			// ԡڡǥ쥯ȥ
	uint *srcPageDir,			// ԡڡǥ쥯ȥ
	const uint i_firstAddr,		// ɥ쥹
	const uint i_lastAddr)		// λɥ쥹
{
	int lastDir;
	int firstPage;
	int lastPage;
	int c_dir;
	int error;

	lastDir = ROUNDUP_DIV(i_lastAddr, PAGE_DIR_SIZE);
	firstPage = (i_firstAddr & (PAGE_DIR_SIZE - 1)) / PAGE_SIZE;
	for (c_dir = i_firstAddr / PAGE_DIR_SIZE; c_dir < lastDir; ++c_dir) {
		uint *dstPageTbl = getPhysMemFromEntry(dstPageDir[c_dir]);
		uint *srcPageTbl = getPhysMemFromEntry(srcPageDir[c_dir]);
		int c_page;

		ASSERT(dstPageTbl != NULL);

		if (srcPageTbl != NULL) {
			lastPage = ROUNDUP_DIV(i_lastAddr - c_dir * PAGE_DIR_SIZE, PAGE_SIZE);
			if (PAGE_SIZE / sizeof(uint) < lastPage) {
				lastPage = PAGE_SIZE / sizeof(uint);
			}
			for (c_page = firstPage; c_page < lastPage; ++c_page) {
				ASSERT(dstPageTbl[c_page] != 0);

				if (srcPageTbl[c_page] != 0) {
					if (isPagePresenEntry(srcPageTbl[c_page]) == YES) {
						memcpy(getPhysMemFromEntry(dstPageTbl[c_page]), getPhysMemFromEntry(srcPageTbl[c_page]), PAGE_SIZE);
					}
					else {
						error = readPage(getBackBlock(srcPageTbl[c_page]), getPhysMemFromEntry(dstPageTbl[c_page]));
						if (error != NOERR) {
							return error;
						}
					}
				}
			}
		}
		firstPage = 0;
	}
	
	return NOERR;
}

/*
 * ƥڡ饳ԡ饤Ȥꤹ
 *vmFork()ƤФ
 */
STATIC int copyOnWritePage(
	uint *dstPageDir,			// ԡڡǥ쥯ȥ
	uint *srcPageDir,			// ԡڡǥ쥯ȥ
	const uint i_firstAddr,		// ɥ쥹
	const uint i_lastAddr)		// λɥ쥹
{
	int lastDir;
	int firstPage;
	int lastPage;
	int c_dir;
	int error;

	/*
	 * Userΰ򥳥ԡ饤Ȥꤹ롣
	 * ƤΥڡơ֥륨ȥ꡼񤭹߲Ĥʤ顢񤭹ԲĤˤƥԡ饤ȥե饰ꤹ롣
	 */
	lastDir = ROUNDUP_DIV(i_lastAddr, PAGE_DIR_SIZE);
	firstPage = (i_firstAddr & (PAGE_DIR_SIZE - 1)) / PAGE_SIZE;
	for (c_dir = i_firstAddr / PAGE_DIR_SIZE; c_dir < lastDir; ++c_dir) {
		if (srcPageDir[c_dir] != 0) {
			uint *dstPageTbl;
			uint *srcPageTbl;
			int c_page;

			// ڡơ֥Ƥ
			dstPageTbl = allocKernelPage();
			if (dstPageTbl == NULL) {
				return -ENOMEM;
			}
			setUserRwPageDirEntry(dstPageTbl, &dstPageDir[c_dir]);
			srcPageTbl = getPhysMemFromEntry(srcPageDir[c_dir]);
			memcpy(dstPageTbl, srcPageTbl, PAGE_SIZE);

			lastPage = ROUNDUP_DIV(i_lastAddr - c_dir * PAGE_DIR_SIZE, PAGE_SIZE);
			if (PAGE_SIZE / sizeof(uint) < lastPage) {
				lastPage = PAGE_SIZE / sizeof(uint);
			}
			for (c_page = firstPage; c_page < lastPage; ++c_page) {
				if (dstPageTbl[c_page] != 0) {
					void *physMem;

					// ԡ饤Ȥ
					if (isPagePresenEntry(dstPageTbl[c_page]) == YES) {
						physMem = getPhysMemFromEntry(dstPageTbl[c_page]);
						enterPhysMemLock(physMem);
						{
							linkPhysTable(physMem);
						}
						exitPhysMemLock(physMem);
						setCopyOnWrite(&srcPageTbl[c_page]);
						setCopyOnWrite(&dstPageTbl[c_page]);
					}
					else {
						physMem = allocUserPage();
						if (physMem == NULL) {
							return -ENOMEM;
						}
						error = readPage(getBackBlock(dstPageTbl[c_page]), physMem);
						if (error != NOERR) {
							return error;
						}
						setRwPageEntry(physMem, &dstPageTbl[c_page]);
					}
				}
			}
		}
		firstPage = 0;
	}
	
	return NOERR;
}

/*
 * 桼᥽åѥå
 */
STATIC void freeUserMethodStack(
	VmTask *m_vmTask)
{
	if (m_vmTask->userStack != NULL) {
		unlinkPhysTable(m_vmTask->userStack);
	}

	if (m_vmTask->kernStack != NULL) {
		unlinkPhysTable(m_vmTask->kernStack);
	}
}

/*
 * ɥ쥹ȿǤʤ
 * return : NOERR or ERR
 */
STATIC int isCorrectAccess(
	const uint i_firstAddr,
	const uint i_lastAddr)
{
	VmProc *vmProc = (VmProc*) getVmProc(getCurrentProc());

	if ((vmProc->firstAddr <= i_firstAddr) && (i_lastAddr <= vmProc->lastAddr)) {
		return NOERR;
	}
	else if ((vmProc->firstStackAddr - PAGE_SIZE * 2 <= i_firstAddr) && (i_lastAddr < USER_ESP_BEG)) {
		return NOERR;
	}
	else if ((DRIVER_STACK_BEG <= i_firstAddr) && (i_lastAddr <= DRIVER_STACK_END)) {
		return NOERR;
	}
	else {
		return ERR;
	}
}

/*
 * եåȥ꡼ǥĶذܹ
 */
STATIC void switchFlatPageDir(
	VmTask *currentVmTask)
{
	int eflags;

	eflags = enterCli();
	{
		uint addr;

		// ͥ륹åڡǥ쥯ȥ򥳥ԡ
		for (addr = KERNEL_STACK_BEG; addr < KERNEL_END; addr += PAGE_DIR_SIZE) {
			uint *p_pageEnt = getPageDirEntryAddr(addr, flatPageDir);
			*p_pageEnt = *getPageDirEntryAddr(addr, currentVmTask->pageDir);

		}

		// ۥ꡼Ķܹ
		currentVmTask->restorePageDir = currentVmTask->pageDir;
		currentVmTask->pageDir = flatPageDir;
		updatePageDir(currentVmTask->pageDir);
	}
	exitCli(eflags);
}

/*
 * β۴Ķ᤹
 */
STATIC void restorePageDir(
	VmTask *currentVmTask)
{
	int eflags;

	eflags = enterCli();
	{
		// βۥ꡼Ķܹ
		currentVmTask->pageDir = currentVmTask->restorePageDir;
		updatePageDir(currentVmTask->pageDir);
	}
	exitCli(eflags);
}

//===================================== PUBLIC =====================================================

/*
 * ۥ꡼ƥν
 * error number
 */
int VmInit()
{
#ifdef DEBUG
	if (sizeof(VmProc) != sizeof(VmProcObj)) {
		printk("VmInit() object size error! VmProc=%d VmProcObj=%d\n", sizeof(VmProc), sizeof(VmProcObj));
		idle();
	}
	if (sizeof(VmTask) != sizeof(VmTaskObj)) {
		printk("VmInit() object size error! VmTask=%d VmTaskObj=%d\n", sizeof(VmTask), sizeof(VmTaskObj));
		idle();
	}
#endif

	return creatFlatPageDir();
}

//--------------------------------------------------------------------------------------------------
// ۥ꡼
//--------------------------------------------------------------------------------------------------

/*
 * ۥץ¤Τꤹ
 */
void initVmProc(
	VmProcObj *m_vmProc)
{
	VmProc *vmProc = (VmProc*) m_vmProc;

	vmProcConstructor(vmProc);
	vmProc->firstStackAddr = USER_ESP_BEG;
}

/*
 * CPUȤ˲ۥ꡼򳫻Ϥ롣
 *initVmProc()ƤӽФѤǤ뤳
 * return : error number
 */
int createVm(
	VmTaskObj *m_vmTask,
	VmProcObj *m_vmProc)
{
	VmTask *vmTask = (VmTask*) m_vmTask;
	VmProc *vmProc = (VmProc*) m_vmProc;
	uint *pageDir;
	int error;
	int i;

	error = vmTaskConstructor(vmTask);
	if (error != NOERR) {
		return error;
	}
	pageDir = vmTask->pageDir;

	// ͥǡڡǥ쥯ȥ
	for (i = 0; i < KERNEL_DATA_END / PAGE_DIR_SIZE; ++i) {
		set4mPageEntry(i * PAGE_DIR_SIZE, &pageDir[i]);
	}

	// ͥ륹åƤ
	error = allocPage(pageDir, KERNEL_STACK_END - PAGE_SIZE, KERNEL_STACK_END, setRwPageDirEntry, setRwPageEntry);
	if (error != NOERR) {
		return error;
	}

	// ɥ饤СåƤ
	error = allocPage(pageDir, DRIVER_STACK_END - PAGE_SIZE, DRIVER_STACK_END, setUserRwPageDirEntry, setUserRwPageEntry);
	if (error != NOERR) {
		return error;
	}

	// ꡼ޥåץIOڡǥ쥯ȥ
	for (i = IOMAP_BEG / PAGE_DIR_SIZE; i < PAGE_SIZE / sizeof(uint); ++i) {
		setIomapPageEntry(i * PAGE_DIR_SIZE, &pageDir[i]);
	}

	// ۥ¤Τۥץ¤ΤϿ
	vmTask->vmProc = vmProc;
	vmProc->aggrVmTask.insertHead(&vmProc->aggrVmTask, &vmTask->list);

	vmTask->pageDir = pageDir;

	// ڡ󥰳
	enablePaging(pageDir);

	return NOERR;
}

/*
 * ƥץβۥץ¤Τ򥳥ԡ
 */
void vmProcFork(
	VmProcObj *i_dstVmProc,
	VmProcObj *i_srcVmProc)
{
	VmProc *dstVmProc = (VmProc*) i_dstVmProc;
	VmProc *srcVmProc = (VmProc*) i_srcVmProc;

	vmProcConstructor(dstVmProc);
	dstVmProc->firstAddr = srcVmProc->firstAddr;
	dstVmProc->lastAddr = srcVmProc->lastAddr;
	dstVmProc->firstStackAddr = srcVmProc->firstStackAddr;
}

/*
 * ƥץΥ꡼ƥȤ򥳥ԡ
 *պǽΥåɺvmProcFork()ƤӽФѤǤ뤳
 * return : error number or 1 = 
 */
int vmFork(
	const int isKernelThread,			// ͥ륹åɤȤ"0"ʳ
	VmTaskObj *m_parentVmTask,
	VmTaskObj *m_vmTask,
	VmProcObj *m_vmProc)
{
	VmTask *parentVmTask = (VmTask*) m_parentVmTask;
	uint *parentPageDir = parentVmTask->pageDir;
	uint *pageDir;
	VmTask *vmTask = (VmTask*) m_vmTask;
	VmProc *vmProc = (VmProc*) m_vmProc;
	void *stack;
	int i;
	int error;

	error = vmTaskConstructor(vmTask);
	if (error != NOERR) {
		return error;
	}
	pageDir = vmTask->pageDir;

	// ۥ꡼¤Τե
	error = vmTaskFork(vmTask, parentVmTask);
	if (error != NOERR) {
		return error;
	}

	// ͥǡڡǥ쥯ȥ򥳥ԡ
	for (i = 0; i < KERNEL_DATA_END / PAGE_DIR_SIZE; ++i) {
		pageDir[i] = parentPageDir[i];
	}

	// ꡼ޥåץIOڡǥ쥯ȥ򥳥ԡ
	for (i = IOMAP_BEG / PAGE_DIR_SIZE; i < PAGE_SIZE / sizeof(uint); ++i) {
		pageDir[i] = parentPageDir[i];
	}

	// ͥ륹å򥿥Ȥ˳Ƥ
	error = allocPage(pageDir, KERNEL_STACK_END - PAGE_SIZE, KERNEL_STACK_END, setRwPageDirEntry, setRwPageEntry);
	if (error != NOERR) {
		goto ERR1;
	}

	// 桼ΰʪ꡼˥Ǥ褦եåȥ꡼۴Ķ˰ܹ
	switchFlatPageDir(parentVmTask);

	if (isKernelThread != 0) {
		/*
		 * 桼ۥ꡼ΰϻѤʤ
		 */
		vmProc->lastAddr = KERNEL_END;
		vmProc->firstStackAddr = USER_ESP_BEG;
	}
	else {
		// ɥ饤СåƤ
		error = allocPage(pageDir, DRIVER_STACK_END - PAGE_SIZE, DRIVER_STACK_END, setUserRwPageDirEntry, setUserRwPageEntry);
		if (error != NOERR) {
			goto ERR2;
		}
	
		if (vmProc->aggrVmTask.getCount(&vmProc->aggrVmTask) == 0) {
			// 桼ƥȥǡ򥳥ԡ饤Ȥꤹ
			error = copyOnWritePage(pageDir, parentPageDir, vmProc->firstAddr, vmProc->lastAddr);
			if (error != NOERR) {
				goto ERR2;
			}
		}
		else {
			// ¾åɤΥڡǥ쥯ȥ򥳥ԡ
			int last = ROUNDUP_DIV(vmProc->lastAddr, PAGE_DIR_SIZE);
			for (i = USER_BEG / PAGE_DIR_SIZE; i < last; ++i) {
				if (parentPageDir[i] != 0) {
					void *physMem = getPhysMemFromEntry(parentPageDir[i]);
					linkPhysTable(physMem);
					pageDir[i] = parentPageDir[i];
				}
			}
		}

		// 桼å򥿥Ȥ˳Ƥ
		error = allocPage(pageDir, vmProc->firstStackAddr, USER_ESP_BEG, setUserRwPageDirEntry, setUserRwPageEntry);
		if (error != NOERR) {
			goto ERR3;
		}
		error = copyPage(pageDir, parentPageDir, vmProc->firstStackAddr, USER_ESP_BEG);
		if (error != NOERR) {
			goto  ERR3;
		}
	}
	
	// ͥ륹å˥ƥȤꤹ롣
	stack = getPhysMemFromEntry(*getPageEntryAddr(KERNEL_STACK_END - PAGE_SIZE, pageDir));
	if (setChildContext(stack) == YES) {
		// ¹Գ
		return 1;
	}

	// ۥ¤Τۥץ¤ΤϿ
	vmTask->vmProc = vmProc;
	vmProc->aggrVmTask.insertHead(&vmProc->aggrVmTask, &vmTask->list);

	// եåȥ꡼۴Ķꡢƥڡǥ쥯ȥ򹹿
	restorePageDir(parentVmTask);

	return NOERR;
ERR3:
	releasePage(pageDir, vmProc->firstStackAddr, USER_ESP_BEG);
	if (vmProc->aggrVmTask.getCount(&vmProc->aggrVmTask) == 0) {
		releasePage(pageDir, vmProc->firstAddr, vmProc->lastAddr);
	}
ERR2:
	releasePage(pageDir, DRIVER_STACK_BEG, DRIVER_STACK_END);
ERR1:
	releasePage(pageDir, KERNEL_STACK_BEG, KERNEL_STACK_END);
	unlinkPhysTable(pageDir);

	return error;
}

/*
 * ¹ԥե꡼˥ɤ
 * EXEC_FDݥ󥿤NULLʤ꡼0ꥢ롣
 * return : error number
 */
int loadBinary(
	VmTaskObj *vmTask,
	VmProcObj *m_vmProc,
	EXEC_FD *open_f,		// EXEC_FDݥ
	size_t size,			// ƥХȿ
	size_t load_size,		// ɥХȿ
	uint i_firstAddr,		// ɳϲۥɥ쥹
	int attribute)			// ڡ°ɹߤΤ=LB_R,ɤ߽=LB_WR
{
	uint *pageDir = ((VmTask*) vmTask)->pageDir;
	VmProc *vmProc = (VmProc*) m_vmProc;
	uint *pageEnt;
	uint addr,last;
	int error;

	last = i_firstAddr + size;

	// ɥʬ꡼Ƥ
	error = allocPage(pageDir, i_firstAddr, last, setUserRwPageDirEntry, setUserRwPageEntry);
	if (error != NOERR) {
		goto ERR;
	}

	// ե뤫꡼ɤ߹
	updatePageDir(pageDir);
	error = exec_read(open_f, (void*) i_firstAddr, load_size);
	if (error != load_size) {
		if (0 <= error) {
			error = -EIO;
		}
		goto ERR;
	}

	// ե뤫ɤ߹ʬʹߤΥ꡼ϥꥢ
	memset((char*) i_firstAddr + load_size, 0, size - load_size);

	// ڡ°ɹߤʤꤷľ
	if (attribute == LB_R) {
		for (addr = i_firstAddr; addr < last; addr += PAGE_SIZE) {
			pageEnt = getPageEntryAddr(addr, pageDir);
			setUserReadPageEntry(getPhysMemFromEntry(*pageEnt), pageEnt);
		}
		updatePageDir(pageDir);
	}

	// ڡϡλɥ쥹򹹿
	if (vmProc->firstAddr == 0) {
		vmProc->firstAddr = ROUNDDOWN(i_firstAddr, PAGE_SIZE);
	}
	else if (i_firstAddr < vmProc->firstAddr) {
		vmProc->firstAddr = ROUNDDOWN(i_firstAddr, PAGE_SIZE);
	}
	if (vmProc->lastAddr < last) {
		vmProc->lastAddr = ROUNDUP(last, PAGE_SIZE);
	}

	error = NOERR;
ERR:
	return error;
}

/*
 * βۥ꡼Ķ
 */
void releaseVmTask(
	VmTaskObj *m_vmTask,
	VmProcObj *i_vmProc)
{
	VmTask *vmTask = (VmTask*) m_vmTask;
	VmProc *vmProc = (VmProc*) i_vmProc;
	uint *pageDir = vmTask->pageDir;

	enter_spinlock(&vmProc->spinLock);
	{
		// 桼ƥȡǡڡ롣
		releasePage(pageDir, vmProc->firstAddr, vmProc->lastAddr);

		// 桼å롣
		releasePage(pageDir, vmProc->firstStackAddr, USER_END);

		// ɥ饤Сåڡ롣
		releasePage(pageDir, DRIVER_STACK_BEG, DRIVER_STACK_END);

		// ͥ륹åڡ롣
		releasePage(pageDir, KERNEL_STACK_BEG, KERNEL_STACK_END);

		unlinkPhysTable(pageDir);

		vmProc->aggrVmTask.removeEntry(&vmProc->aggrVmTask, &vmTask->list);
	}
	exit_spinlock(&vmProc->spinLock);
	
	freeUserMethodStack(vmTask);
}

/*
 * 桼ΥƥȤȥǡڡ롣
 *exec˸ƤФ
 */
void releaseUserPage(
	VmTaskObj *i_vmTask,
	VmProcObj *i_vmProc)
{
	VmTask *vmTask = (VmTask*) i_vmTask;
	VmProc *vmProc = (VmProc*) i_vmProc;

	releasePage(vmTask->pageDir, vmProc->firstAddr, vmProc->lastAddr);

	// ͭۥɥ쥹ΰ
	vmProc->firstAddr =  USER_BEG;
	vmProc->lastAddr = USER_BEG;
}

/*
 * 桼åꤹ
 * return : error number
 */
int setArgEnv(
	VmTaskObj *vmTask,
	VmProcObj *m_vmProc,
	char **argv,
	char **envp,
	uint *o_stackAddr)
{
	/*
	 * 桼å
	 *  0xfebfffff 顼ʥС
	 *  0xfebffffb Ķѿ
	 *                 
	 *               
	 *                 
	 *             Ķѿɥ쥹
	 *             ɥ쥹
	 *             Ķѿɥ쥹ݥ
	 *             ɥ쥹ݥ
	 *             
	 */

	extern int calcArgLen(char **, char **, int *, int *);
//	uint *pageDir = ((VmTask*) vmTask)->pageDir;
//	VmProc *vmProc = (VmProc*) m_vmProc;
	void *buf;
	uint stack;
	char *str;
	char *tmp = NULL;
	uint diff;
	int argSize;
	int argc,envc;
	uint esp;
	int i;

	/* NULLʤ鲾Ϳ롣 */
	if (argv == NULL) {
		argv = &tmp;
	}
	if (envp == NULL) {
		envp = &tmp;
	}

	/* "sizeof(SYS_INFO)+sizeof(int)"ϥƥǼѤmain()Υ꥿󥢥ɥ쥹Ǽѡ */
	argSize = calcArgLen(argv, envp, &argc, &envc);
	if (PAGE_SIZE < argSize + sizeof(SYS_INFO) + sizeof(int)){
		WARNING(0);
		return -E2BIG;
	}

	buf = kmalloc(argSize + sizeof(SYS_INFO) + sizeof(int));
	if(buf == NULL){
		return -ENOMEM;
	}
	diff = USER_ESP_BEG - (uint)buf - (argSize + sizeof(SYS_INFO));
	stack = (uint)buf;

	*(int*) stack = argc;														/* argc. */
	stack += sizeof(int);
	*(uint*) stack = stack + sizeof(char**) * 2 + diff;							/* argv. */
	stack += sizeof(char**);
	*(uint*) stack = stack + sizeof(char**) + sizeof(char*) * (argc + 1) + diff;	/* envp. */
	stack += sizeof(char**);

	str = (char*) ((char**) stack + (argc + envc + 2));

	/* argvΥԡ */
	for (i = 0; i < argc; ++i) {
		((char**) stack)[i] = str + diff;
		str += cpystr(str,argv[i]);
	}
	((char**) stack)[i] = NULL;
	stack += sizeof(char*) * (i + 1);

	/* envpΥԡ */
	for (i = 0; i < envc; ++i) {
		((char**) stack)[i] = str + diff;
		str += cpystr(str,envp[i]);
	}
	((char**) stack)[i] = NULL;

	/* Хåե饹å˥ԡ */
	memcpy((void*) (USER_ESP_BEG - argSize - sizeof(SYS_INFO)), buf, argSize);

	kfree(buf);

	/* esp */
	esp = USER_ESP_BEG - argSize - sizeof(SYS_INFO) - sizeof(int);

	/* ʹߤΥåڡ */
//	releasePage(pageDir, vmProc->firstStackAddr, ROUNDDOWN(esp, PAGE_SIZE));

	/* ƬΥåɥ쥹ꤹ */
//	vmProc->firstStackAddr = ROUNDDOWN(esp, PAGE_SIZE);
	
	*o_stackAddr = esp;

	return NOERR;
}

/*
 * ڡեȽ
 * todo
 *  桼åڡԺߤνθľ(¤ߤ)
 */
void pageFault(
	VmTaskObj *m_vmTask,
	VmProcObj *m_vmProc,
	const uint i_faultAddr,
	TaskContext *i_frame)
{
	/* 顼ɥӥåȥޥ */
	enum{
		PRESEN		= 1,
		PAGE_WRITE	= 2,
		USER_MODE	= 4,
		RSVBIT		= 8,
	};
	VmTask *vmTask = (VmTask*) m_vmTask;
	VmProc *vmProc = (VmProc*) m_vmProc;
	int error;
	
	// ڡȥͽӥå㳰
	if (i_frame->error & RSVBIT) {
		printk("\nPage entry reserve bit vioration!\n");
		printContext(i_frame);
		forceSendSignal(TaskGetTaskSignal(getCurrentTask()), SIGSEGV);
		return;
	}

	// ꡼ȿΥå
	if (isCorrectAccess(i_faultAddr, i_faultAddr + 1) == ERR) {
		printk("\nPage privilege violation! Fault Address = 0x%x\n", i_faultAddr);
		printContext(i_frame);
		forceSendSignal(TaskGetTaskSignal(getCurrentTask()), SIGSEGV);
		return;
	}

	// ڡԺ
	if ((i_frame->error & PRESEN) == 0) {
		// ڡȥ꡼˥ڡ꡼Ƥ
		enter_spinlock(&vmProc->spinLock);
		{
			error = allocPageMem(i_faultAddr, vmTask, vmProc);
		}
		exit_spinlock(&vmProc->spinLock);
		if (error == NOERR) {
			if ((vmProc->firstStackAddr - PAGE_SIZE * 2 <= i_faultAddr) && (i_faultAddr < vmProc->firstStackAddr)) {
				vmProc->firstStackAddr = ROUNDDOWN(i_faultAddr, PAGE_SIZE);
			}
			updatePageDir(vmTask->pageDir);
		}
		else {
			printk("\nallocPageMem() error! : %d ", error);
			forceSendSignal(TaskGetTaskSignal(getCurrentTask()), SIGSEGV);
		}
		return;
	}

	// ԡ饤
	if (isCopyOnWritePage(vmTask->pageDir, i_faultAddr) == YES) {
		// ԡ饤ȤΥڡȥ꡼˥ڡ꡼Ƥ
		error = resetCopyOnWritePage(vmTask->pageDir, i_faultAddr);
		if (error == NOERR) {
			updatePageDir(vmTask->pageDir);
		}
		else {
			WARNING(0);
			forceSendSignal(TaskGetTaskSignal(getCurrentTask()), SIGSEGV);
		}
		return;
	}

	// ڡ񤭹߰ȿ
	if (i_frame->error & PAGE_WRITE) {
		printk("\nRead only page violation! Fault Address = 0x%x\n", i_faultAddr);
		printContext(i_frame);
		forceSendSignal(TaskGetTaskSignal(getCurrentTask()), SIGSEGV);
		return;
	}
	
	// ڡȿ
	printk("\nUnknown page violation! Fault Address = 0x%x\n", i_faultAddr);
	printContext(i_frame);
	forceSendSignal(TaskGetTaskSignal(getCurrentTask()), SIGSEGV);
	return;
}

/*
 * 桼Хåեɥ쥹å
 * Ūϥͥ˲ʤ褦ˤ뤳Ȥȡͥ㳰ȯƥ꡼꡼򵯤Τɤȡ
 * return : NOERR or ERR
 */
int checkMem(
	const void *i_virtAddr,		// ꡼ɥ쥹
	uint i_bytes)				// Хåե
{
	uint addr = (uint) i_virtAddr;

	return isCorrectAccess(addr, addr + i_bytes);
}

//--------------------------------------------------------------------------------------------------
// 桼ϥɥ饹å
//--------------------------------------------------------------------------------------------------

/*
 * ⥸塼ڡǥ쥯ȥꥨȥ꡼¤
 */
typedef struct {
	uint entry[(DRIVER_END - DRIVER_BEG) / PAGE_DIR_SIZE];
} ModuleDirEnt;

/*
 * ⥸塼ڡǥ쥯ȥ򥳥ԡ
 *ճ߶ػߤǸƤФ뤳
 * return : Page directory
 */
uint *vmSetModule(
	VmTaskObj *i_module)	// ɥ饤Сۥ꡼
{
	VmTask *this = (VmTask*) getVmTask(getCurrentTask());
	VmTask *src = (VmTask*) i_module;

	ASSERT(this->saveIndex < IRQ_ENTRY);

	// ƥȤ¸ꤹ
	this->savePageDir[this->saveIndex] = this->pageDir;
	this->saveVmProc[this->saveIndex] = this->vmProc;
	++this->saveIndex;
	this->pageDir = src->pageDir;
	this->vmProc = src->vmProc;

	return this->pageDir;
}

/*
 * ⥸塼ڡǥ쥯ȥ᤹
 *ճ߶ػߤǸƤФ뤳
 * return : Page directory
 */
uint *vmResetModule()
{
	VmTask *this = (VmTask*) getVmTask(getCurrentTask());

	ASSERT(0 < this->saveIndex);

	// ƥȤ᤹
	--this->saveIndex;
	this->pageDir = this->savePageDir[this->saveIndex];
	this->vmProc = this->saveVmProc[this->saveIndex];

	return this->pageDir;
}

/*
 * ʥϥɥѥͥ륹åƤ
 * return : error number
 */
int vmCreatSignalHandlerStack(
	VmTaskObj *m_vmTask)
{
	VmTask *vmTask = (VmTask*) m_vmTask;
	return allocUserHandlerStack(vmTask);
}

/*
 * ʥϥɥѥͥ륹åѤ
 *ճ߶ػߤǸƤӽФ뤳
 * return : Page directory
 */
void *vmChangeSignalHandlerStack()
{
	VmTask *vmTask = (VmTask*) getVmTask(getCurrentTask());
	uint *pageDir  = vmTask->pageDir;
	uint *kernStackEnt = getPageEntryAddr(KERNEL_ESP_BEG, pageDir);
	uint *userStackEnt = getPageEntryAddr(USER_ESP_BEG - sizeof(int), pageDir);
	void *kernPhysMem = getPhysMemFromEntry(*kernStackEnt);
	void *userPhysMem = getPhysMemFromEntry(*userStackEnt);

	ASSERT(vmTask->kernStack != NULL);

	// åڡȥ꡼꡼촹
	setPhysMemEntry(kernStackEnt, vmTask->kernStack);
	setPhysMemEntry(userStackEnt, vmTask->userStack);
	vmTask->kernStack = kernPhysMem;
	vmTask->userStack = userPhysMem;

	return pageDir;
}

/*
 * ʥϥɥѥͥ륹åѤ
 *ճ߶ػߤǸƤӽФ뤳
 * return : Page directory
 */
void *vmChangeKernelStack()
{
	VmTask *this = (VmTask*) getVmTask(getCurrentTask());
	uint *entry = getPageEntryAddr(KERNEL_ESP_BEG, this->pageDir);
	void *physMem = getPhysMemFromEntry(*entry);

	ASSERT(this->kernStack != NULL);

	// åڡȥ꡼꡼촹
	setPhysMemEntry(entry, this->kernStack);
	this->kernStack = physMem;

	return this->pageDir;
}

/*
 * ⥸塼륫ͥ륹å򥳥ԡƥåȤ
 */
void vmSetModuleKernelStack(
	VmTaskObj *i_this)
{
	VmTask *this = (VmTask*) i_this;
	uint *entry = getPageEntryAddr(KERNEL_ESP_BEG, this->pageDir);
	void *physMem = getPhysMemFromEntry(*entry);

	ASSERT(this->kernStack != NULL);

	memcpy(this->kernStack, physMem, PAGE_SIZE);

	// åڡȥ꡼꡼촹
	setPhysMemEntry(entry, this->kernStack);
	this->kernStack = physMem;
}

/*
 * ⥸塼륫ͥ륹å᤹
 */
void vmResetModuleKernelStack(
	VmTaskObj *i_this)
{
	VmTask *this = (VmTask*) i_this;
	uint *entry = getPageEntryAddr(KERNEL_ESP_BEG, this->pageDir);
	void *physMem = getPhysMemFromEntry(*entry);

	ASSERT(this->kernStack != NULL);

	// åڡȥ꡼꡼촹
	setPhysMemEntry(entry, this->kernStack);
	this->kernStack = physMem;
}

/*
 * ⥸塼᥽åɥѥ᡼ꤹ
 * return : ESP
 */
uint vmSetModuleParam(
	VmTaskObj *i_this,
	void *returnMethod,
	uint param1,
	uint param2,
	uint param3,
	uint param4,
	uint param5,
	uint param6)
{
	VmTask *this = (VmTask*) i_this;
	uint *stackEnt = getPageEntryAddr(DRIVER_ESP_BEG - 1, this->pageDir);
	uint *stack = getPhysMemFromEntry(*stackEnt);
	
	stack[PAGE_SIZE / sizeof(uint) - 7] = (uint) returnMethod;
	stack[PAGE_SIZE / sizeof(uint) - 6] = param1;
	stack[PAGE_SIZE / sizeof(uint) - 5] = param2;
	stack[PAGE_SIZE / sizeof(uint) - 4] = param3;
	stack[PAGE_SIZE / sizeof(uint) - 3] = param4;
	stack[PAGE_SIZE / sizeof(uint) - 2] = param5;
	stack[PAGE_SIZE / sizeof(uint) - 1] = param6;
	
	return DRIVER_ESP_BEG - sizeof(uint) * 7;
}

//--------------------------------------------------------------------------------------------------
// Getter
//--------------------------------------------------------------------------------------------------

/*
 * ڡǥ쥯ȥꥢɥ쥹
 * return : ڡǥ쥯ȥꥢɥ쥹
 */
uint *getPageDir(
	VmTaskObj *i_vmTask)
{
	VmTask *vmTask = (VmTask*) i_vmTask;
	return vmTask->pageDir;
}

/*
 * Ƥɥ쥹κǸ
 * return : last allocate addrress
 */
uint getLastLinearAddr()
{
	return ((VmProc*) getVmProc(getCurrentProc()))->lastAddr;
}

/*
 * ʥϥɥѥͥ륹å
 * return : ͥ륹å
 */
void *getUserHandlerStack(
	VmTaskObj *i_this)
{
	VmTask *this = (VmTask*) i_this;
	return this->kernStack;
}

/*
 * 桼ΰ衦ͥ륹åɥ쥹ʪɥ쥹
 * return : ʪɥ쥹 or 0
 */
uint getPhysicalFromLogicalAddr(
	VmTaskObj *i_vmTask,
	const uint logicalAddr)
{
	uint *pageTbl = getPhysMemFromEntry(((VmTask*) i_vmTask)->pageDir[logicalAddr / PAGE_DIR_SIZE]);
	
	if (pageTbl != NULL) {
		uint pageEnt = pageTbl[(logicalAddr % PAGE_DIR_SIZE) / PAGE_SIZE];

		return (uint) getPhysMemFromEntry(pageEnt) + (logicalAddr & (PAGE_SIZE - 1));
	}
	else {
		return 0;
	}
}

//--------------------------------------------------------------------------------------------------
// ƥॳ
//--------------------------------------------------------------------------------------------------

/*
 * 桼ڡΥɥ쥹ޤǳƤ롣
 */
int sys_brk(uint addr)
{
	VmTask *vmTask = (VmTask*) getVmTask(getCurrentTask());
	VmProc *vmProc = vmTask->vmProc;

	enter_spinlock(&vmProc->spinLock);
	{
		if ((vmProc->lastAddr <= addr) && (addr < vmProc->firstStackAddr)) {
			vmProc->lastAddr = ROUNDUP(addr, PAGE_SIZE);
		}
	}
	exit_spinlock(&vmProc->spinLock);

	return 0;
}

//**************************************************************************************************

#ifdef DEBUG
void test_mm(
	const char *str)
{
	if (getCurrentProc() == (void*) 0x201000) {
		printk("%s %x\n", str, *(uint*) 0x40009020);
	}
}
#endif
