/*
 * AggregateList.c
 *
 * Copyright 2007, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 *Գס
 * IteratorѥListIteratorꥹ
 *
 *
 * Ǥ¾ϸƤӽФ¦ǤԤȡ
 */


#include <sys/config.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/object.h>
#include <sys/IteratorList.h>
#include <sys/AggregateList.h>

#include <kern/debug.h>


//#define DEBUG_AGGREGATE_LIST 1
#ifdef DEBUG_AGGREGATE_LIST
	#define STATIC
	#define INLINE
#else
	#define STATIC	static
	#define INLINE	inline
#endif


//================================== PRIVATE ============================================

/*
 * ³Ǥμ³
 */
STATIC INLINE void addNext(
	List *dst,
	List *src)
{
	src->next = dst->next;
	src->prev = dst;
	dst->next = src;
	if (src->next != NULL) {
		src->next->prev = src;
	}
}

/*
 * ³Ǥ³
 */
STATIC INLINE void addPrev(
	List *dst,		// ³ꥹȥСݥ
	List *src)		// ³ꥹȥСݥ
{
	src->next = dst;
	src->prev = dst->prev;
	dst->prev = src;
	if (src->prev != NULL) {
		src->prev->next = src;
	}
}

/*
 * ꥹȤ
 */
STATIC INLINE void erase(
	List *src)
{
	if (src->prev != NULL) {
		src->prev->next = src->next;
	}
	if (src->next != NULL) {
		src->next->prev = src->prev;
	}
	src->next =  NULL;
	src->prev = NULL;
}

//================================== PUBLIC =============================================

/*
 * ꥹȥإå³
 *³ꥹȥȥ꡼ϽƤ뤳
 */
STATIC void insertHead(
	AggregateList *this,
	List *m_list)
{
	ASSERT((m_list->next == NULL) && (m_list->prev == NULL));

	if (this->head == NULL) {
		this->head = m_list;
		this->end = m_list;
	}
	else {
		addPrev(this->head, m_list);
		this->head = m_list;
	}
	this->count += 1;
}

/*
 * ꥹȥɤ³
 *³ꥹȥȥ꡼ϽƤ뤳
 */
STATIC void insertEnd(
	AggregateList *this,
	List *m_list)
{
	ASSERT((m_list->next == NULL) && (m_list->prev == NULL));

	if (this->end == NULL) {
		this->head = m_list;
		this->end = m_list;
	}
	else {
		addNext(this->end, m_list);
		this->end = m_list;
	}
	this->count += 1;
}

/*
 * ꥹȥȥ꡼μ³
 */
STATIC void insertNext(
	AggregateList *this,
	List *m_dst,				// ³ȥ꡼
	List *m_src)
{
	// ³ꥹȥȥ꡼ϽƤ뤳
	ASSERT((m_src->next == NULL) && (m_src->prev == NULL));

	addNext(m_dst, m_src);
	if (this->end == m_dst) {
		this->end = m_src;
	}
	this->count += 1;
}

/*
 * ꥹȥȥ꡼³
 */
STATIC void insertPrev(
	AggregateList *this,
	List *m_dst,				// ³ȥ꡼
	List *m_src)
{
	// ³ꥹȥȥ꡼ϽƤ뤳
	ASSERT((m_src->next == NULL) && (m_src->prev == NULL));

	addPrev(m_dst, m_src);
	if (this->head == m_dst) {
		this->head = m_src;
	}
	this->count += 1;
}

/*
 * ꥹȥȥ꡼
 */
STATIC void removeEntry(
	AggregateList *this,
	List *m_list)
{
	// ȥ꡼³Ƥ뤳
	ASSERT(m_list != NULL);

	if (this->head == m_list) {
		if (this->end == m_list) {
			this->head = NULL;
			this->end = NULL;
		}
		else {
			this->head = m_list->next;
			erase(m_list);
		}
	}
	else if (this->end == m_list) {
		this->end = m_list->prev;
		erase(m_list);
	}
	else {
		erase(m_list);
	}
	this->count -= 1;
}

/*
 * إåɥȥ꡼Ф
 * return : ȥ꡼ν°֥ or NULL
 */
STATIC OBJECT *getHead(
	AggregateList *this)
{
	if (this->head != NULL) {
		List *headEntry = this->head;
		removeEntry(this, headEntry);
		this->count -= 1;

		return headEntry->object;
	}
	else {
		return NULL;
	}
}

/*
 * ɥȥ꡼Ф
 * return : ȥ꡼ν°֥ or NULL
 */
STATIC OBJECT *getEnd(
	AggregateList *this)
{
	if (this->end != NULL) {
		List *endEntry = this->end;
		removeEntry(this, endEntry);
		this->count -= 1;

		return endEntry->object;
	}
	else {
		return NULL;
	}
}

/*
 * Υȥ꡼Ф
 * return : ȥ꡼ν°֥ or NULL
 */
/*STATIC OBJECT *getNext(
	AggregateList *this,
	List *m_dst)
{
	List *nextEntry;

	// ȥ꡼³Ƥ뤳
	ASSERT(m_dst != NULL);
	ASSERT((m_dst->next != NULL) && (m_dst->prev != NULL));

	nextEntry = m_dst->next;
	if (nextEntry != NULL) {
		removeEntry(this, nextEntry);
		return nextEntry->object;
	}
	else {
		return NULL;
	}
}
*/
/*
 * Υȥ꡼Ф
 * return : ȥ꡼ν°֥ or NULL
 */
/*STATIC OBJECT *getPrev(
	AggregateList *this,
	List *m_dst)
{
	List *prevEntry;

	// ȥ꡼³Ƥ뤳
	ASSERT(m_dst != NULL);
	ASSERT((m_dst->next != NULL) && (m_dst->prev != NULL));

	prevEntry = m_dst->prev;
	if (prevEntry != NULL) {
		removeEntry(this, prevEntry);
		return prevEntry->object;
	}
	else {
		return NULL;
	}
}
*/
/*
 * إåɥȥ꡼򻲾
 * return : ȥ꡼ν°֥ or NULL
 */
STATIC OBJECT *refHead(
	AggregateList *this)
{
	if (this->head != NULL) {
		return this->head->object;
	}
	else {
		return NULL;
	}
}

/*
 * ɥȥ꡼򻲾Ȥ
 * return : ȥ꡼ν°֥ or NULL
 */
STATIC OBJECT *refEnd(
	AggregateList *this)
{
	if (this->end != NULL) {
		return this->end->object;
	}
	else {
		return NULL;
	}
}

/*
 * Υȥ꡼򻲾Ȥ
 * return : ȥ꡼ν°֥ or NULL
 */
STATIC OBJECT *refNext(
	AggregateList *this,
	const List *i_dst)
{
	ASSERT(i_dst != NULL);

	if (i_dst->next != NULL) {
		return i_dst->next->object;
	}
	else {
		return NULL;
	}
}

/*
 * Υȥ꡼򻲾Ȥ
 * return : ȥ꡼ν°֥ or NULL
 */
STATIC OBJECT *refPrev(
	AggregateList *this,
	const List *i_dst)
{
	ASSERT(i_dst != NULL);

	if (i_dst->prev != NULL) {
		return i_dst->prev->object;
	}
	else {
		return NULL;
	}
}

//---------------------------- ƥ졼 ------------------------------------

STATIC void iterator(
	AggregateList *this,
	IteratorList *m_iterat)
{
	IteratorListConstruct(m_iterat, this);
}

STATIC void iteratorReverce(
	AggregateList *this,
	IteratorList *m_iterat)
{
	IteratorListReverceConstruct(m_iterat, this);
}

/*
 * إåɥꥹȥȥ꡼򻲾
 * return : ꥹȥȥ꡼ or NULL
 */
STATIC List *refHeadEntry(
	AggregateList *this)
{
	return this->head;
}

/*
 * ɥꥹȥȥ꡼򻲾
 * return : ꥹȥȥ꡼ or NULL
 */
STATIC List *refEndEntry(
	AggregateList *this)
{
	return this->end;
}

/*
 * Υꥹȥȥ꡼򻲾
 * return : ꥹȥȥ꡼ or NULL
 */
STATIC List *refNextEntry(
	AggregateList *this,
	const List *i_dst)
{
	ASSERT(i_dst != NULL);

	return i_dst->next;
}

/*
 * Υꥹȥȥ꡼򻲾
 * return : ꥹȥȥ꡼ or NULL
 */
STATIC List *refPrevEntry(
	AggregateList *this,
	const List *i_dst)
{
	ASSERT(i_dst != NULL);

	return i_dst->prev;
}

/*
 * ꥹ³򻲾
 * return : 
 */
STATIC int getCount(
	AggregateList *this)
{
	return this->count;
}

/*
 * ̤б
 */
STATIC void dummyFunc()
{
	printk("This operation not supported!\n");
	ASSERT(0);
}

//---------------------------- 󥹥ȥ饯 ------------------------------------

void AggregateListConstructor(
	AggregateList *this)
{
	// 
	this->head = NULL;
	this->end = NULL;
	this->count = 0;
	this->insertHead = insertHead;
	this->insertEnd = insertEnd;
	this->insertNext = insertNext;
	this->insertPrev = insertPrev;
	this->removeEntry = removeEntry;
	this->getHead = getHead;
	this->getEnd = getEnd;
//	this->getNext = getNext;
//	this->getPrev = getPrev;
	this->refHead = refHead;
	this->refEnd = refEnd;
	this->refNext = refNext;
	this->refPrev = refPrev;
	this->pointHeadNext = (LIST_FUNC7) dummyFunc;
	this->removeOut = (LIST_FUNC8) dummyFunc;
	this->iterator = iterator;
	this->iteratorReverce = iteratorReverce;
	this->refHeadList = refHeadEntry;
	this->refEndList = refEndEntry;
	this->refNextList = refNextEntry;
	this->refPrevList = refPrevEntry;
	this->getCount = getCount;
}
