/*
 * IteratorList.c
 *
 * Copyright 2007, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 *Գס
 * IteratorѥIterator
 *
 *
 * ¾ϸƤӽФ¦ǤԤȡ
 */


#include <sys/config.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/AggregateList.h>
#include <sys/IteratorList.h>

#include <kern/debug.h>


//#define DEBUG_ITERATORLIST 1
#ifdef DEBUG_ITERATORLIST
	#define STATIC
	#define INLINE
#else
	#define STATIC	static
	#define INLINE	inline
#endif


//================================== PUBLIC =============================================

STATIC BOOL hasNext(
	IteratorList *this)
{
	return (this->nextEntry != NULL) ? BOOL_TRUE : BOOL_FALSE;
}

STATIC OBJECT* next(
	IteratorList *this)
{
	AggregateList *aggregate = this->aggregate;
	List *entry = this->nextEntry;
	
	// Υȥ꡼̵Τ˸ƤӽФΤԲ
	ASSERT(this->nextEntry != NULL);
	
	this->nextEntry = aggregate->refNextList(aggregate, entry);
	
	return entry->object;
}

STATIC OBJECT* prev(
	IteratorList *this)
{
	AggregateList *aggregate = this->aggregate;
	List *entry = this->nextEntry;
	
	// Υȥ꡼̵Τ˸ƤӽФΤԲ
	ASSERT(this->nextEntry != NULL);
	
	this->nextEntry = aggregate->refPrevList(aggregate, entry);
	
	return entry->object;
}

//---------------------------- 󥹥ȥ饯 ------------------------------------

/*
 * 縡
 */
void IteratorListConstruct(
	IteratorList *this,
	void *aggregate)
{
	// 
	this->aggregate = aggregate;
	this->nextEntry = ((AggregateList*) aggregate)->refHeadList(aggregate);
	this->hasNext = hasNext;
	this->next = next;
}

/*
 * ս縡
 */
void IteratorListReverceConstruct(
	IteratorList *this,
	void *aggregate)
{
	// 
	this->aggregate = aggregate;
	this->nextEntry = ((AggregateList*) aggregate)->refEndList(aggregate);
	this->hasNext = hasNext;
	this->next = prev;
}
