/*
 * bitmap.c
 *
 * Copyright 2007, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 *Գס
 * ӥåȥޥåѴؿ
 *
 */


#include <sys/config.h>
#include <sys/types.h>
#include <sys/param.h>
#include <lib/bitmap.h>

#include <kern/debug.h>


//#define DEBUG_BITMAP 1
#ifdef DEBUG_BITMAP
	#define STATIC
	#define INLINE
#else
	#define STATIC	static
	#define INLINE	inline
#endif


//==================================  ===========================================

//================================== PRIVATE ============================================

typedef struct {
	uchar low;		// Хǲ̥ӥåȰ
	uchar count;	// Хǲ̤Ϣ³Ƥӥåȿ
	uchar High;		// ХǾ̥ӥåȰ
} BYTE_BIT;

static const BYTE_BIT byteBit[] = {
	{0,0,0},{0,1,1},{1,1,2},{0,2,2},{2,1,3},{0,1,3},{1,2,3},{0,3,3},{3,1,4},{0,1,4},{1,1,4},{0,2,4},{2,2,4},{0,1,4},{1,3,4},{0,4,4},
	{4,1,5},{0,1,5},{1,1,5},{0,2,5},{2,1,5},{0,1,5},{1,2,5},{0,3,5},{3,2,5},{0,1,5},{1,1,5},{0,2,5},{2,3,5},{0,1,5},{1,4,5},{0,5,5},
	{5,1,6},{0,1,6},{1,1,6},{0,2,6},{2,1,6},{0,1,6},{1,2,6},{0,3,6},{3,1,6},{0,1,6},{1,1,6},{0,2,6},{2,2,6},{0,1,6},{1,3,6},{0,4,6},
	{4,2,6},{0,1,6},{1,1,6},{0,2,6},{2,1,6},{0,1,6},{1,2,6},{0,3,6},{3,3,6},{0,1,6},{1,1,6},{0,2,6},{2,4,6},{0,1,6},{1,5,6},{0,6,6},
	{6,1,7},{0,1,7},{1,1,7},{0,2,7},{2,1,7},{0,1,7},{1,2,7},{0,3,7},{3,1,7},{0,1,7},{1,1,7},{0,2,7},{2,2,7},{0,1,7},{1,3,7},{0,4,7},
	{4,1,7},{0,1,7},{1,1,7},{0,2,7},{2,1,7},{0,1,7},{1,2,7},{0,3,7},{3,2,7},{0,1,7},{1,1,7},{0,2,7},{2,3,7},{0,1,7},{1,4,7},{0,5,7},
	{5,2,7},{0,1,7},{1,1,7},{0,2,7},{2,1,7},{0,1,7},{1,2,7},{0,3,7},{3,1,7},{0,1,7},{1,1,7},{0,2,7},{2,2,7},{0,1,7},{1,3,7},{0,4,7},
	{4,3,7},{0,1,7},{1,1,7},{0,2,7},{2,1,7},{0,1,7},{1,2,7},{0,3,7},{3,4,7},{0,1,7},{1,1,7},{0,2,7},{2,5,7},{0,1,7},{1,6,7},{0,7,7},
	{7,1,8},{0,1,8},{1,1,8},{0,2,8},{2,1,8},{0,1,8},{1,2,8},{0,3,8},{3,1,8},{0,1,8},{1,1,8},{0,2,8},{2,2,8},{0,1,8},{1,3,8},{0,4,8},
	{4,1,8},{0,1,8},{1,1,8},{0,2,8},{2,1,8},{0,1,8},{1,2,8},{0,3,8},{3,2,8},{0,1,8},{1,1,8},{0,2,8},{2,3,8},{0,1,8},{1,4,8},{0,5,8},
	{5,1,8},{0,1,8},{1,1,8},{0,2,8},{2,1,8},{0,1,8},{1,2,8},{0,3,8},{3,1,8},{0,1,8},{1,1,8},{0,2,8},{2,2,8},{0,1,8},{1,3,8},{0,4,8},
	{4,2,8},{0,1,8},{1,1,8},{0,2,8},{2,1,8},{0,1,8},{1,2,8},{0,3,8},{3,3,8},{0,1,8},{1,1,8},{0,2,8},{2,4,8},{0,1,8},{1,5,8},{0,6,8},
	{6,2,8},{0,1,8},{1,1,8},{0,2,8},{2,1,8},{0,1,8},{1,2,8},{0,3,8},{3,1,8},{0,1,8},{1,1,8},{0,2,8},{2,2,8},{0,1,8},{1,3,8},{0,4,8},
	{4,1,8},{0,1,8},{1,1,8},{0,2,8},{2,1,8},{0,1,8},{1,2,8},{0,3,8},{3,2,8},{0,1,8},{1,1,8},{0,2,8},{2,3,8},{0,1,8},{1,4,8},{0,5,8},
	{5,3,8},{0,1,8},{1,1,8},{0,2,8},{2,1,8},{0,1,8},{1,2,8},{0,3,8},{3,1,8},{0,1,8},{1,1,8},{0,2,8},{2,2,8},{0,1,8},{1,3,8},{0,4,8},
	{4,4,8},{0,1,8},{1,1,8},{0,2,8},{2,1,8},{0,1,8},{1,2,8},{0,3,8},{3,5,8},{0,1,8},{1,1,8},{0,2,8},{2,6,8},{0,1,8},{1,7,8},{0,8,8}
};

static const u_int8_t bit[] = {0x1, 0x2, 0x4, 0x8, 0x10, 0x20, 0x40, 0x80};

//================================== PUBLIC ==============================================

/*
 * ӥåȰ֤
 * reutrn : ǲ̥ӥåȰ or ERR
 */
int getBitmapPos(
	const int i_start,		// ȥӥåȰ֡ʣ
	const int i_allNum,		// ӥåȥޥåӥåȿ
	const u_int8_t *i_bitmap)
{
	int startByte;
	int lastByte;
	int byte;

	ASSERT(i_start <= INT_MAX);
	ASSERT(i_allNum <= INT_MAX);
	ASSERT(i_start < i_allNum);
	
	// ΤХȤ򸡺
	lastByte = ROUNDUP_DIV(i_allNum, BYTE_BITNUM);
	startByte = i_start / BYTE_BITNUM;
	byte = startByte;
	for (;;) {
		if (i_bitmap[byte] != 0) {
			if ((byte * BYTE_BITNUM + byteBit[(u_int8_t) i_bitmap[byte]].low) < i_allNum) {
				// ȯ
				break;
			}
		}

		++byte;
		if (lastByte <= byte) {
			byte = 0;
		}
		if (byte == startByte) {
			// ̵
			return ERR;
		}
	}
	
	return byte * BYTE_BITNUM + byteBit[(u_int8_t) i_bitmap[byte]].low;
}

/*
 * ӥåȰ֤
 * reutrn : ǲ̶ӥåȰ or ERR
 */
int getBitmapEmptyPos(
	const int i_start,		// ȥӥåȰ֡ʣ
	const int i_allNum,		// ӥåȥޥåӥåȿ
	const u_int8_t *i_bitmap)
{
	int startByte;
	int lastByte;
	int byte;

	ASSERT(i_start <= INT_MAX);
	ASSERT(i_allNum <= INT_MAX);
	ASSERT(i_start < i_allNum);
	
	// ΤХȤ򸡺
	lastByte = ROUNDUP_DIV(i_allNum, BYTE_BITNUM);
	startByte = i_start / BYTE_BITNUM;
	byte = startByte;
	for (;;) {
		if (i_bitmap[byte] != 0xff) {
			if ((byte * BYTE_BITNUM + byteBit[(u_int8_t) ~i_bitmap[byte]].low) < i_allNum) {
				// ȯ
				break;
			}
		}

		++byte;
		if (lastByte <= byte) {
			byte = 0;
		}
		if (byte == startByte) {
			// ̵
			return ERR;
		}
	}
	
	return byte * BYTE_BITNUM + byteBit[(u_int8_t) ~i_bitmap[byte]].low;
}

/*
 * ӥåȥޥåפγ֥ӥåȤ򥻥åȤ
 */
void setBitmapBit(
	const int i_num,	// ӥåȰ֡ʣ
	u_int8_t *m_bitmap)
{
	ASSERT((m_bitmap[i_num / BYTE_BITNUM] & bit[i_num % BYTE_BITNUM]) == 0);

	m_bitmap[i_num / BYTE_BITNUM] |= bit[i_num % BYTE_BITNUM];
}

/*
 * ӥåȥޥåפγ֥ӥåȤꥻåȤ
 */
void resetBitmapBit(
	const int i_num,	// ӥåȰ֡ʣ
	u_int8_t *m_bitmap)
{
//	ASSERT((m_bitmap[i_num / BYTE_BITNUM] & bit[i_num % BYTE_BITNUM]) != 0);

	m_bitmap[i_num / BYTE_BITNUM] &= ~bit[i_num % BYTE_BITNUM];
}
