/*
 * interrupt.c
 *
 * Copyright 2008, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 *Գס
 *
 *
 *
 *ԸƤ
 */


#include <sys/config.h>
#include <sys/types.h>
#include <sys/param.h>
#include <machine/interrupt.h>
#include <machine/vm.h>
#include <kern/Thread.h>

#include <kern/debug.h>


//#define DEBUG_INTERRUPT 1
#ifdef DEBUG_INTERRUPT
	#define STATIC
	#define INLINE
#else
	#define STATIC	static
	#define INLINE	inline
#endif


//=====================================  ===================================================

/*
 * ߥǥץ
 */
typedef struct {
	ThreadObj	*task;			// ɥ饤С
	inthand2_t	*handler;		// ߥϥɥ
	void		*arg;			// ߥϥɥѥ᡼
	void		*returnMethod;	// ߥϥɥ꥿᥽å
} IntrDescriptor;

//===================================== Х륤ݡ =======================================

//===================================== PRIVATE ====================================================

static IntrDescriptor intrDescriptor[IRQ_ENTRY];

void IntrDscConstructor(
	IntrDescriptor *this,
	inthand2_t *i_handler,
	void *i_arg,
	void *i_returnMethod)
{
	this->task = getCurrentTask();
	this->handler = i_handler;
	this->arg = i_arg;
	this->returnMethod = i_returnMethod;
}

void IntrDscDestructor(
	IntrDescriptor *this)
{
	// ⤷ʤ
}

//===================================== PUBLIC =====================================================

//--------------------------------------------------------------------------------------------------
// Getter
//--------------------------------------------------------------------------------------------------

ThreadObj *IntrDscGetTask(
	const int i_irq)
{
	return intrDescriptor[i_irq].task;
}

inthand2_t *IntrDscGetHandler(
	const int i_irq)
{
	return intrDescriptor[i_irq].handler;
}

void *IntrDscGetArg(
	const int i_irq)
{
	return intrDescriptor[i_irq].arg;
}

void *IntrDscGetReturnMethod(
	const int i_irq)
{
	return intrDescriptor[i_irq].returnMethod;
}

//--------------------------------------------------------------------------------------------------
// Setter
//--------------------------------------------------------------------------------------------------

//--------------------------------------------------------------------------------------------------
// Yes or No
//--------------------------------------------------------------------------------------------------

//--------------------------------------------------------------------------------------------------
// Search
//--------------------------------------------------------------------------------------------------

/*
 * 桼ߥϥɥϿ
 * return : error number
 */
int sysInthandAdd(
	const uint i_irq,			// Interrupt line
	inthand2_t i_handler,		// Function to be called when the IRQ occurs
	void *i_arg,				// A cookie passed back to the handler function
	const int flags,			// Interrupt type flags
	void *i_returnMethod)		// Intr handler return method
{
	if (IRQ_ENTRY <= i_irq) {
		return -EINVAL;
	}
	
	IntrDscConstructor(&intrDescriptor[i_irq], i_handler, i_arg, i_returnMethod);
	setUserIntrHandler(i_irq);
	release_irq_mask(i_irq);

	return NOERR;
}

/*
 * ߥϥɥϿ
 * return : error number
 */
int sysInthandRemove(
	const uint i_irq)		// free an interrupt
{
	if (IRQ_ENTRY <= i_irq) {
		return -EINVAL;
	}
	
	// ϥɥ饿γǧ
	if (IntrDscGetTask(i_irq) != getCurrentTask()) {
		return -ENODEV;
	}

	IntrDscDestructor(&intrDescriptor[i_irq]);
	setKernIntrHandler(i_irq);
	
	return NOERR;
}

//*****************************************************************************************************************

#ifdef DEBUG
#include <machine/interrupt.h>
int testInterrupt()
{
	testEntry(81, IRQ18);
	testEntry(82, IRQ19);
	return 0;
}
#endif
