/*
 * sendBuf.c
 *
 * Copyright 2007, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 *ԳסХåեХåեκǽȺǸ夬Сåפʤ
 *
 *
 *
 *ԸƤ
 */


#include <sys/config.h>
#include <sys/types.h>
#include <sys/param.h>
#include <kern/kmalloc.h>
#include <net/sendBuf.h>

#include <kern/debug.h>


//#define DEBUG_SENDBUF 1
#ifdef DEBUG_SENDBUF
	#define STATIC
	#define INLINE
#else
	#define STATIC	static
	#define INLINE	inline
#endif


//==================================  ===========================================

//================================== Х륤ݡ ===============================

//================================== PRIVATE ============================================

enum{
	RING_BUF_SIZE_MAX = 0x10000,	// Хåե祵
};

//================================== PUBLIC =============================================

/*
 * 󥰥ХåեγȽ
 * return : error number
 */
int allocSendBuf(
	const u_int32_t startSeq,	// ȥֹ
	SEND_BUF *m_sendBuf)
{
	// 祵ǳڤ祵Ƥ
	size_t allSize = RING_BUF_SIZE_MAX;

	m_sendBuf->buf = kmalloc(allSize);
	if (m_sendBuf->buf == NULL){
		return -ENOMEM;
	}
	m_sendBuf->allSize = allSize;
	m_sendBuf->startSeq = startSeq;
	m_sendBuf->lastSeq = startSeq;

	return NOERR;
}

/*
 * 󥰥Хåե
 */
void freeSendBuf(
	SEND_BUF *m_sendBuf)
{
	kfree(m_sendBuf->buf);
}

/*
 * ǡ񤭹
 */
void writeSendBuf(
	const size_t len,				// ߥ
	const char *from,				// ߸ǡ
	SEND_BUF *m_sendBuf)
{
	uint startOff = (m_sendBuf->lastSeq - m_sendBuf->startSeq) % m_sendBuf->allSize;
	
	if (startOff + len <= m_sendBuf->allSize) {
		memcpy(m_sendBuf->buf + startOff, from, len);
	}
	else {
		size_t overrapLen = m_sendBuf->allSize - startOff;
		memcpy(m_sendBuf->buf + startOff, from, overrapLen);
		memcpy(m_sendBuf->buf, from + overrapLen, len - overrapLen);
	}
	
	m_sendBuf->lastSeq += len;
}

/*
 * ֹ椫ϥХåեݥ󥿤μ
 * return : pointer
 */
void *getSendBufPointer(
	const u_int32_t i_startSeq,		// ϥֹ
	const SEND_BUF *i_sendBuf)
{
	uint startOff = (i_startSeq - i_sendBuf->startSeq) % i_sendBuf->allSize;
	
	ASSERT(i_sendBuf->lastSeq - i_startSeq <= i_sendBuf->allSize);
	ASSERT(i_startSeq <= i_sendBuf->lastSeq);
	
	return i_sendBuf->buf + startOff;
}

/*
 * ֹ椫̤μ
 * return : ̤
 */
int getSendBufSaveSize(
	const u_int32_t i_startSeq,		// ϥֹ
	const SEND_BUF *i_sendBuf)
{
	WARNING((int) (i_sendBuf->lastSeq - i_startSeq) <= (int) i_sendBuf->allSize);

	return i_sendBuf->lastSeq - i_startSeq;
}

/*
 * ֹ椫ǽμ
 * return : ǽ
 */
size_t getSendBufSendSize(
	const u_int32_t i_startSeq,		// ϥֹ
	const SEND_BUF *i_sendBuf)
{
	uint startOff = (i_startSeq - i_sendBuf->startSeq) % i_sendBuf->allSize;
	uint lastOff = (i_sendBuf->lastSeq - i_sendBuf->startSeq) % i_sendBuf->allSize;
	
	ASSERT(i_sendBuf->lastSeq - i_startSeq <= i_sendBuf->allSize);
	ASSERT(i_startSeq <= i_sendBuf->lastSeq);
	
	if (startOff < lastOff) {
		return lastOff - startOff;
	}
	else {
		return i_sendBuf->allSize - startOff;
	}
}

/*
 * ֹ椫Υֲǽμ
 * return : ֲǽ
 */
size_t getSendBufSpaceSize(
	const u_int32_t i_startSeq,		// ϥֹ
	const SEND_BUF *i_sendBuf)
{
	size_t space = i_sendBuf->allSize - (i_sendBuf->lastSeq - i_startSeq);

	ASSERT(i_startSeq <= i_sendBuf->lastSeq);
	ASSERT(i_sendBuf->lastSeq - i_startSeq <= i_sendBuf->allSize);

	return space;
}
