/*
 * arp.h
 *
 * Copyright 2004, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#ifndef arp_h
#define arp_h


#include<sys/types.h>


#ifndef ASM_FILE


typedef struct{
	ushort		hardType;
	ushort		protType;
	uchar		hardAddrLen;
	uchar		protAddrLen;
	ushort		opeCode;
	uchar		srcMac[6];
	uint32_t	srcIp __attribute__((packed));
	uchar		dstMac[6];
	uint32_t	dstIp __attribute__((packed));
}ARP_HEADER;


extern int getMac(const int, const uint32_t, char*);
extern int receiveArp(int, ARP_HEADER*);
extern void initArp();


#endif


#endif
