/*
 * setup2.c
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * ᥤץ
 */


#include <sys/types.h>
#include <sys/param.h>
#include <sys/module.h>
#include <sys/mbuf.h>
#include <machine/Except.h>
#include <machine/pc.h>
#include <machine/pcibus.h>
#include <machine/bios.h>
#include <machine/apm.h>
#include <machine/fpu.h>
#include <machine/tss.h>
#include <machine/Cpu.h>
#include <machine/lib.h>
#include <machine/UserHandler.h>
#include <machine/interrupt.h>
#include <dev/pci/pci.h>
#include <dev/ata/ata.h>
#include <dev/console/console.h>
#include <dev/MC146818.h>
#include <dev/8254.h>
#include <dev/serial.h>
#include <dev/miscdev.h>
#include <isa/isavar.h>
#include <net/ethernet.h>
#include <net/net.h>
#include <lib/lib.h>
#include <machine/sp.h>
#include <machine/mp.h>
#include <kern/physical_mem.h>
#include <kern/page_swap.h>
#include <kern/fs.h>
#include <kern/vfs.h>
#include <kern/Hierarchy.h>
#include <kern/proc.h>
#include <kern/ProcSignal.h>
#include <kern/Thread.h>
#include <kern/device.h>
#include <kern/devfs.h>
#include <kern/time.h>
#include <kern/timer.h>
#include <kern/ext2.h>
#include <kern/errno.h>
#include <kern/lock.h>
#include <kern/term.h>
#include <kern/syscall.h>
#include <kern/block_cache.h>
#include <module/Module.h>

#include <kern/debug.h>


//===================================== Х륤ݡ =======================================

extern void init_syscall();

//===================================== PUBLIC =====================================================

void main()
{
//*************************************************
	saveRealIdt();
//*************************************************

	/* 㳰ϥɥꤹ롣 */
	init_except();

	// 󥽡ν
	initConsole();

	/* TSSǥץɤ롣 */
	initTss(0);

	// 塼ν
	initSchedule(0);

	// CPUǽγǧ
	{
		Cpu cpu;

		if (CpuConstructor(&cpu) != NOERR) {
			PRINT_ERR("This cpu is not supported!");
		}
		if (cpu.isSupportCpu(&cpu) == NO) {
			PRINT_ERR("This cpu is not supported!");
		}
		if (cpu.isSupportSysenter(&cpu) == YES) {
			cpu.setSysenter(&cpu);
			changeUserCall();
		}
	}

	// PCν
	if (initPc() != NOERR){
		PRINT_ERR("init PC error!");
	}

	/* APMν */
	InitApm();

	/* fpuν */
	initFpu();

	/* ꡼ƥν */
	initPhysMem();

	// ޡν
	initTime();
	initTimer();

	// cpuåͤ¬
	printk("cpu0 clock = %d HZ\n", getCpuClock());

	if (VmInit() != NOERR) {
		PRINT_ERR("createIdleProc error!");
	}

	if (HierarchyInit() != NOERR) {
		PRINT_ERR("HierarchyInit error!");
	}

	if (ProcSignalInit() != NOERR) {
		PRINT_ERR("ProcSignalInit error!");
	}

	// ɥץʺǽΥץˤ
	if (createIdleProc(0) != NOERR){
		PRINT_ERR("createIdleProc error!");
	}

	// ߤSMP
	if (isMp() == YES) {
		if (init_mp() != NOERR){
			PRINT_ERR("init_mp() Failed!");
		}
	}
	else {
		if (init_sp() != NOERR){
			PRINT_ERR("init_sp() Failed!");
		}
	}

	// 󥿡Х륿ޡν
	initIntervalTimer();

	// ꥢ륯åޡν
	initRealTimer();
	
	/* Init system call. */
	init_syscall();
}

void init()
{
	int rest;
	int error;

	sti();

	// Initץ
	rest = sys_fork();
	if (rest < 0){
		PRINT_ERR("Process0 fork() error!");
	}
	else if (0 < rest) {
		// ɥ롼׳
		startIdle();
	}
	setInitProc();

	error = initDevice();
	if (error != NOERR) {
		PRINT_ERR("initDevice error!\n");
	}

	// BIOSطν
	bios32_init();

	// mbufν
	initMbuf();

	// ۥե륷ƥν
	initVfs();

	/* ǥХե륷ƥν */
	initDeviceFs();

	// ISAХν
	if (initIsa() != NOERR){
		printk("Failed initialize isa!\n");
	}

	// PCIХν
	// ȤꤢĤPCIɥ饤С롢FreeBSDΥɥ饤С줹
	initPci();
	if (initPciNew() != NOERR){
		printk("Failed initialize pci!\n");
	}

	/* init serial. */
	init_com();

	/* ֥ååν */
	initBlockCache();

	/* Set COM interrupt. */
	set_com_intr();

	// եåԡɥ饤СȤ߹
	{
		extern int fdc_isaInitDevice();
		extern int fd_fdcInitDevice();
		
		rest = fdc_isaInitDevice();
		if (rest < 0){
			printk("Failed initialize fdc driver!\n");
		}
		else{
			rest = fd_fdcInitDevice();
		}
		if (rest < 0){
			printk("Failed initialize fd driver!\n");
		}
	}

	/* Init ATA drive. */
	initAta();

	/* 󥽡ΥǥХϿ */
	if((rest=registConsole())<0){
		PRINT_ERR("registConsole error!");
	}

	/* NULLǥХϿ */
	if((rest=registNullDev())<0){
		PRINT_ERR("registNullDev error!");
	}

	/* EXT2ե륷ƥν */
	if((rest=initExt2tFs())<0){
		PRINT_ERR("initExt2tFs error!");
	}

	/* ڡѵΰν */
	if ((rest = initBackupDev(PAGING_BACKUP_DEVICE)) < 0){
		PRINT_ERR("initBackupDev error!");
	}
	printk("Page backup device : %s\n",PAGING_BACKUP_DEVICE);

	/* mount root filesystem. */
	if (sys_mount(ROOT_DEVICE, "ext2", "/") != NOERR) {
		PRINT_ERR("sys_mount() error!");
	}
	printk("Root device : %s\nRoot file system : ext2\n",ROOT_DEVICE);

	/* mount device filesystem. */
	if (sys_mount("/dev", DEV_FS_NAME, "/dev") != NOERR) {
		PRINT_ERR("sys_mount() error!");
	}

	/* Init keyboard driver. */
	initKeyboard();

	/* ͥåȥν  */
	initNet();

	/* ͥåȥɥ饤Сν */
	rest = initEther();
	if(rest != NOERR){
		PRINT_ERR("initEther error!");
	}

	// InitץΥե륪ץ
	if (setInitProcFs() != NOERR){
		PRINT_ERR("setInitProc error!");
	}

	// ⥸塼륯饹ν
	ModuleInit();

	/* ǽΥ桼ץư롣 */
	rest = sys_fork();
   	if (rest < 0){
   		PRINT_ERR("Fork of first user process error!");
   	}
   	else if (rest == 0)
   	{
		// 桼ץ¹Ԥ
// 		rest = startExec("/shell", NULL, NULL);
   		rest = startExec("/sbin/init", NULL, NULL);
		if (rest < 0){
			PRINT_ERR("startExec error!");
		}
	}

	// ҥץexitԤ
	waitProc1();
}
