/*
 * AggregateList.h
 *
 * Copyright 2007; Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 *Գס
 * IteratorѥListIteratorAggregateList
 */


#ifndef AggregateList_h
#define AggregateList_h


#include <sys/object.h>
#include <sys/List.h>
#include <sys/IteratorList.h>


#ifndef ASM_FILE


/*
 * ꥹȽ繽¤
 */
typedef struct AggregateList {
	// °
	List			*head;		// ꥹȥإå
	List			*end;		// ꥹȥ
	int 			count;		// ³ꥹȿ
	
	// 
	void			(*insertHead) (struct AggregateList *, List *);
	void			(*insertEnd) (struct AggregateList *, List *);
	void			(*insertNext) (struct AggregateList *, List *, List *);
	void			(*insertPrev) (struct AggregateList *, List *, List *);
	void			(*removeEntry) (struct AggregateList *, List *);
	OBJECT*			(*getHead) (struct AggregateList *);
	OBJECT*			(*getEnd) (struct AggregateList *);
//	OBJECT*			(*getNext) (struct AggregateList *, List *);
//	OBJECT*			(*getPrev) (struct AggregateList *, List *);
	OBJECT*			(*refHead) (struct AggregateList *);
	OBJECT*			(*refEnd) (struct AggregateList *);
	OBJECT*			(*refNext) (struct AggregateList *, const List *);
	OBJECT*			(*refPrev) (struct AggregateList *, const List *);
	void			(*pointHeadNext) (struct AggregateList *);
	void			(*removeOut) (struct AggregateList *, List *);
	void			(*iterator) (struct AggregateList *, IteratorList *);
	void			(*iteratorReverce) (struct AggregateList *, IteratorList *);
	List*			(*refHeadList) (struct AggregateList *);
	List*			(*refEndList) (struct AggregateList *);
	List*			(*refNextList) (struct AggregateList *, const List *);
	List*			(*refPrevList) (struct AggregateList *, const List *);
	int 			(*getCount) (struct AggregateList *);
} AggregateList;

typedef OBJECT* (*LIST_FUNC1) (struct AggregateList *);
typedef void (*LIST_FUNC2) (struct AggregateList *, List *);
typedef OBJECT* (*LIST_FUNC3) (struct AggregateList *, List *);
typedef void (*LIST_FUNC4) (struct AggregateList *, List *, List *);
typedef OBJECT* (*LIST_FUNC5) (struct AggregateList *, const List *);
typedef OBJECT* (*LIST_FUNC6) (struct AggregateList *);
typedef void (*LIST_FUNC7) (struct AggregateList *);
typedef void (*LIST_FUNC8) (struct AggregateList *, List *);
typedef void (*LIST_FUNC9) (struct AggregateList *, IteratorList *);
typedef List* (*LIST_FUNC10) (struct AggregateList *);
typedef List* (*LIST_FUNC11) (struct AggregateList *, const List *);

extern void AggregateListConstructor(AggregateList *);
extern void AggregateSingleListConstructor(AggregateList *);
extern void AggregateCircleConstructor(AggregateList *);

#endif


#endif
