/*
 * sys/config.h
 *
 * Copyright 2004, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#ifndef sys_config_h
#define sys_config_h


#include <sys/limits.h>
#include <machine/vm.h>
#include <machine/fpu.h>


#ifdef KERNEL

#define START_ADDRESS			0x1000					/* setup.SΥɤ˥ɥ쥹 */
#define ROOT_DEVICE				"/dev/hdb5"				/* root file system device */
#define PAGING_BACKUP_DEVICE	"/dev/hdb6"				/* Paging back store device */

/* ƥ */
#define UTSNAME_SYSNAME   "UNDEFINE"
#define UTSNAME_NODENAME  "UNDEFINE"
#define UTSNAME_RELEASE   "UNDEFINE"
#define UTSNAME_VERSION   "UNDEFINE"

#define IP_ADDR(a,b,c,d) (a+(b<<8)+(c<<16)+(d<<24))
#define TIMEZOME_NAME "tokyo"

#endif	// KERNEL

/*
 * ɥ쥹
 *
 * ͥǡͥ륹åɥ饤Сǡɥ饤Сå桼ǡɣϥ꡼ޥå
 * 
 * 0            3ec00000          3f000000          3fc00000            40000000        e0000000            ffffffff
 *
 * 桼֤ϥɥ饤С֤鳫ϡɥ饤СåϥȤ˽ͭ
 */
#define IOMAP_BEG				0xe0000000							// ꡼ޥåIO˥ɥ쥹κǽ
#define KERNEL_END				0x3f000000							// ͥɥ쥹κǸ
#define KERNEL_DATA_BEG			0x100000							// ͥǡɥ쥹κǽ
#define KERNEL_DATA_END			KERNEL_STACK_BEG					// ͥǡɥ쥹κǸ
#define KERNEL_STACK_BEG		(KERNEL_STACK_END - PAGE_DIR_SIZE)	// ͥ륹åɥ쥹κǽ
#define KERNEL_STACK_END		KERNEL_END							// ͥ桼ͭ꡼ɥ쥹κǸ
#define KERNEL_SAVE_FPU			(KERNEL_STACK_END - FPU_SAVE_SIZE)	// FPU¸ɥ쥹
#define KERNEL_SWITCH_ESP		(KERNEL_SAVE_FPU - 4)				// ESP¸
#define KERNEL_SAVE_ESP			(KERNEL_SWITCH_ESP - 4)				// 桼ϥɥ
#define KERNEL_USER_RET			(KERNEL_SAVE_ESP - 4)				// 桼ϥɥ餫᥽å
#define KERNEL_USER_ESP			(KERNEL_USER_RET - 4)				// 桼ESP
#define KERNEL_CAHNGE_METHOD	(KERNEL_USER_ESP - 4)				// 촹᥽å
#define KERNEL_RESTORE_METHOD	(KERNEL_CAHNGE_METHOD - 4)			// ᤷ᥽å
#define KERNEL_ESP_BEG			KERNEL_RESTORE_METHOD				// ͥ륹åݥ󥿤κǽ

/*
 *԰¸եɥ饤СΰѤkern/vm.c kern/vm.hΥۥ꡼¤Υѹɬ
 */
#define DRIVER_BEG				KERNEL_END
#define DRIVER_END				0x40000000
#define DRIVER_DATA_BEG			DRIVER_BEG							// ɥ饤Сɥ쥹κǽ
#define DRIVER_DATA_END			(DRIVER_END - PAGE_DIR_SIZE)		// ɥ饤Сɥ쥹κǸ
#define DRIVER_STACK_BEG		DRIVER_DATA_END						// ɥ饤Сåɥ쥹κǽ
#define DRIVER_STACK_END		DRIVER_END							// ɥ饤Сåɥ쥹κǸ
#define DRIVER_ESP_BEG			DRIVER_STACK_END					// ɥ饤Сåݥ󥿤κǽ

#define USER_BEG				DRIVER_END							// 桼ɥ쥹κǽ
#define USER_END				IOMAP_BEG							// 桼ɥ쥹κǸ
#define USER_ESP_BEG			USER_END							// 桼åݥ󥿤κǽ顢user/include/system.h˱ƶ롣

#define MAX_CPU 8							/* бcpu */


#ifndef ASM_FILE


#ifdef KERNEL

enum{
	TASK_TIME = 10,					// 1Ư(ms)
	MAX_DEVICE_OPEN = 20,			// ǥХץǽ
	MAX_REGIST_FS = 16,				// ե륷ƥϿ
	TTY = 1,						// ͥå 1=console,2=com1,3=com2
	LOCAL_TIME_TOKYO = 32400,		// Ĵ 9

	/* Network. */
	IP_ADDRESS0=       IP_ADDR(172,25,0,3),		/* eth0 IPɥ쥹 */
	IP_SUBNETMASK0=    IP_ADDR(255,255,0,0),	/* eth0 IP֥ͥåȥޥ */
	IP_ADDRESS1=       IP_ADDR(172,25,0,4),		/* eth1 IPɥ쥹 */
	IP_SUBNETMASK1=    IP_ADDR(255,255,0,0),	/* eth1 IP֥ͥåȥޥ */
	IP_DEFAULT_GATEWAY=IP_ADDR(172,25,0,224),	/* ǥեȥȥ */
};

#endif	// KERNEL

/* exec()Ϳ륷ƥ */
typedef struct{
	unsigned int lastAddr;
} SYS_INFO;

enum {
	SYS_INFO_ADDR = USER_ESP_BEG - sizeof(SYS_INFO),	// SYS_INFOɥ쥹
};

#endif	// ASM_FILE


#endif
