/*
 * sys/signal.h
 */


#ifndef sys_signal_h
#define sys_signal_h


#include <sys/param.h>


#ifndef ASM_FILE


/*
 * signals.
 * default actions.
 *  A=abnormal termination,T=termination,C=continue process,S=stop process,I=ignore the signal
 */
#define SIGABRT		1		/* A	ܡ */
#define SIGALRM		2		/* T	顼ࡦå */
#define SIGBUS		3		/* A	Х顼ʥɥ쥹顼 */
#define SIGCHLD		4		/* I	ҥץξѲ */
#define SIGCONT		5		/* C	ߥץμ¹Է³ʥץ򵯤) */
#define SIGFPE		6		/* A	㳰 */
#define SIGHUP		7		/* T	ϥ󥰥å */
#define SIGILL		8		/* A	̿ */
#define SIGINT		9		/* T	󥿥ץȡctl+c */
#define SIGKILL		10		/* T	ץζλ(̵Բ) */
#define SIGPIPE		11		/* T	ɤ߼Τʤѥפؤν񤭹 */
#define SIGIO		12
#define SIGPOLL		SIGIO	/* T	input/output possible signal */
#define SIGPROF		13		/* T	ץե󥰡ޡλĶ */
#define SIGQUIT		14		/* A	λ */
#define SIGSEGV		15		/* A	ơȿɥ쥹ȡ */
#define SIGSTOP		16		/* S	ץߡª̵Բǽ */
#define SIGSYS		17		/* A	ƥࡦ */
#define SIGTERM		18		/* T	ץνλ */
#define SIGTRAP		19		/* A	ȥ졼⤷ϥ֥졼ݥȤ˴Ťȥå */
#define SIGTSTP		20		/* S	ץߡCtrl-zʤɤΥ */
#define SIGTTIN		21		/* S	ϻΥץ */
#define SIGTTOU		22		/* S	ϻΥץ */
#define SIGURG		23		/* I	åȶ۵޾ */
#define SIGUSR1		24		/* T	桼ʥ뭡 */
#define SIGUSR2		25		/* T	桼ʥ뭢 */
#define SIGVTALRM	26		/* T	ۥޡλĶ */
#define SIGXCPU		27		/* A	CPU¤Ķ */
#define SIGXFSZ		28		/* A	ե롦¤Ķ */
#define SIGWINCH	29		/* I	window size changes */
#define SIGINFO		30		/* I	information request */
#define SIGWAKE		31		/* I	ץƥ */
#define NSIG		32		/* ʥ륢 */

/* signal actions. */
#define SIG_DFL (SA_HANDLER)1	/* default action. */
#define SIG_IGN (SA_HANDLER)2	/* ignore. */
#define	SIG_ERR (SA_HANDLER)-1	/* Return value from signal() in case of error. */

enum{
	SA_ONSTACK		= 0x0001,	/* take signal on signal stack */
	SA_RESTART		= 0x0002,	/* restart system call on signal return */
	SA_RESETHAND	= 0x0004,	/* reset to SIG_DFL when taking signal */
	SA_NOCLDSTOP	= 0x0008,	/* do not generate SIGCHLD on child stop */
	SA_NODEFER		= 0x0010,	/* don't mask the signal we're delivering */
	SA_NOCLDWAIT	= 0x0020,	/* don't keep zombies around */
	SA_SIGINFO		= 0x0040,	/* signal handler with SA_SIGINFO args */

	SIG_BLOCK = 1,	/* The resulting set is the union of the current set and the signal set pointed to by the argument set. */
	SIG_UNBLOCK,	/* The resulting set is the intersection of the current set and the complement of the signal set pointed to by the argument set. */
	SIG_SETMASK,	/* The resulting set is the signal set pointed to by the argument set. */

	/* sig_pending()ѥե饰 */
	SIG_PENDING_SOTORE = 0,
	SIG_PENDING_SET,
};

typedef void (*SA_HANDLER)(int);
typedef	SA_HANDLER	sig_t;
typedef unsigned int sigset_t;

typedef struct sigaction {
	void (*sa_handler)(int);	/* What to do on receipt of signal. */
	sigset_t sa_mask;			/* Set of signals to be blocked during execution of the signal handling function. */
	int      sa_flags;			/* Special flags. */
} SIG_ACTION;

/*
 * Macro for converting signal number to a mask suitable for sigblock().
 */
#define sigmask(m)	(1 << ((m)-1))

#ifdef KERNEL

/*
 * ʥֹ򥷥ʥ륻åȤꤹ
 */
static inline void setSignal(
	sigset_t *signal,
	const int i_sigNum)
{
	*signal |= sigmask(i_sigNum);
}

/*
 * ʥֹ򥷥ʥ륻åȤ
 */
static inline void delSignal(
	sigset_t *signal,
	const int i_sigNum)
{
	*signal &= ~sigmask(i_sigNum);
}

/*
 * ̥ʥ륻åȤ򥷥ʥ륻åȤ˲ä
 */
static inline void addMask(
	sigset_t *signal,
	const sigset_t *i_signal)
{
	*signal |= *i_signal;
}

/*
 * ʥ륻åȤ̥ʥ륻åȤ
 */
static inline void delMask(
	sigset_t *signal,
	const sigset_t *i_signal)
{
	*signal &= ~(*i_signal);
}

/*
 * ʥ򤹤٤ƥåȤ
 */
static inline void setFillMask(
	sigset_t *signal)
{
	*signal = ~(sigset_t)0;
}

/*
 * ʥ륻åȤ򥯥ꥢ
 */
static inline void clearSignal(
	sigset_t *signal)
{
	*signal = 0;
}

/*
 * ʥ뤬åȤƤ뤫
 * return : YES or NO
 */
static inline int isSetSignal(
	sigset_t *signal)
{
	return (*signal == 0) ? NO : YES;
}

/*
 * λʥ뤬åȤƤ뤫
 * return : YES or NO
 */
static inline int isEndSignal(
	sigset_t *signal)
{
	if (*signal & (
		(1 << SIGABRT) |
		(1 << SIGBUS) |
		(1 << SIGHUP) |
		(1 << SIGILL) |
		(1 << SIGINT) |
		(1 << SIGKILL) |
		(1 << SIGQUIT) |
		(1 << SIGSEGV) |
		(1 << SIGTERM) |
		(1 << SIGTRAP) )) {
		return YES;
	}
	else {
		return NO;
	}
}

/*
 * ʥ뤬ޥƤ뤫
 * return : YES or NO
 */
static inline int isMaskSignal(
	sigset_t *signal,
	const int i_sigNum)
{
	return (*signal & sigmask(i_sigNum)) ? YES : NO;
}

#endif

#endif


#endif
