/*
 * sys/types.h
 */


#ifndef sys_types_h
#define sys_types_h


#include <machine/types.h>
#include <machine/limits.h>


#ifndef ASM_FILE


typedef unsigned int		size_t;
typedef int					ssize_t;		/* byte count or error */

typedef int					blkcnt_t;		/* Used for file block counts. */
typedef int					blksize_t;		/* Used	for block sizes.*/
typedef unsigned int		gid_t;			/* Used for group IDs. */
typedef unsigned int		ino_t;			/* Used for file serial numbers. */
typedef unsigned int		mode_t;			/* Used for some file attributes. */
typedef unsigned short		nlink_t;		/* Used for link counts. */
typedef int64_t				off_t;			/* Used for file sizes. */
typedef int					pid_t;			/* Used for process IDs and process group IDs. */
typedef int					time_t;			/* Used for time in seconds. */
typedef unsigned int		uid_t;			/* Used for user IDs. */
typedef unsigned int		clock_t;		/* Used for system times in clock ticks or CLOCKS_PER_SEC. */
typedef long				suseconds_t;	/* Used for time in microseconds. */
typedef unsigned int		id_t;
typedef unsigned int		fixpt_t;		/* fixed point number */
typedef char				*caddr_t;		/* core address */
typedef	int32_t				segsz_t;		/* segment size */
typedef unsigned int		fsblkcnt_t;
typedef unsigned int		fsfilcnt_t;

typedef uint8_t				u_int8_t;
typedef uint16_t			u_int16_t;
typedef uint32_t			u_int32_t;
typedef uint64_t			u_int64_t;

/*
 * POSIX Extensions
 */
typedef	unsigned char		uchar_t;
typedef	unsigned short		ushort_t;
typedef	unsigned int		uint_t;
typedef	unsigned long		ulong_t;
typedef	int32_t				daddr_t;		/* disk address */

/* ץ */
typedef unsigned char		uchar;
typedef unsigned short		ushort;
typedef unsigned int		uint;
typedef unsigned long		ulong;
typedef int64_t				int64;
typedef uint64_t			uint64;

typedef unsigned char		u_char;
typedef unsigned short		u_short;
typedef unsigned int		u_int;
typedef unsigned long		u_long;
typedef	int64_t				quad_t;
typedef	uint64_t			u_quad_t;

typedef	quad_t 				*qaddr_t;
typedef	quad_t				rlim_t;			/* resource limit */
typedef unsigned long		sector_t;
typedef	u_int32_t			udev_t;			/* device number */
typedef	u_int32_t			in_addr_t;		/* base type for internet address */
typedef	u_int16_t			in_port_t;

typedef	int32_t				clockid_t;

// pthread
typedef	uint					pthread_t;
typedef	struct pthread_attr*	pthread_attr_t;
typedef	int						pthread_barrier_t;
typedef	int						pthread_barrierattr_t;
typedef	int						pthread_cond_t;
typedef	int						pthread_condattr_t;
typedef	int						pthread_key_t;
typedef	int						pthread_mutex_t;
typedef	int						pthread_mutexattr_t;
typedef	int						pthread_once_t;
typedef	int						pthread_rwlock_t;
typedef	int						pthread_rwlockattr_t;
typedef	int						pthread_spinlock_t;

#ifdef KERNEL

#include <machine/endian.h>

typedef struct specinfo*	dev_t;
typedef	long				intfptr_t;
typedef	unsigned long		uintfptr_t;

#else

#ifdef MODULE
typedef struct specinfo*	dev_t;
#else
typedef	u_int32_t			dev_t;						/* device number */
#endif	// MODULE

typedef	long				fd_mask;
#define	NBBY				CHAR_BIT						/* number of bits in a byte */
#define	NFDBITS				(sizeof(fd_mask) * NBBY)		/* bits per mask */
#define	major(x)			((int)(((u_int)(x) >> 8)&0xff))	/* major number */
#define	minor(x)			((int)((x)&0xffff00ff))			/* minor number */
#define	makedev(x,y)		((dev_t)(((x) << 8) | (y)))

#endif	// KERNEL


#endif	// ASM_FILE


#endif
