/*
 * signal.h
 */


#ifndef signal_h
#define signal_h


#include <sys/types.h>
#include <sys/signal.h>


#define NSIG 32


extern const char *const sys_signame[NSIG];
extern char *sys_siglist[NSIG];


#define SV_INTERRUPT	SA_RESTART


typedef int sig_atomic_t;
struct	sigvec {
	SIG_ACTION *sv_handler;	/* signal handler */
	int	sv_mask;			/* signal mask to apply */
	int	sv_flags;			/* see signal options below */
};

extern int	kill(pid_t, int);
extern int	sigaction(int, const struct sigaction*, struct sigaction*);
extern int	sigaddset(sigset_t*, int);
extern int	sigdelset(sigset_t*, int);
extern int	sigemptyset(sigset_t *);
extern int	sigfillset(sigset_t *);
extern int	sigismember(const sigset_t *, int);
extern int	sigpending(sigset_t *);
extern int	sigprocmask(int, const sigset_t *, sigset_t *);
extern int	sigsuspend(const sigset_t *);
extern int	sigsetpending(sigset_t *);
extern int raise(int sig);
extern sig_t signal(int, sig_t);
extern int killpg(pid_t pgid, int sig);
extern int siginterrupt(int sig, int flag);
extern int sigvec(int signo,struct sigvec *sv,struct sigvec *osv);
extern int sigsetmask(int mask);
extern int sigblock(int mask);
extern int sigpause(int mask);


#endif
