/*
 * dev_method.c
 *
 * Copyright 2008, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#include <sys/types.h>
#include <sys/param.h>
#include <sys/bus.h>
#include <sys/bus_private.h>
#include <lib/dev_method.h>


//================================== PRIVATE ============================================

/*
 * Х᥽åɤ
 * return : method or NULL
 */
static void *getMethod(
	const device_t i_dev,
	const int i_desc)
{
	device_t dev;
	
	for (dev = i_dev; dev != NULL; dev = dev->parent){
		int i;

		if (dev->driver != NULL){
			device_method_t *methods = dev->driver->methods;
			for (i = 0; methods[i].func != NULL; i++){
				if (methods[i].desc == i_desc){
					return methods[i].func;
				}
			}
		}
	}
	
	return NULL;
}

/*
 * ̥᥽å
 * return : 
 */
static int method(
	device_t i_dev,
	const int i_desc,
	int param1,
	int param2,
	int param3,
	int param4,
	int param5,
	int param6,
	int param7)
{
	int (*func)(device_t, int, int, int, int, int, int, int);

	func = getMethod(i_dev, i_desc);
	if (func != NULL){
		return func(i_dev, param1, param2, param3, param4, param5, param6, param7);
	}
	else{
		
		return 0;
	}
}

/*
 * ̥᥽å
 * return : 
 */
static int method2(
	driver_t *i_drv,
	device_t i_dev,
	const int i_desc,
	int param1,
	int param2,
	int param3,
	int param4,
	int param5,
	int param6)
{
	int (*func)(driver_t*, device_t, int, int, int, int, int, int);

	func = getMethod(i_dev, i_desc);
	if (func != NULL){
		return func(i_drv, i_dev, param1, param2, param3, param4, param5, param6);
	}
	else{
		
		return 0;
	}
}

//================================== PUBLIC =============================================

void compile_methods(
	driver_t *driver)
{
	// ⤷ʤ
}

void free_methods(
	driver_t *driver)
{
	// ⤷ʤ
}

//--------------------------------------------------------------------------------------------------
// ᥽å
//--------------------------------------------------------------------------------------------------

int DEVICE_PROBE(
	device_t i_dev)
{
	return method(i_dev, device_probe_desc, 0, 0, 0, 0, 0, 0, 0);
}

int DEVICE_ATTACH(
	device_t i_dev)
{
	return method(i_dev, device_attach_desc, 0, 0, 0, 0, 0, 0, 0);
}
int DEVICE_DETACH(
	device_t i_dev)
{
	return method(i_dev, device_detach_desc, 0, 0, 0, 0, 0, 0, 0);
}

int DEVICE_SHUTDOWN(
	device_t i_dev)
{
	return method(i_dev, device_shutdown_desc, 0, 0, 0, 0, 0, 0, 0);
}

int DEVICE_SUSPEND(
	device_t i_dev)
{
	return method(i_dev, device_suspend_desc, 0, 0, 0, 0, 0, 0, 0);
}

int DEVICE_RESUME(
	device_t i_dev)
{
	return method(i_dev, device_resume_desc, 0, 0, 0, 0, 0, 0, 0);
}

void BUS_PROBE_NOMATCH(
	device_t i_dev, 
	device_t param1)
{
	method(i_dev, bus_probe_nomatch_desc, (int) param1, 0, 0, 0, 0, 0, 0);
}

void BUS_CHILD_DETACHED(
	device_t i_dev, 
	device_t param1)
{
	method(i_dev, bus_child_detached_desc, (int) param1, 0, 0, 0, 0, 0, 0);
}

int BUS_PRINT_CHILD(
	device_t i_dev, 
	device_t param1)
{
	return method(i_dev, bus_print_child_desc, (int) param1, 0, 0, 0, 0, 0, 0);
}

void BUS_DRIVER_ADDED(
	device_t i_dev, 
	driver_t *param1)
{
	method(i_dev, bus_driver_added_desc, (int) param1, 0, 0, 0, 0, 0, 0);
}

struct resource* BUS_ALLOC_RESOURCE(
	device_t i_dev, 
	device_t param1, 
	int param2, 
	int *param3, 
	u_long param4, 
	u_long param5, 
	u_long param6, 
	u_int param7)
{
	return (struct resource*) method(
		i_dev, 
		bus_alloc_resource_desc, 
		(int) param1, 
		(int) param2, 
		(int) param3, 
		(int) param4, 
		(int) param5, 
		(int) param6, 
		(int) param7);
}

int BUS_RELEASE_RESOURCE(
	device_t i_dev, 
	device_t param1, 
	int param2, 
	int param3, 
	struct resource *param4)
{
	return method(i_dev, bus_release_resource_desc, (int) param1, param2, param3, (int) param4, 0, 0, 0);
}

void BUS_DELETE_RESOURCE(
	device_t i_dev, 
	device_t param1, 
	int param2,
	int param3)
{
	method(i_dev, bus_delete_resource_desc, (int) param1, param2, param3, 0, 0, 0, 0);
}

int BUS_ACTIVATE_RESOURCE(
	device_t i_dev, 
	device_t param1, 
	int param2,
	int param3,
	struct resource *param4)
{
	return method(i_dev, bus_activate_resource_desc, (int) param1, param2, param3, (int) param4, 0, 0, 0);
}

int BUS_DEACTIVATE_RESOURCE(
	device_t i_dev, 
	device_t param1, 
	int param2,
	int param3,
	struct resource *param4)
{
	return method(i_dev, bus_activate_resource_desc, (int) param1, param2, param3, (int) param4, 0, 0, 0);
}

int BUS_GET_RESOURCE(
	device_t i_dev, 
	device_t param1, 
	int param2,
	int param3,
	u_long *param4,
	u_long *param5)
{
	return method(i_dev, bus_get_resource_desc, (int) param1, param2, param3, (int) param4, (int) param5, 0, 0);
}

int BUS_SET_RESOURCE(
	device_t i_dev, 
	device_t param1, 
	int param2,
	int param3,
	u_long param4,
	u_long param5)
{
	return method(i_dev, bus_set_resource_desc, (int) param1, param2, param3, (int) param4, (int) param5, 0, 0);
}

device_t BUS_ADD_CHILD(
	device_t i_dev, 
	int param1, 
	const char *param2, 
	int param3)
{
	return (device_t) method(i_dev, bus_add_child_desc, (int) param1, (int) param2, (int) param3, 0, 0, 0, 0);
}

int BUS_READ_IVAR(
	device_t i_dev,
	device_t param1, 
	int param2, 
	uintptr_t *param3)
{
	return method(i_dev, bus_read_ivar_desc, (int) param1, (int) param2, (int) param3, 0, 0, 0, 0);
}

int BUS_WRITE_IVAR(
	device_t i_dev, 
	device_t param1, 
	int param2, 
	uintptr_t param3)
{
	return method(i_dev, bus_write_ivar_desc, (int) param1, (int) param2, (int) param3, 0, 0, 0, 0);
}

int BUS_SETUP_INTR(
	device_t i_dev, 
	device_t param1, 
	struct resource *param2, 
	int param3, 
	void (*param4)(void *), 
	void *param5, 
	void *param6)
{
	return method(i_dev, bus_setup_intr_desc, (int) param1, (int) param2, (int) param3, (int) param4, (int) param5, (int) param6, 0);
}

int BUS_TEARDOWN_INTR(
	device_t i_dev, 
	device_t param1, 
	struct resource *param2, 
	void *param3)
{
	return method(i_dev, bus_teardown_intr_desc, (int) param1, (int) param2, (int) param3, 0, 0, 0, 0);
}

u_int32_t PCI_READ_CONFIG(
	device_t i_dev, 
	device_t param1, 
	int param2, 
	int param3)
{
	return method(i_dev, pci_read_config_desc, (int) param1, (int) param2, (int) param3, 0, 0, 0, 0);
}

void PCI_WRITE_CONFIG(
	device_t i_dev, 
	device_t param1, 
	int param2, 
	u_int32_t param3, 
	int param4)
{
	method(i_dev, pci_write_config_desc, (int) param1, (int) param2, (int) param3, param4, 0, 0, 0);
}

void PCI_ENABLE_BUSMASTER(
	device_t i_dev, 
	device_t param1)
{
	method(i_dev, pci_enable_busmaster_desc, (int) param1, 0, 0, 0, 0, 0, 0);
}

void PCI_DISABLE_BUSMASTER(
	device_t i_dev, 
	device_t param1)
{
	method(i_dev, pci_disable_busmaster_desc, (int) param1, 0, 0, 0, 0, 0, 0);
}

void PCI_ENABLE_IO(
	device_t i_dev, 
	device_t param1,
	int param2)
{
	method(i_dev, pci_enable_io_desc, (int) param1, param2, 0, 0, 0, 0, 0);
}

void PCI_DISABLE_IO(
	device_t i_dev, 
	device_t param1,
	int param2)
{
	method(i_dev, pci_disable_io_desc, (int) param1, param2, 0, 0, 0, 0, 0);
}

int MIIBUS_READREG(
	device_t i_dev, 
	int param1, 
	int param2)
{
	return method(i_dev, miibus_readreg_desc, param1, param2, 0, 0, 0, 0, 0);
}

int MIIBUS_WRITEREG(
	device_t i_dev, 
	int param1, 
	int param2,
	int param3)
{
	return method(i_dev, miibus_writereg_desc, param1, param2, param3, 0, 0, 0, 0);
}

int MIIBUS_STATCHG(
	device_t i_dev)
{
	return method(i_dev, miibus_statchg_desc, 0, 0, 0, 0, 0, 0, 0);
}

int MIIBUS_MEDIAINIT(
	device_t i_dev)
{
	return method(i_dev, miibus_mediainit_desc, 0, 0, 0, 0, 0, 0, 0);
}

void DEVICE_IDENTIFY(
	driver_t *i_drv, 
	device_t i_dev)
{
	method2(i_drv, i_dev, device_identify_desc, 0, 0, 0, 0, 0, 0);
}
