/*-
 * Copyright (c) 1990, 1993
 *	The Regents of the University of California.  All rights reserved.
 * (c) UNIX System Laboratories, Inc.
 * All or some portions of this file are derived from material licensed
 * to the University of California by American Telephone and Telegraph
 * Co. or Unix System Laboratories, Inc. and are reproduced herein with
 * the permission of UNIX System Laboratories, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)conf.h	8.5 (Berkeley) 1/9/95
 * $FreeBSD: src/sys/sys/conf.h,v 1.103.2.6 2002/03/11 01:14:55 dd Exp $
 *
 * 2008: modified by minoru murashima.
 */

#ifndef _SYS_CONF_H_
#define	_SYS_CONF_H_

#include <sys/types.h>
#include <sys/proc.h>
#include <sys/buf.h>
#include <sys/event.h>
#include <sys/uio.h>
#include <sys/tty.h>

struct specinfo {
	int dummy;
};

/*
 * Note: d_thread_t is provided as a transition aid for those drivers
 * that treat struct proc/struct thread as an opaque data type and
 * exist in substantially the same form in both 4.x and 5.x.  Writers
 * of drivers that dips into the d_thread_t structure should use
 * struct thread or struct proc as appropriate for the version of the
 * OS they are using.  It is provided in lieu of each device driver
 * inventing its own way of doing this.  While it does violate style(9)
 * in a number of ways, this violation is deemed to be less
 * important than the benefits that a uniform API between releases
 * gives.
 *
 * Users of struct thread/struct proc that aren't device drivers should
 * not use d_thread_t.
 */

typedef struct proc d_thread_t;

typedef int d_open_t(dev_t dev, int oflags, int devtype, d_thread_t *p);
typedef int d_close_t(dev_t dev, int fflag, int devtype, d_thread_t *p);
typedef void d_strategy_t(struct buf *bp);
typedef int d_parms_t(dev_t dev, struct specinfo *sinfo, int ctl);
typedef int d_ioctl_t(dev_t dev, u_long cmd, caddr_t data, int fflag, d_thread_t *p);
typedef int d_dump_t(dev_t dev);
typedef int d_psize_t(dev_t dev);
typedef int d_read_t(dev_t dev, struct uio *uio, int ioflag);
typedef int d_write_t(dev_t dev, struct uio *uio, int ioflag);
typedef int d_poll_t(dev_t dev, int events, d_thread_t *p);
typedef int d_kqfilter_t(dev_t dev, struct knote *kn);
typedef int d_mmap_t(dev_t dev, vm_offset_t offset, int nprot);

typedef int l_open_t(dev_t dev, struct tty *tp);
typedef int l_close_t(struct tty *tp, int flag);
typedef int l_read_t(struct tty *tp, struct uio *uio, int flag);
typedef int l_write_t(struct tty *tp, struct uio *uio, int flag);
typedef int l_ioctl_t(struct tty *tp, u_long cmd, caddr_t data, int flag, d_thread_t *p);
typedef int l_rint_t(int c, struct tty *tp);
typedef int l_start_t(struct tty *tp);
typedef int l_modem_t(struct tty *tp, int flag);

/*
 * XXX: The dummy argument can be used to do what strategy1() never
 * did anywhere:  Create a per device flag to lock the device during
 * label/slice surgery, all calls with a dummy == 0 gets stalled on
 * a queue somewhere, whereas dummy == 1 are let through.  Once out
 * of surgery, reset the flag and restart all the stuff on the stall
 * queue.
 */
#define BUF_STRATEGY(bp, dummy) (*devsw((bp)->b_dev)->d_strategy)(bp)
/*
 * Types for d_flags.
 */
#define	D_TAPE	0x0001
#define	D_DISK	0x0002
#define	D_TTY	0x0004
#define	D_MEM	0x0008

#define	D_TYPEMASK	0xffff

/*
 * Flags for d_flags.
 */
#define	D_MEMDISK		0x00010000	/* memory type disk */
#define	D_NAGGED		0x00020000	/* nagged about missing make_dev() */
#define	D_CANFREE		0x00040000	/* can free blocks */
#define	D_TRACKCLOSE	0x00080000	/* track all closes */
#define	D_KQFILTER		0x00200000	/* has kqfilter entry */

/*
 * Character device switch table
 */
struct cdevsw {
	d_open_t		*d_open;
	d_close_t		*d_close;
	d_read_t		*d_read;
	d_write_t		*d_write;
	d_ioctl_t		*d_ioctl;
	d_poll_t		*d_poll;
	d_mmap_t		*d_mmap;
	d_strategy_t	*d_strategy;
	const char		*d_name;	/* base device name, e.g. 'vn' */
	int				d_maj;
	d_dump_t		*d_dump;
	d_psize_t		*d_psize;
	u_int			d_flags;
	int				d_bmaj;
	/* additions below are not binary compatible with 4.2 and below */
	d_kqfilter_t	*d_kqfilter;
};

/*
 * Line discipline switch table
 */
struct linesw {
	l_open_t	*l_open;
	l_close_t	*l_close;
	l_read_t	*l_read;
	l_write_t	*l_write;
	l_ioctl_t	*l_ioctl;
	l_rint_t	*l_rint;
	l_start_t	*l_start;
	l_modem_t	*l_modem;
	u_char		l_hotchar;
};

#endif /* !_SYS_CONF_H_ */
