/*-
 * Copyright (c) 1997 Doug Rabson
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $FreeBSD: src/sys/sys/module.h,v 1.14.2.3 2002/03/17 11:07:45 alfred Exp $
 *
 * 2008: modified by minoru murashima.
 */


#ifndef module_h
#define module_h


enum {
	SI_SUB_DRIVERS,
	SI_ORDER_FIRST,
};

typedef enum modeventtype {
    MOD_LOAD,
    MOD_UNLOAD,
    MOD_SHUTDOWN
} modeventtype_t;

/*
 * A module can use this to report module specific data to
 * the user via kldstat(2).
 */
typedef union modspecific {
    int		intval;
    u_int	uintval;
    long	longval;
    u_long	ulongval;
} modspecific_t;

typedef struct module *module_t;
typedef void (*sysinit_nfunc_t) (void *);
typedef void (*sysinit_cfunc_t) (const void *);

struct sysinit {
	unsigned int	subsystem;		/* subsystem identifier*/
	unsigned int	order;			/* init order within subsystem*/
	sysinit_cfunc_t	func;			/* function		*/
	const void		*udata;			/* multiplexer/argument */
};

typedef	int (*modeventhand_t)(module_t mod, int /*modeventtype_t*/ what, void *arg);

/*
 * Struct for registering modules statically via SYSINIT.
 */
typedef struct moduledata {
	const char		*name;		/* module name */
	modeventhand_t	evhand;		/* event handler */
	void			*priv;		/* extra data */
} moduledata_t;

#define	C_SYSINIT(uniquifier, subsystem, order, func, ident)	\
	struct sysinit uniquifier ## _sys_init = {					\
		subsystem,												\
		order,													\
		func,													\
		ident													\
	};

#define	SYSINIT(uniquifier, subsystem, order, func, ident)		\
	C_SYSINIT(uniquifier, subsystem, order,						\
	(sysinit_cfunc_t)(sysinit_nfunc_t)func, (void *)ident)

#define DECLARE_MODULE(name, data, sub, order)	\
    SYSINIT(name##module, sub, order, module_register_init, &data)

extern void module_init();
extern module_t module_lookupbyname(const char *name);
extern void module_register_init(const void *data);
extern int module_unload(module_t mod);

#endif
