/*
 * device.h
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#ifndef device_h
#define device_h


#include"types.h"


#ifndef ASM_FILE


/* ʪǥХȤ */
typedef struct{
	const char *name;					/* Device name */
	int secter_size;					/* Secter size */
	uint begin_blk;						/* Begin block number */
	uint last_blk;						/* Last block number */
	int (*open)();						/* parameters : device name */
	int (*read)(void*,size_t,size_t);	/* parameters : Buffer,transfer blocks,Begin block number */
	int (*write)(void*,size_t,size_t);	/* parameters : Buffer,transfer blocks,Begin block number */
	int (*ioctl)(int,void*);			/* parameters : Comand,Parameters */
}DEV_INFO;


extern int init_device();
extern int regist_device(DEV_INFO*);
extern int delete_device(const char*);
extern int get_secter_size(int);
extern int get_partition_num(int);
extern int read_direct(int,void*,size_t,size_t);
extern int write_direct(int,void*,size_t,size_t);
extern int read_cache(int,void*,size_t,size_t);
extern int write_cache(int,void*,size_t,size_t);


#endif


#endif
