/*
 * mkfs.c
 *
 * Copyright 2003, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * ꥸʥե륷ƥۤ롣
 */


#include"types.h"
#include"lib.h"
#include"mm.h"
#include"fs.h"
#include"device.h"
#include"orig_fs.h"


/*
 * parameters : device path
 * return : 0 or error=-1
 */
int mk_orig_fs(const char *dev_path)
{
	void *dbuf;
	int fd;
	int din;
	SUPER_BLOCK *sbuf;
	ENPTY_BLOCK *ebuf;
	DEV_STAT dev_stat;
	int i,j,last,emp_num;


	/* Device open */
	if((fd=sys_open(dev_path,0))==-1)return -1;
	if((din=get_inode(fd))==-1)return -1;

	/* ѡƥ󥿥פγǧ */
	if(get_dev_stat(din,&dev_stat)==-1)return -1;
	if(dev_stat.prt_type!=PT_TYPE_ORIG)return -1;

	/* ѡ֥åꡣ */
	if((sbuf=(SUPER_BLOCK*)kmalloc(sizeof(SUPER_BLOCK)))==NULL)return -1;
	sbuf->secters=BLOCK_SIZE/dev_stat.sect_size;
	sbuf->all_blk=dev_stat.all_sect/sbuf->secters;
	sbuf->magic_number=SBLOCK_MAGIC;
	sbuf->useable_blk=(dev_stat.all_sect-SBLOCK_SECTER)/sbuf->secters-1;

	/* root directory  */
	sbuf->root_blk=SBLOCK_SECTER+sbuf->secters;
	if((dbuf=kmalloc(BLOCK_SIZE))==NULL)goto ERR;
	make_dir(dbuf,sbuf->root_blk);
	if(write_direct(din,dbuf,sbuf->secters,sbuf->root_blk)==sbuf->secters)goto ERR;		/* ǥХؽ񤭹ߡ */
	kfree(dbuf);

	/* ֥åǥåꡣ */
	if((ebuf=(ENPTY_BLOCK*)kmalloc(BLOCK_SIZE))==NULL)goto ERR;
	emp_num=(BLOCK_SIZE-sizeof(ENPTY_BLOCK))/sizeof(uint);
	dev_stat.all_sect=ROUNDDOWN(dev_stat.all_sect-sbuf->secters+1,sbuf->secters);
	last=dev_stat.all_sect-emp_num*sbuf->secters;
	for(i=sbuf->root_blk+sbuf->secters;i<last;)
	{
		/* ֥åǥåκ */
		for(j=emp_num-1;j>=0;--j)
		{
			ebuf->empty[j]=i;
			i+=sbuf->secters;
		}
		ebuf->next=i;
		ebuf->current=emp_num-1;
		write_direct(din,ebuf,BLOCK_SIZE,i-sbuf->secters);		/* ǥХؽ񤭹ߡ */

		/* ʹԾɽ */
		printk("Init empty index %d%%\r",i/(dev_stat.all_sect/100));
	}
	/* ֥åǥåκ */
	emp_num=(dev_stat.all_sect-i)/sbuf->secters;
	for(j=emp_num;j>=0;--j,i+=sbuf->secters)ebuf->empty[j]=i;
	ebuf->next=0;
	ebuf->current=emp_num;
	write_direct(din,ebuf,BLOCK_SIZE,i-sbuf->secters);		/* ǥХؽ񤭹ߡ */

	/* ʹԾɽ */
	printk("Init empty index 100%%\n");

	kfree(ebuf);

	sbuf->empty_blk=SBLOCK_SECTER+sbuf->secters+
		((BLOCK_SIZE-sizeof(ENPTY_BLOCK))/sizeof(uint)-1)*sbuf->secters;
	write_direct(din,sbuf,sizeof(SUPER_BLOCK),SBLOCK_SECTER);		/* ѡ֥å񤭹ࡣ */
	kfree(sbuf);

	/* device close */
	return sys_close(fd);

ERR:
	kfree(sbuf);
	sys_close(fd);

	return -1;
}
