/*
 * orig_fs.c
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * ꥸʥե륷ƥ
 */


#include"config.h"
#include"types.h"
#include"lib.h"
#include"errno.h"
#include"mm.h"
#include"fs.h"
#include"device.h"
#include"orig_fs.h"


enum{
	MAX_NAME_SIZE=127,	/* ե̾ */
	MAX_DIR_NUM=4,		/* ǥ쥯ȥ֥å */
};


/* Inode */
typedef struct{
	ushort owner_id;			/* Owner UID */
	ushort group_id;			/* Group ID */
	size_t size;				/* File size by byte */
	uint64 access_time;			/* Last access time */
	uint64 create_time;			/* Create time */
	uint64 modificat_time;		/* Last modification time */
	uint my_secter;				/* my block number */
	ushort file_type;			/* File type */
	ushort indirect;			/* ܻȥΡɿ */
	uint secter[0];				/* file secter number */
}INODE;

/* Directory entry
 * ؿdel_entry()Ǥ֤˰¸Ƥ롣
 */
typedef struct DIR_ENT{
	uint secter;		/* secter number */
	uchar type;			/* File or directory */
	uchar size;			/* entry size */
	uchar low_dir;		/* low entry directory */
	uchar high_dir;		/* high entry directory */
	ushort low;			/* low entry offset */
	ushort high;		/* high entry offset */
	ushort low_num;		/* lowȥ꡼ */
	ushort high_num;	/* highȥ꡼ */
	char name[0];		/* Name string */
}DIR_ENT;

/* Directory empty entry */
typedef struct{
	ushort prev;	/* prev empty entry */
	ushort next;	/* next empty entry */
	int size;		/* entry size */
}EMPTY_ENT;

/* Directory top */
typedef struct{
	uint my_secter;			/* my block number */
	uint next_dir;			/* next directory link */
	ushort empty_prev;		/* empty entry offset */
	ushort empty_next;		/* empty entry offset */
	uchar entry_dir;		/* Top entry direcctory */
	ushort entry_top;		/* Top entry offset */
	ushort size;			/* directory size */
	ushort owner_id;		/* Owner UID */
	ushort group_id;		/* Group ID */
	uint64 access_time;		/* Last access time */
	uint64 create_time;		/* Create time */
	uint64 modificat_time;	/* Last modification time */
	DIR_ENT entry[0];		/* begin entry */
}DIR;


#define ENTRY(entry,buf) ((DIR_ENT*)(entry+(uint)buf))
#define EMPTY(empty,buf) ((EMPTY_ENT*)(empty+(uint)buf))


static SUPER_BLOCK *super_blk[MAX_DEVICE_OPEN];
static ENPTY_BLOCK *empty_blk[MAX_DEVICE_OPEN];
static int indirect_size[3]={
	BLOCK_SIZE,
	BLOCK_SIZE*(BLOCK_SIZE/sizeof(uint)),
	BLOCK_SIZE*(BLOCK_SIZE/sizeof(uint))*(BLOCK_SIZE/sizeof(uint))
};


static uint mount(int);
static int umount(int);
static int open(const char*,int,uint);
static int close(int,uint);
static int read(int,uint,void*,size_t,size_t);
static int write(int,uint,void*,size_t,size_t);
static int ioctr(int,uint,int,void*);
static int rename(int,uint,const char*);
static int creat(const char*,int,uint);
static uint opendir(const char*,int,uint);
static int mkdir(const char*,int,uint);


static FS orig_fs={
	"orig_fs",mount,umount,open,close,read,write,ioctr,rename,creat,opendir,mkdir
};


/*
 * cmpare path strings
 * parameters : Destination string(end='\0'),Sorce string(end='/' or '\0')
 * return : =Υѥݥ or =1 or =-1;
 */
extern inline int cmp_path(const char *path1,const char *path2)
{
	while(*path1==*path2++)
		if(*path1++=='\0')return 0;

	if((*(path2-1)=='/')&&(*path1=='\0'))return (int)path2;
	if(*path1<*(path2-1))return 1;

	return -1;
}


/*
 * ǸΥѥʸ󤫤ɤȽꤹ롣
 * parameters : path
 * return : Ǹ 1,ǸǤʤ 0
 */
extern inline int is_last_path(const char *path)
{
	if(*path=='\0')return 1;

	while(*path++!='/')
		if(*path=='\0')return 1;

	return 0;
}


/************************************************************************************
 *
 * Init functions
 *
 ************************************************************************************/

int init_orig_fs()
{
	int i;


	for(i=0;i<MAX_DEVICE_OPEN;++i)
	{
		super_blk[i]=NULL;
		empty_blk[i]=NULL;
	}

	return regist_fs(&orig_fs);
}


/************************************************************************************
 *
 * block  functions
 *
 ************************************************************************************/

/*
 * ֥å롣
 * parameters : device inode
 * return : empty block secter or error=0
 */
uint get_empty_blk(int din)
{
	uint secter;


	if(empty_blk[din]==NULL)return 0;

	secter=empty_blk[din]->empty[empty_blk[din]->current];

	if(--empty_blk[din]->current<0)
	{
		if(empty_blk[din]->next==0)
		{
			kfree(empty_blk[din]);
			empty_blk[din]=NULL;
		}
		else
		{
			super_blk[din]->empty_blk=empty_blk[din]->next;
			if(read_direct(din,empty_blk[din],super_blk[din]->secters,empty_blk[din]->next)!=super_blk[din]->secters)
				return 0;

		}
	}

	return secter;
}


/*
 * ֥åơ֥åǥå˲ä롣
 * parameters :
 * return : 0 or error=-1
 */
int release_blk(int din,uint blk)
{
	/* ǥåʤ硣 */
	if(empty_blk[din]==NULL)
	{
		if((empty_blk[din]=(ENPTY_BLOCK*)kmalloc(BLOCK_SIZE))==NULL)return -1;
		super_blk[din]->empty_blk=blk;
		empty_blk[din]->next=0;
		empty_blk[din]->current=-1;
	}

	/* ǥåäѤξ硣 */
	if(++empty_blk[din]->current>=(BLOCK_SIZE-sizeof(ENPTY_BLOCK)/sizeof(uint)))
	{
		--empty_blk[din]->current;
		empty_blk[din]->next=blk;
		if((write_direct(din,empty_blk[din],super_blk[din]->secters,super_blk[din]->empty_blk))!=super_blk[din]->secters)
			return -1;
		super_blk[din]->empty_blk=blk;
		empty_blk[din]->next=0;
		empty_blk[din]->current=0;
	}

	empty_blk[din]->empty[empty_blk[din]->current]=blk;

	return 0;
}


/***********************************************************************************
 *
 * directory functions
 * ȥ꡼ʬڹ¤ˤ롣
 *
 ************************************************************************************/

/*
 * ȥ꡼low¦˲ž롣
 * parameters : directory buffer number pointer,entry offset pointer,directory buffer
 * return : new top entry
 */
void round_low(uchar *dn,ushort *entry,DIR **dir)
{
	uchar a;
	ushort b,c;
	DIR_ENT *top,*high;


	top=ENTRY(*entry,dir[*dn]);
	if((high=ENTRY(top->high,dir[top->high_dir]))==(DIR_ENT*)dir[0])return;

	/* topȥ꡼¸ */
	a=*dn;
	b=*entry;
	c=top->low_num+top->high_num;

	/* highȥ꡼topοƥȥ꡼λҥΡɤ˰ư */
	*entry=top->high;
	*dn=top->high_dir;

	/* highlowȥ꡼tophighȥ꡼˰ư */
	top->high_dir=high->low_dir;
	top->high=high->low;
	top->high_num=high->low_num;

	/* tophighlowȥ꡼˰ư */
	high->low_dir=a;
	high->low=b;
	high->low_num=c;
}


/*
 * ȥ꡼high¦˲ž롣
 * parameters : directory buffer number pointer,entry offset pointer,directory buffer
 * return : new top entry
 */
void round_high(uchar *dn,ushort *entry,DIR **dir)
{
	uchar a;
	ushort b,c;
	DIR_ENT *top,*low;


	top=ENTRY(*entry,dir[*dn]);
	if((low=ENTRY(top->low,dir[top->low_dir]))==(DIR_ENT*)dir[0])return;

	/* topȥ꡼¸ */
	a=*dn;
	b=*entry;
	c=top->low_num+top->high_num;

	/* highȥ꡼topοƥȥ꡼λҥΡɤ˰ư */
	*entry=top->low;
	*dn=top->low_dir;

	/* highlowȥ꡼tophighȥ꡼˰ư */
	top->low_dir=low->high_dir;
	top->low=low->high;
	top->low_num=low->high_num;

	/* tophighlowȥ꡼˰ư */
	low->high_dir=a;
	low->high=b;
	low->high_num=c;
}


/*
 * ʬ٨ʿؿ
 * ¦Υȥ꡼ȿ¦Υȥ꡼2ܤ¿
 * ¦¦Υȥ꡼¦Υȥ꡼1/2꾯ʤ硢ȿ¦زž롣
 * parameters : directory buffer number pointer,entry offset pointer,directory buffer
 */
void splay(uchar *dn,ushort *entry,DIR **dir)
{
	DIR_ENT *top;


	top=ENTRY(*entry,dir[*dn]);
	if((top->high_num>top->low_num*2)&&(ENTRY(top->high,dir[top->high_dir])->low_num<top->high_num/2))
		round_low(dn,entry,dir);
	else if((top->low_num>top->high_num*2)&&(ENTRY(top->low,dir[top->low_dir])->high_num<top->low_num/2))
		round_high(dn,entry,dir);
}


/*
 * ǥ쥯ȥƱ̾Υȥ꡼õ
 * ҥåȤ硢name˼ΥѥƬݥ󥿤֤
 * parameters : name address pointer,directory buffer
 * return : directory entry or error=NULL
 */
DIR_ENT *search_same_entry(const char **name,DIR **dir)
{
	int r;
	DIR_ENT *p;


	for(p=ENTRY(dir[0]->entry_top,dir[dir[0]->entry_dir]);p!=(DIR_ENT*)dir[0];)
	{
		r=cmp_path(p->name,*name);
		if(r<0)p=ENTRY(p->low,dir[p->low_dir]);
		else if(r>0)p=ENTRY(p->high,dir[p->high_dir]);
		else
		{
			*name=(const char*)r;
			return p;
		}
	}

	return NULL;
}


/*
 * ǥ쥯ȥǰ̾οƥȥ꡼롣
 * ǥ쥯ȥκǽΥȥ꡼¸ߤ뤳ȤȤ롣
 * parameters : name,directory buffer pointer,entry directory buffer pointer,entry offset pointer
 * return : 0 or error=-1
 */
int search_prev_entry(const char *name,DIR **dir,uchar **dn,ushort **ent)
{
	uchar *ent_dir;
	ushort *entry;
	int r;
	DIR_ENT *p=NULL;


	for(ent_dir=&dir[0]->entry_dir,entry=&dir[0]->entry_top;*entry!=0;)
	{
		splay(ent_dir,entry,dir);
		p=ENTRY(*entry,dir[*ent_dir]);
		r=cmp_path(p->name,name);
		if(r<0)
		{
			++p->low_num;
			ent_dir=&p->low_dir;
			entry=&p->low;
		}
		else if(r>0)
		{
			++p->high_num;
			ent_dir=&p->high_dir;
			entry=&p->high;
		}
		else return -1;
	}

	*dn=ent_dir;
	*ent=entry;

	return 0;
}


/*
 * ǥ쥯ȥζȥ꡼ơΥݥ󥿡롣
 * parameters : name size,directory pointer,directory buffer number pointer,entry offset pointer
 * return : directory entry pointer or error=NULL
 */
DIR_ENT *get_empty_entry(int path_len,DIR **dir,uchar *dn,ushort *entry)
{
	enum{MIM_EMPTY_SIZE=sizeof(DIR_ENT)+sizeof(int)};		/* ȥ꡼ǺǾλĤ */

	int entry_len;
	uchar i;
	ushort k,last;
	EMPTY_ENT *p,*q;


	/* ̾Υǧ */
	if(path_len>MAX_NAME_SIZE)return NULL;

	entry_len=ROUNDUP(path_len+1,sizeof(int))+sizeof(DIR_ENT);

	/* ȥ꡼򸡺 */
	last=(uint)dir[0]->empty_prev-(uint)dir[0];
	for(i=0;dir[i]!=NULL;++i)
	{
		for(k=dir[i]->empty_next;k!=last;k=p->next)
		{
			p=EMPTY(k,dir[i]);
			if(p->size>entry_len)
			{
				if(p->size>entry_len+MIM_EMPTY_SIZE)
				{
					q=EMPTY(k+entry_len,dir[i]);
					q->prev=p->prev;
					q->next=p->next;
					EMPTY(q->prev,dir[i])->next+=entry_len;
					EMPTY(q->next,dir[i])->prev+=entry_len;
					q->size=p->size-entry_len;
					((DIR_ENT*)p)->size=entry_len;
				}
				else
				{
					EMPTY(p->prev,dir[i])->next=p->next;
					EMPTY(p->next,dir[i])->prev=p->prev;
					((DIR_ENT*)p)->size=p->size;
				}

				*dn=i;
				*entry=k;
				memset(p,0,sizeof(DIR_ENT));

				return (DIR_ENT*)p;
			}
		}
	}

	return NULL;
}


/*
 * ȥ꡼ɲä롣
 * parameters :
 * return :
 */
void add_empty_entry(ushort entry,DIR *dir)
{
	ushort i,last;
	EMPTY_ENT *p,*q;


	i=dir->empty_next;
	p=(EMPTY_ENT*)&dir->empty_prev;

	/* եåȽ˶ȥ꡼Υ󥯤õ */
	for(last=(uint)&dir->empty_prev-(uint)dir;i!=last;i=p->next)
	{
		p=EMPTY(i,dir);
		if(i>entry)
		{
			/* ϰϤ³Ƥз礹롣 */
			if(i+p->size==entry)
			{
				p->size+=ENTRY(entry,dir)->size;
				return;
			}
			else break;
		}
	}

	/* ȥ꡼󥯤˲ä롣 */
	q=EMPTY(entry,dir);
	q->size=((DIR_ENT*)q)->size;
	q->next=p->next;
	q->prev=(uint)p-(uint)dir;
	p->next=entry;
	EMPTY(q->next,dir)->prev=entry;
}


/*
 * ȥ꡼ξʤزžʬǥȥ꡼򲼹ߤơ󥯤롣
 * parameters :
 * return : 0 or error=-1
 */
int del_entry(const char *name,DIR **dir)
{
	uchar *ent_dir,i;
	ushort *entry,k;
	int r;
	DIR_ENT *p,*q;


	ent_dir=&dir[0]->entry_dir;
	entry=&dir[0]->entry_top;

	/* ȥ꡼򸡺롣 */
	for(;;)
	{
		if(*entry==0)return -1;

		p=ENTRY(*entry,dir[*ent_dir]);
		r=cmp_path(p->name,name);
		if(r<0)
		{
			--p->low_num;
			ent_dir=&p->low_dir;
			entry=&p->low;
		}
		else if(r>0)
		{
			--p->high_num;
			ent_dir=&p->high_dir;
			entry=&p->high;
		}
		else break;
	}

	/* ߤ롣 */
	while(p->low_num*p->high_num)
	{
		if(p->low_num<p->high_num)
		{
			round_low(ent_dir,entry,dir);
			q=ENTRY(*entry,dir[*ent_dir]);
			ent_dir=&q->low_dir;
			entry=&q->low;
		}
		else
		{
			round_high(ent_dir,entry,dir);
			q=ENTRY(*entry,dir[*ent_dir]);
			ent_dir=&q->high_dir;
			entry=&q->high;
		}
	}

	/*  */
	i=*ent_dir;
	k=*entry;
	*ent_dir=p->low_dir+p->high_dir;
	*entry=p->low+p->high;
	if(*entry!=dir[0]->entry_top)*(entry+2)=p->low_num+p->high_num;	/* DIR_ENT¤ΤǤ֤˰¸롣 */
	add_empty_entry(k,dir[i]);

	return 0;
}


/*
 * ֥åХåե˿Υǥ쥯ȥ롣
 * parameters : directory buffer,secter
 */
void make_dir(void *dir,uint secter)
{
	EMPTY_ENT *empty;


	((DIR*)dir)->my_secter=secter;
	((DIR*)dir)->next_dir=0;
	((DIR*)dir)->empty_prev=sizeof(DIR);
	((DIR*)dir)->empty_next=sizeof(DIR);
	((DIR*)dir)->entry_dir=0;
	((DIR*)dir)->entry_top=0;
	((DIR*)dir)->size=BLOCK_SIZE;
	((DIR*)dir)->owner_id=0;		/* ̤ */
	((DIR*)dir)->group_id=0;		/* ̤ */
	((DIR*)dir)->access_time=0;		/* ̤ */
	((DIR*)dir)->create_time=0;		/* ̤ */
	((DIR*)dir)->modificat_time=0;	/* ̤ */

	/* ȥ꡼ꡣ */
	empty=(EMPTY_ENT*)((DIR*)dir)->entry;
	empty->prev=(uint)&((DIR*)dir)->empty_prev-(uint)dir;
	empty->next=empty->prev;
	empty->size=BLOCK_SIZE-sizeof(DIR);
}


/*
 * ѥΥǥ쥯ȥꥨȥ꡼õ
 * directory buffer0Ϥ餫꡼ƤƤΤȤ롣
 * parameters : path,device inode,directory block,directory buffer
 * return : 0 or error=-1
 */
DIR_ENT *search_path(const char **path,int din,uint dir_blk,DIR **dir)
{
	DIR_ENT *entry;
	int i;
	uint next_dir;


	if(**path=='\0')return NULL;

	for(;;)
	{
		/* ǥ쥯ȥХåեɤ߹ࡣ */
		if(read_cache(din,dir[0],super_blk[din]->secters,dir_blk)!=super_blk[din]->secters)
			return NULL;
		for(i=1,next_dir=dir[0]->next_dir;next_dir!=0;next_dir=dir[i++]->next_dir)
		{
			if(dir[i]==NULL)
				if((dir[i-1]=(DIR*)kmalloc(BLOCK_SIZE))==NULL)return NULL;
			if(read_cache(din,dir[0],super_blk[din]->secters,next_dir)!=super_blk[din]->secters)
				return NULL;
		}

		/* ǥ쥯ȥ򸡺 */
		if((entry=search_same_entry(path,dir))==NULL)return NULL;
		if(**path=='\0')break;
		if(entry->type!=DIRECTORY)return NULL;
		dir_blk=entry->secter;
	}

	return entry;
}


/************************************************************************************
 *
 * inode functions
 *
 ************************************************************************************/

/*
 * inodeХåե˥֥åǡɤ߹ࡣ
 * parameters : device inode,žХåե,ž(byte),ϥեå,inodeХåեݥ
 * return : ɤ߹ߥХȿ or error=-1
 */
int read_from_inode(int din,void *buf,size_t size,int begin,uint *inode)
{
	char *rbuf=NULL;
	int rest=size;
	int secters=super_blk[din]->secters;
	int i,s,t,last;


	i=begin/BLOCK_SIZE;

	/* ǽΥ֥å̤ž */
	if((s=begin%BLOCK_SIZE)!=0)
	{
		if((rbuf=(char*)kmalloc(BLOCK_SIZE))==NULL)return -1;
		if(read_cache(din,rbuf,secters,inode[i])!=secters)goto ERR;
		if((t=BLOCK_SIZE-s)>size)t=size;
		memcpy(buf,rbuf+s,t);
		(char*)buf+=t;
		++i;
		rest-=t;
	}

	if(rest>(BLOCK_SIZE/sizeof(uint)-i)*BLOCK_SIZE)
	{
		rest-=(BLOCK_SIZE/sizeof(uint)-i)*BLOCK_SIZE;
		for(last=BLOCK_SIZE/sizeof(uint);i<last;++i)
		{
			if(read_cache(din,buf,secters,inode[i])!=secters)goto ERR;
			(char*)buf+=BLOCK_SIZE;
		}
	}
	else
	{
		for(;rest<BLOCK_SIZE;rest-=BLOCK_SIZE)
		{
			if(read_cache(din,buf,secters,inode[i++])!=secters)goto ERR;
			(char*)buf+=BLOCK_SIZE;
		}

		/* Ĥ꤬֥å̤ž */
		if(rest!=0)
		{
			if(rbuf==NULL)
				if((rbuf=(char*)kmalloc(BLOCK_SIZE))==NULL)return -1;
			if(read_cache(din,rbuf,secters,inode[i])!=secters)goto ERR;
			memcpy(buf,rbuf,rest);
		}
	}

	kfree(rbuf);

	return size-rest;

ERR:
	kfree(rbuf);

	return -1;
}


/*
 * inodeХåե˥֥åǡ񤭹ࡣ
 * parameters : device inode,žХåե,ž(byte),ϥեå,inodeХåեݥ
 * return : 񤭹ߥХȿ or error=-1
 */
int write_to_inode(int din,void *buf,size_t size,int begin,uint *inode)
{
	char *rbuf=NULL;
	int rest=size;
	int secters=super_blk[din]->secters;
	int i,s,t,last;


	i=begin/BLOCK_SIZE;

	/* ǽΥ֥å̤ž */
	if((s=begin%BLOCK_SIZE)!=0)
	{
		if((rbuf=(char*)kmalloc(BLOCK_SIZE))==NULL)return -1;
		if(read_cache(din,rbuf,secters,inode[i])!=secters)goto ERR;
		if((t=BLOCK_SIZE-s)>size)t=size;
		memcpy(rbuf+s,buf,t);
		if(write_cache(din,rbuf,secters,inode[i])!=secters)goto ERR;
		(char*)buf+=t;
		++i;
		rest-=t;
	}

	if(rest>(BLOCK_SIZE/sizeof(uint)-i)*BLOCK_SIZE)
	{
		rest-=(BLOCK_SIZE/sizeof(uint)-i)*BLOCK_SIZE;
		for(last=BLOCK_SIZE/sizeof(uint);i<last;++i)
		{
			if(write_cache(din,buf,secters,inode[i])!=secters)goto ERR;
			(char*)buf+=BLOCK_SIZE;
		}
	}
	else
	{
		for(;rest<BLOCK_SIZE;rest-=BLOCK_SIZE)
		{
			if(write_cache(din,buf,secters,inode[i++])!=secters)goto ERR;
			(char*)buf+=BLOCK_SIZE;
		}

		/* Ĥ꤬֥å̤ž */
		if(rest!=0)
		{
			if(rbuf==NULL)
				if((rbuf=(char*)kmalloc(BLOCK_SIZE))==NULL)return -1;
			memcpy(rbuf,buf,rest);
			if(write_cache(din,rbuf,secters,inode[i])!=secters)goto ERR;
		}
	}

	kfree(rbuf);

	return size-rest;

ERR:
	kfree(rbuf);

	return -1;
}


/*
 * ɲäǥ֥åǡ񤭹ࡣ
 * parameters : device inode,žХåե,ž(byte),ϥեå,inodeХåեݥ
 * return : 񤭹ߥХȿ or error=-1
 */
int write_add(int din,void *buf,size_t size,int begin,uint *inode)
{
	void *wbuf;
	int rest;
	int secters=super_blk[din]->secters;
	int i;


	if(size>BLOCK_SIZE/sizeof(uint)*BLOCK_SIZE-begin)
	{
		for(i=begin/BLOCK_SIZE;i<BLOCK_SIZE/sizeof(uint);++i)
		{
			if((inode[i]=get_empty_blk(din))==0)return -1;
			if(write_cache(din,buf,secters,inode[i])!=secters)return -1;
			(char*)buf+=BLOCK_SIZE;
		}

		return BLOCK_SIZE/sizeof(uint)*BLOCK_SIZE-begin;
	}
	else
	{
		i=begin/BLOCK_SIZE;
		for(rest=size;rest<BLOCK_SIZE;rest-=BLOCK_SIZE)
		{
			if((inode[i++]=get_empty_blk(din))==0)return -1;
			if(write_cache(din,buf,secters,inode[i])!=secters)return -1;
			(char*)buf+=BLOCK_SIZE;
		}
		if((wbuf=kmalloc(BLOCK_SIZE))==NULL)return -1;
		memcpy(wbuf,buf,size);
		if(write_cache(din,wbuf,secters,inode[i])!=secters)return -1;
		kfree(wbuf);

		return size;
	}
}


/*
 * inodeХåե˥֥åǡɤ߹ࡣ
 * parameters : device inode,žХåե,ž(byte),ϥեå,ܻȥΡ,
 *              inodeХåեݥ(ǥåɬ0)
 * return : ɤ߹ߥХȿ or error=-1
 */
int read_indirect_inode(int din,void *buf,size_t size,int begin,int node,uint *inode)
{
	uint *_inode;
	int rest=size;
	int secters=super_blk[din]->secters;
	int i,s;


	if((_inode=(uint*)kmalloc(BLOCK_SIZE))==NULL)return -1;

	i=begin/indirect_size[node];

	if(node==1)
	{
		if(read_cache(din,_inode,secters,inode[i++])!=secters)goto ERR;
		if((s=read_from_inode(din,buf,size,begin,_inode))==-1)goto ERR;
		rest-=s;

		if(rest>(BLOCK_SIZE/sizeof(uint)-1)*indirect_size[1])
		{
			rest-=(BLOCK_SIZE/sizeof(uint)-1)*indirect_size[1];
			for(;i<BLOCK_SIZE/sizeof(uint);++i)
			{
				if(read_cache(din,_inode,secters,inode[i])!=secters)goto ERR;
				if(read_from_inode(din,buf,indirect_size[1],0,_inode)==-1)goto ERR;
			}
		}
		else
		{
			for(;rest>0;rest-=indirect_size[1])
			{
				if(read_cache(din,_inode,secters,inode[i++])!=secters)goto ERR;
				if(read_from_inode(din,buf,rest,0,_inode)==-1)goto ERR;
			}
			rest=0;
		}
	}
	else
	{
		if(read_cache(din,_inode,secters,inode[i++])!=secters)goto ERR;
		if((s=read_indirect_inode(din,buf,size,begin,node-1,_inode))==-1)goto ERR;
		rest-=s;

		if(rest>(BLOCK_SIZE/sizeof(uint)-1)*indirect_size[node])
		{
			rest-=(BLOCK_SIZE/sizeof(uint)-1)*indirect_size[node];
			for(;i<BLOCK_SIZE/sizeof(uint);++i)
			{
				if(read_cache(din,_inode,secters,inode[i])!=secters)goto ERR;
				if(read_indirect_inode(din,buf,indirect_size[node],0,node-1,_inode)==-1)goto ERR;
			}
		}
		else
		{
			for(;rest>0;rest-=indirect_size[node])
			{
				if(read_cache(din,_inode,secters,inode[i++])!=secters)goto ERR;
				if(read_indirect_inode(din,buf,rest,0,node-1,_inode)==-1)goto ERR;
			}
			rest=0;
		}
	}

	kfree(_inode);

	return size-rest;

ERR:
	kfree(_inode);

	return -1;
}


/*
 * ܻȤ񤭹ɲä롣
 *
 *
 */
int write_indirect_inode(int din,void *buf,size_t size,int begin,int node,uint *inode,size_t fsize)
{
	uint *_inode;
	int secters=super_blk[din]->secters;
	int i,s,rest,tmp;


	if((_inode=(uint*)kmalloc(BLOCK_SIZE))==NULL)return -1;

	i=begin/indirect_size[node];

	if(node==1)
	{
		/* ¸֥å񤭹ߡ */
		tmp=rest=(size>fsize)?fsize:size;

		if(read_cache(din,_inode,secters,inode[i++])!=secters)goto ERR;
		if((s=write_to_inode(din,buf,size,begin,_inode))==-1)goto ERR;
		rest-=s;

		for(;rest>=indirect_size[1];++i,rest-=indirect_size[1])
		{
			if(i==BLOCK_SIZE/sizeof(uint))goto END;

			if(read_cache(din,_inode,secters,inode[i])!=secters)goto ERR;
			if(write_to_inode(din,buf,indirect_size[1],0,_inode)==-1)goto ERR;
		}

		if(read_cache(din,_inode,secters,inode[i])!=secters)goto ERR;
		if(write_to_inode(din,buf,rest,0,_inode)==-1)goto ERR;

		/* ɲå֥å񤭹ߡ */
		tmp=size;
		rest=size-fsize;

		if(rest==0)goto END;

		if((s=write_add(din,buf,rest,rest%indirect_size[1],_inode))==-1)goto ERR;
		if(write_cache(din,_inode,secters,inode[i])!=secters)goto ERR;
		rest-=s;

		for(++i;rest>0;++i,rest-=indirect_size[1])
		{
			if(i==BLOCK_SIZE/sizeof(uint))goto END;

			if((inode[i]=get_empty_blk(din))==0)goto ERR;
			memset(_inode,0,BLOCK_SIZE);
			if(write_add(din,buf,rest,0,_inode)==-1)goto ERR;
			if(write_cache(din,_inode,secters,inode[i])!=secters)goto ERR;
		}
		rest=0;
	}
	else
	{
		/* ¸֥å񤭹ߡ */
		tmp=rest=size;

		if(read_cache(din,_inode,secters,inode[i++])!=secters)goto ERR;
		if((s=write_indirect_inode(din,buf,size,begin,node-1,_inode,fsize))==-1)goto ERR;
		rest-=s;
		fsize-=s;

		for(;rest>=indirect_size[node];rest-=indirect_size[node])
		{
			if(i==BLOCK_SIZE/sizeof(uint))goto END;

			if(read_cache(din,_inode,secters,inode[i])!=secters)goto ERR;
			if(write_indirect_inode(din,buf,indirect_size[node],0,node-1,_inode,fsize)==-1)goto ERR;

			++i;
			fsize-=indirect_size[node];
		}

		if(read_cache(din,_inode,secters,inode[i])!=secters)goto ERR;
		if(write_indirect_inode(din,buf,indirect_size[node],0,node-1,_inode,fsize)==-1)goto ERR;

		/* ɲå֥å񤭹ߡ */
		tmp=size;
		rest=size-fsize;

		if((s=write_indirect_inode(din,buf,rest,rest%indirect_size[node],node-1,_inode,0))==-1)goto ERR;
		if(write_cache(din,_inode,secters,inode[i])!=secters)goto ERR;
		rest-=s;
		++i;

		for(;rest>0;rest-=indirect_size[1])
		{
			if(i==BLOCK_SIZE/sizeof(uint))goto END;

			if((inode[i]=get_empty_blk(din))==0)goto ERR;
			memset(_inode,0,BLOCK_SIZE);
			if(write_indirect_inode(din,buf,indirect_size[node],0,node-1,_inode,0)==-1)goto ERR;
			if(write_cache(din,_inode,secters,inode[i])!=secters)goto ERR;
			++i;
		}
		rest=0;
	}
END:
	kfree(_inode);

	return tmp-rest;

ERR:
	kfree(_inode);

	return -1;
}


/************************************************************************************
 *
 * System call interface
 *
 ************************************************************************************/

uint mount(int din)
{
	void *buf;
	int secters;			/* BLOCK_SIZE/secter */
	DEV_STAT dev_stat;


	/* Ǥ˥ޥȤƤ뤫ǧ */
	if(super_blk[din]!=NULL)return 0;

	/* Read super block */
	if(get_dev_stat(din,&dev_stat)==-1)return 0;
	secters=BLOCK_SIZE/dev_stat.sect_size;
	if((buf=kmalloc(BLOCK_SIZE))==NULL)return 0;
	if(read_direct(din,buf,secters,SBLOCK_SECTER)!=secters)return 0;
	if(((SUPER_BLOCK*)buf)->magic_number!=SBLOCK_MAGIC)return 0;
	super_blk[din]=(SUPER_BLOCK*)buf;

	/* Read empty block */
	if((buf=kmalloc(BLOCK_SIZE))==NULL)goto ERR;
	if(read_direct(din,buf,secters,super_blk[din]->empty_blk)!=secters)goto ERR;
	empty_blk[din]=(ENPTY_BLOCK*)buf;

	return super_blk[din]->root_blk;

ERR:
	kfree(super_blk[din]);
	super_blk[din]=NULL;
	kfree(empty_blk[din]);
	empty_blk[din]=NULL;

	return 0;
}


int umount(int din)
{
	kfree(super_blk[din]);
	super_blk[din]=NULL;
	kfree(empty_blk[din]);
	empty_blk[din]=NULL;

	return 0;
}


int open(const char *path,int din,uint dir_blk)
{
	const char **p=&path;
	int inode;
	DIR *dir[MAX_DIR_NUM+1];
	DIR_ENT *entry;
	int i;


	/* ǥ쥯ȥХåեν */
	memset(dir,0,sizeof(DIR*)*(MAX_DIR_NUM+1));
	if((dir[0]=(DIR*)kmalloc(BLOCK_SIZE))==NULL)return -1;

	/* ѥ򸡺 */
	if((entry=search_path(p,din,dir_blk,dir))==NULL)inode=-1;
	else
	{
		if(entry->type==NORMAL_FILE)inode=entry->secter;
		else inode=-1;
	}

	/* ǥ쥯ȥХåե롣 */
	for(i=0;dir[i]!=NULL;++i)kfree(dir[i]);

	return inode;
}


int close(int din,uint inode)
{
	return 0;
}


int read(int din,uint ind,void *buf,size_t size,size_t begin)
{
	INODE *inode;	/* inodeХåե */


	if((inode=(INODE*)kmalloc(BLOCK_SIZE))==NULL)return -1;
	if(read_cache(din,inode,super_blk[din]->secters,ind)==super_blk[din]->secters)goto ERR;

	/* γǧ */
	if(begin>inode->size)goto ERR;
	if((size+begin)>inode->size)size=inode->size-begin;

	/* եɤ߹ߡ */
	if(inode->indirect==0)
	{
		begin+=sizeof(INODE)/sizeof(uint)*indirect_size[0];
		if(read_from_inode(din,buf,size,begin,(uint*)inode)!=size)goto ERR;
	}
	else
	{
		begin+=sizeof(INODE)/sizeof(uint)*indirect_size[inode->indirect];
		if(read_indirect_inode(din,buf,size,begin,inode->indirect,(uint*)inode)!=size)goto ERR;
	}

	kfree(inode);

	return 0;

ERR:
	kfree(inode);

	return -1;
}


int write(int din,uint ind,void *buf,size_t size,size_t begin)
{
	uint *_inode=NULL;
	int secters=super_blk[din]->secters;
	INODE *inode;
	int i;


	if((inode=(INODE*)kmalloc(BLOCK_SIZE))==NULL)return -1;
	if(read_cache(din,inode,secters,ind)!=secters)goto ERR;

	/* δܻȥΡɤꤹ롣 */
	i=inode->indirect;
	if((begin+size)>(indirect_size[i]*((BLOCK_SIZE-sizeof(INODE))/sizeof(uint))))
	{
		if((_inode=(uint*)kmalloc(BLOCK_SIZE))==NULL)goto ERR;
		do
		{
			memcpy(_inode,inode->secter,BLOCK_SIZE-sizeof(INODE));
			memset((char*)_inode+(BLOCK_SIZE-sizeof(INODE)),0,sizeof(INODE));
			if((inode->secter[0]=get_empty_blk(din))==-1)goto ERR;
			if(write_cache(din,_inode,secters,inode->secter[0])!=secters)goto ERR;
			memset(&inode->secter[1],0,BLOCK_SIZE-sizeof(INODE)-sizeof(uint));
		}while((begin+size)>(indirect_size[++i]*((BLOCK_SIZE-sizeof(INODE))/sizeof(uint))));
		inode->indirect=i;
	}

	/* 񤭹ߡ */
	if(write_indirect_inode(din,buf,size,begin+(BLOCK_SIZE-sizeof(INODE))/sizeof(uint)*indirect_size[i],
		i,(uint*)inode,inode->size)!=size)goto ERR;
	if(write_cache(din,inode,secters,ind)!=secters)goto ERR;

	kfree(_inode);
	kfree(inode);

	return 0;
ERR:
	kfree(_inode);
	kfree(inode);

	return -1;
}

/*********************************** ̤ ***************************************/
uint opendir(const char *path,int din,uint dir)
{
	return 0;
}


int mkdir(const char *path,int din,uint dir)
{
	return 0;
}


int creat(const char *path,int din,uint dir)
{
	return 0;
}


int ioctr(int din,uint inode,int cmd,void *param)
{
	return 0;
}


int rename(int din,uint inode,const char *name)
{
	return 0;
}
/*****************************************************************************************/
void test_orig_fs()
{
	int fd,din;


	if(init_orig_fs()==-1)
	{
		printk("Failed init_orig_fs\n");
		return;
	}

	if(sys_mount("/dev/hdb7","orig_fs","/")==-1)
	{
		printk("Failed sys_mount\n");
		return;
	}

	if((fd=sys_open("/dev/hdb7",0))==-1)return;
	if((din=get_inode(fd))==-1)return;

	printk("get_empty_blk()=%d\n",get_empty_blk(din));
}
/******************************************************************************************/
