/*
 * block_buf.c
 *
 * Copyright 2007, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 *Գס
 *
 *
 *
 *ԸƤ
 */


#include <sys/config.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/errno.h>
#include <sys/conf.h>
#include <sys/queue.h>
#include <sys/buf.h>
#include <sys/uio.h>
#include <sys/systm.h>
#include <lib/lib.h>
#include <machine/interrupt.h>
#include <kern/kmalloc.h>
#include <kern/timer.h>
#include <kern/ProcSignal.h>

#include <kern/debug.h>


//#define DEBUG_BLOCK_BUF 1
#ifdef DEBUG_BLOCK_BUF
	#define STATIC
	#define INLINE
#else
	#define STATIC	static
	#define INLINE	inline
#endif


//=====================================  ===================================================

//===================================== Х륤ݡ =======================================

//===================================== PRIVATE ====================================================

//===================================== PUBLIC =====================================================

/*
 *FreeBSD
 * Seek sort for disks.
 * The buf_queue keep two queues, sorted in ascending block order.  The first
 * queue holds those requests which are positioned after the current block
 * (in the first request); the second, which starts at queue->switch_point,
 * holds requests which came in after their block number was passed.  Thus
 * we implement a one way scan, retracting after reaching the end of the drive
 * to the first request on the second queue, at which time it becomes the
 * first queue.
 * A one-way scan is natural because of the way UNIX read-ahead blocks are
 * allocated.
 */
void bufqdisksort(struct buf_queue_head *bufq, struct buf *bp)
{
	struct buf *bq;
	struct buf *bn;
	struct buf *be;
	
	be = TAILQ_LAST(&bufq->queue, buf_queue);
	/*
	 * If the queue is empty or we are an
	 * ordered transaction, then it's easy.
	 */
	if ((bq = bufq_first(bufq)) == NULL || (bp->b_flags & B_ORDERED) != 0) {
		bufq_insert_tail(bufq, bp);
		return;
	}
	else if (bufq->insert_point != NULL) {
		/*
		 * A certain portion of the list is
		 * "locked" to preserve ordering, so
		 * we can only insert after the insert
		 * point.
		 */
		bq = bufq->insert_point;
	}
	else {
		/*
		 * If we lie before the last removed (currently active)
		 * request, and are not inserting ourselves into the
		 * "locked" portion of the list, then we must add ourselves
		 * to the second request list.
		 */
		if (bp->b_pblkno < bufq->last_pblkno) {
			bq = bufq->switch_point;
			/*
			 * If we are starting a new secondary list,
			 * then it's easy.
			 */
			if (bq == NULL) {
				bufq->switch_point = bp;
				bufq_insert_tail(bufq, bp);
				return;
			}
			/*
			 * If we lie ahead of the current switch point,
			 * insert us before the switch point and move
			 * the switch point.
			 */
			if (bp->b_pblkno < bq->b_pblkno) {
				bufq->switch_point = bp;
				TAILQ_INSERT_BEFORE(bq, bp, b_act);
				return;
			}
		}
		else {
			if (bufq->switch_point != NULL)
				be = TAILQ_PREV(bufq->switch_point, buf_queue, b_act);
			/*
			 * If we lie between last_pblkno and bq,
			 * insert before bq.
			 */
			if (bp->b_pblkno < bq->b_pblkno) {
				TAILQ_INSERT_BEFORE(bq, bp, b_act);
				return;
			}
		}
	}

	/*
	 * Request is at/after our current position in the list.
	 * Optimize for sequential I/O by seeing if we go at the tail.
	 */
	if (bp->b_pblkno > be->b_pblkno) {
		TAILQ_INSERT_AFTER(&bufq->queue, be, bp, b_act);
		return;
	}

	/* Otherwise, insertion sort */
	while ((bn = TAILQ_NEXT(bq, b_act)) != NULL) {
		/*
		 * We want to go after the current request if it is the end
		 * of the first request list, or if the next request is a
		 * larger cylinder than our request.
		 */
		if (bn == bufq->switch_point || bp->b_pblkno < bn->b_pblkno){
			break;
		}
		bq = bn;
	}
	TAILQ_INSERT_AFTER(&bufq->queue, bq, bp, b_act);
}

/*
 * ֥åǥХIO
 * return : error number
 */
int physio(dev_t dev, struct uio *uio, int ioflag)
{
	int i;
	int error = NOERR;
	u_int iolen;
	struct buf *bp;

	bp = kmalloc(sizeof(*bp));
	if (bp == NULL){
		return -ENOMEM;
	}
	memset(bp, 0, sizeof(*bp));

	for (i = 0; i < uio->uio_iovcnt; i++) {
		while (uio->uio_iov[i].iov_len) {
			if (uio->uio_rw == UIO_READ){
				bp->b_flags = B_PHYS | B_CALL | B_READ;
			}
			else {
				bp->b_flags = B_PHYS | B_CALL | B_WRITE;
			}
			bp->b_dev = dev;
			bp->b_data = uio->uio_iov[i].iov_base;		// 桼Хåե
			bp->b_bcount = uio->uio_iov[i].iov_len;		// IOХȿ
			bp->b_offset = uio->uio_offset;				// Хñ̳ϥեå

			// ϥ֥åֹ
			bp->b_blkno = bp->b_offset >> DEV_BSHIFT;		// 512Хñ̳ϥ֥å
			if ((devsw(dev)->d_flags & D_TYPEMASK) != D_MEM){
				if ((daddr_t)bp->b_blkno != bp->b_blkno) {
					error = -EINVAL; /* blockno overflow */
					goto doerror;
				}
			}

			// ǥХREAD
			BUF_STRATEGY(bp, 0);

			// ХåեžԤ
			while ((bp->b_flags & B_DONE) == 0){
				tsleep((caddr_t)bp, PRIBIO, "physstr", 0);
			}
			iolen = bp->b_bcount - bp->b_resid;			// b_resid = ̤žХȿ
			if (iolen == 0 && !(bp->b_flags & B_ERROR)){
				goto doerror;	/* EOF */
			}
			uio->uio_iov[i].iov_len -= iolen;
			uio->uio_iov[i].iov_base += iolen;
			uio->uio_resid -= iolen;
			uio->uio_offset += iolen;
			if( bp->b_flags & B_ERROR) {
				error = bp->b_error;
				goto doerror;
			}
		}
	}
doerror:
	kfree(bp);
	return (error);
}

/*
 *	Finish I/O on a buffer, optionally calling a completion function.
 *	This is usually called from an interrupt so process blocking is
 *	not allowed.
 *	biodone does not mess with B_INVAL, allowing the I/O routine or the
 *	initiator to leave B_INVAL set to brelse the buffer out of existance
 *	in the biodone routine.
 */
void biodone(struct buf * bp)
{
	int s;

	s = splbio();

	bp->b_flags |= B_DONE;

	/* call optional completion function if requested */
	if (bp->b_flags & B_CALL) {
		bp->b_flags &= ~B_CALL;
		TaskAwakeSoon(getTaskWait(bp->task));
		splx(s);
		return;
	}

	splx(s);
}
