/*
 * display.c
 *
 * Copyright 2007, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * ǥץ쥤ɽ
 */

#include <sys/config.h>
#include <sys/types.h>
#include <sys/param.h>
#include <lib/lib.h>
#include <dev/console/display.h>

#include <kern/debug.h>

//#define DEBUG_DISPLAY 1
#ifdef DEBUG_DISPLAY
	#define STATIC
	#define INLINE
#else
	#define STATIC	static
	#define INLINE	inline
#endif

//=====================================  ===================================================

typedef struct{
	uchar ch;							// ʸ
	uchar attr __attribute__((packed));	// °
} VRAM;

enum{
	VRAM_BASE_ADDR	= 0xb8000,			// ӥǥꥹȥɥ쥹
};

//===================================== Х륤ݡ =======================================

//===================================== PRIVATE ====================================================

static VRAM *screenVram = (VRAM*) VRAM_BASE_ADDR;
static int cur;

/*
 * ԥ륢å
 */
STATIC void scrollup()
{
	int i;

	// 2Ԥ25Ԥ򣱹ܤ˰ư
	for (i = 0; i < SCREEN_CHARS - SCREEN_COLUMNS; ++i) {
		screenVram[i] = screenVram[i + SCREEN_COLUMNS];
	}

	// 25ܤ򥯥ꥢ
	for (i = SCREEN_CHARS - SCREEN_COLUMNS; i < SCREEN_CHARS; ++i) {
		screenVram[i].ch = '\0';
		screenVram[i].attr = ATTR_NORMAL;
	}
}

//===================================== PUBLIC =====================================================

/*
 * ̤õ
 */
void clearScreenDisplay()
{
	int i;

	for (i = 0; i < SCREEN_CHARS; ++i) {
		screenVram[i].ch = 0;
		screenVram[i].attr = ATTR_NORMAL;
	}
}

/*
 * ʸɽ
 */
void putDisplay(
	const int ch,				// 饯
	const int attr)				// °
{
	if (SCREEN_CHARS <= cur) {
		scrollup();
		cur = SCREEN_CHARS - SCREEN_COLUMNS;
	}

	screenVram[cur].ch = ch;
	screenVram[cur].attr = attr;
	++cur;
}

/*
 * ʣʸ
 */
void deleteDisplay(
	const uint del)
{
	int i;

	for (i = cur; i + del < SCREEN_CHARS; ++i) {
		screenVram[i] = screenVram[i + del];
	}
	for (i = cur + del; i < SCREEN_CHARS; ++i) {
		screenVram[i].ch = 0;
		screenVram[i].attr = ATTR_NORMAL;
	}
}

/*
 * Ԥ
 */
void newLineDisplay()
{
	cur = ROUNDDOWN(cur + SCREEN_COLUMNS, SCREEN_COLUMNS);
	if (SCREEN_CHARS <= cur) {
		scrollup();
		cur -= SCREEN_COLUMNS;
	}
}

/*
 * ȥݥ򺸤˰ư
 */
void leftDisplay(
	const uint move)
{
	cur -= move;
}

/*
 * ȥݥ򱦤˰ư
 */
void rightDisplay(
	const uint move)
{
	cur += move;
	if (SCREEN_CHARS <= cur) {
		scrollup();
		cur = SCREEN_CHARS - SCREEN_COLUMNS;
	}
}

/*
 * ȥݥ
 */
int getCurrentDisplay()
{
	return cur;
}

/*
 * 
 */
void initDisplay()
{
	// Clear screen
	clearScreenDisplay();
}

//--------------------------------------------------------------------------------------------------
// ǥХå
//--------------------------------------------------------------------------------------------------

#ifdef DEBUG
/*
 * ˲̤ƬǤդη夫ɽ
 */
int displayTop(
	int column, 
	const char *bytes, 
	int size)
{
	int i;

	for (i = 0; i < size; ++i){
		screenVram[i + column].ch = bytes[i];
		screenVram[i + column].attr = ATTR_NORMAL;
	}

	return 0;
}
#endif
