/*
 * disk.c
 *
 * Copyright 200@, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 *Գס
 *
 *
 *
 *ԸƤ
 */

#include <sys/config.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/systm.h>
#include <sys/conf.h>
#include <lib/lib.h>
#include <sys/diskslice.h>

#include <kern/debug.h>

//=====================================  ===================================================

//===================================== Х륤ݡ =======================================

//===================================== PRIVATE ====================================================

static char *dsname(
	dev_t	dev,
	int		unit,
	int		slice,
	int		part,
	char	*partname)
{
	static char name[32];
	const char *dname;

	dname = devsw(dev)->d_name;
	if (MAX_DEVICE_NAME < strlen(dname)) {
		dname = "nametoolong";
	}
	snprintf(name, sizeof(name), "%s%d", dname, unit);
	partname[0] = '\0';
	if (slice != WHOLE_DISK_SLICE || part != RAW_PART) {
		partname[0] = 'a' + part;
		partname[1] = '\0';
		if (slice != COMPATIBILITY_SLICE){
			snprintf(name + strlen(name), sizeof(name) - strlen(name), "s%d", slice - 1);
		}
	}
	return (name);
}

//===================================== PUBLIC =====================================================

/*
 *FreeBSD
 * Disk error is the preface to plaintive error messages
 * about failing disk transfers.  It prints messages of the form
 * hp0g: hard error reading fsbn 12345 of 12344-12347 (hp0 bn %d cn %d tn %d sn %d)
 * if the offset of the error in the transfer and a disk label
 * are both available.  blkdone should be -1 if the position of the error
 * is unknown; the disklabel pointer may be null from drivers that have not
 * been converted to use them.  The message is printed with printf
 * if pri is LOG_PRINTF, otherwise it uses log at the specified priority.
 * The message should be completed (with at least a newline) with printf
 * or addlog, respectively.  There is no trailing space.
 */
void diskerr(
	struct buf *bp,
	char *what,
	int pri,
	int blkdone,
	struct disklabel *lp)
{
	int unit = dkunit(bp->b_dev);
	int slice = dkslice(bp->b_dev);
	int part = dkpart(bp->b_dev);
	char partname[2];
	char *sname;
	daddr_t sn;

	sname = dsname(bp->b_dev, unit, slice, part, partname);
	printf("%s%s: %s %sing fsbn ", sname, partname, what, bp->b_flags & B_READ ? "read" : "writ");
	sn = bp->b_blkno;
	if (bp->b_bcount <= DEV_BSIZE){
		printf("%ld", (long)sn);
	}
	else {
		if (blkdone >= 0) {
			sn += blkdone;
			printf("%ld of ", (long)sn);
		}
		printf("%ld-%ld", (long)bp->b_blkno, (long)(bp->b_blkno + (bp->b_bcount - 1) / DEV_BSIZE));
	}
	if (lp && (blkdone >= 0 || bp->b_bcount <= lp->d_secsize)) {
		sn += lp->d_partitions[part].p_offset;
		/*
		* XXX should add slice offset and not print the slice,
		* but we don't know the slice pointer.
		* XXX should print bp->b_pblkno so that this will work
		* independent of slices, labels and bad sector remapping,
		* but some drivers don't set bp->b_pblkno.
		*/
		printf(" (%s bn %ld; cn %ld", sname, (long)sn, (long)(sn / lp->d_secpercyl));
		sn %= (long)lp->d_secpercyl;
		printf(" tn %ld sn %ld)", (long)(sn / lp->d_nsectors), (long)(sn % lp->d_nsectors));
	}
}
