/*
 * Bootfs.c
 *
 * Copyright 2009, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 *Գסե꡼ե륷ƥࡢư˥ɤɥ饤СǼ뤿˻
 */

#include <sys/config.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/errno.h>
#include <sys/stat.h>
#include <lib/lib.h>
#include <kern/FsRegist.h>

#include <kern/debug.h>

//#define TEST_BOOTFS

//#define DEBUG_BOOTFS 1
#ifdef DEBUG_BOOTFS
	#define STATIC
	#define INLINE
#else
	#define STATIC	static
	#define INLINE	inline
#endif

//=====================================  ===================================================

/*
 * ȥ꡼쥤
 * ե̾NULLʸˡܥե륵intˡܥեǡ
 * ǸΥȥ꡼'\0'
 */

/*
 * ե륵intˡܥեǡ
 */
typedef struct {
	int		size;		// ե륵
	char	data[0];	// եǡ
} INODE;

//===================================== Х륤ݡ =======================================

//===================================== PRIVATE ====================================================

static char *startEntry;

/*
 * Υȥ꡼ݥ󥿤֤
 * return : ȥ꡼ݥ
 */
STATIC const char *nextEntry(
	const char *entry)
{
	const char *next = entry + strlen(entry) + 1;
	int size = *(int*) next;
	next += sizeof(size) + size;
	return next;
}

/*
 * ǽΥȥ꡼ݥ󥿤õ
 * setup᡼"bootfs\0"ʸμΥХȤǽΥȥ꡼
 * return : ȥ꡼ݥ or NULL
 */
STATIC char *searchStartEntry()
{
	const char magicStr[] = "OOTFS";
	char *str;

	for (str = (char*) START_ADDRESS;; ++str) {
		if (*str == 'B') {
			if (strcmp(str + 1, magicStr) == 0) {
				return str + 1 + sizeof(magicStr);
			}
		}
	}
	
	return NULL;
}

/*
 * ȥ꡼ݥ󥿤õ
 * return : ȥ꡼ݥ or NULL
 */
STATIC void *searchEntry(
	const char *name)
{
	const char *str = startEntry;
	while (strcmp(str, name) != 0) {
		if (*str == '\0') {
			str = NULL;
			break;
		}
		
		// Υȥ꡼ݥ
		str = nextEntry(str);
	}

	return (void*) str;
}

/*
 * Υȥ꡼ݥ󥿤֤
 * entryNULLʤǽΥȥ꡼֤
 * Υȥ꡼ʤСNULL֤
 * return : ȥ꡼ݥ
 */
STATIC const char *getNextEntry(
	const char *entry)
{
	if (entry == NULL) {
		return startEntry;
	}
	else {
		const char *next = nextEntry(entry);
		if (*next == '\0') {
			next = NULL;
		}
		return next;
	}
}

/*
 * ȥ꡼INODE롣
 * return : INODE
 */
STATIC INODE *getInodeFromEntry(
	const char *entry)
{
	return (INODE*) (entry + strlen(entry) + 1);

}

/*
 * ȥ꡼ե̾롣
 * return : ե̾ݥ
 */
STATIC const char *getName(
	const char *entry)
{
	return entry;

}

//--------------------------------------------------------------------------------------------------
// ե륷ƥե󥯥
//--------------------------------------------------------------------------------------------------

STATIC int mount(
	void *devDsc, 
	void **o_rootInodeObj)
{
	static int dummy;

	startEntry = searchStartEntry();
	if (startEntry == NULL) {
		return -ENOTBLK;
	}
	*o_rootInodeObj = &dummy;

	return NOERR;
}

STATIC int umount(
	void *devDsc,
	void *rootInodeObj)
{
	// ⤷ʤ
	return NOERR;
}

STATIC int lookup(
	const char *path,
	void *devDsc, 
	void *inodeObj, 
	uint *o_inodeNum, 
	const char **o_path)
{
	char *entry;

	if (*path == '\0') {
		// ROOTѥ
		entry = NULL;
	}
	else {
		entry = searchEntry(path);
		if (entry == NULL) {
			return -ENOENT;
		}
	}
	*o_inodeNum = (uint) entry;
	return NOERR;
}

STATIC int open(
	void *devDsc, 
	const uint inodeNum, 
	int oflag, 
	void **o_inodeObj, 
	int *o_type)
{
	*o_inodeObj = getInodeFromEntry((char*) inodeNum);
	*o_type = S_IFREG;
	return NOERR;
}

STATIC int close(
	void *devDsc, 
	void *inodeObj)
{
	// ⤷ʤ
	return NOERR;
}

STATIC int read(
	void *devDsc, 
	void *inodeObj, 
	void *buf, 
	uint i_size, 
	uint begin)
{
	INODE *inode = inodeObj;
	int size;

	if (inode->size < begin) {
		return -EOVERFLOW;
	}
	
	if (i_size + begin <= inode->size) {
		size = i_size;
	}
	else {
		size = inode->size - begin;
	}
	memcpy(buf, inode->data + begin, size);

	return size;
}

STATIC int opendir(
	void *devDsc, 
	void *dirInodeObj, 
	uint *m_block, 
	int *m_index)
{
	*m_block = (uint) getNextEntry(NULL);
	return NOERR;
}

STATIC int readdir(
void *devDsc, 
void *inodeObj, 
uint *m_block, 
int *m_index, 
char *o_name)
{
	if (*m_block == (uint) NULL) {
		*o_name = '\0';
	}
	else {
		const char *name = getName((const char*) *m_block);
		memcpy(o_name, name, strlen(name) + 1);
		*m_block = (uint) getNextEntry((const char*) *m_block);
	}
	return NOERR;
}

//--------- Not support ----------

STATIC int creat(
	const char *path, 
	void *devDsc, 
	void *inodeObj, 
	const int mode, 
	uint *o_inodeNum)
{
	return -ENOTSUP;
}

STATIC int write(
	void *devDsc, 
	void *inodeObj, 
	void *buf, 
	uint size, 
	uint begin)
{
	return -ENOTSUP;
}

STATIC int mknod(
	const char *path, 
	void *devDsc, 
	void *inodeObj, 
	const int mode, 
	const uint dev)
{
	return -ENOTSUP;
}

STATIC int mkdir(
	const char *path, 
	void *devDsc, 
	void *dirInodeObj, 
	int mode)
{
	return -ENOTSUP;
}

STATIC int delete(
	const char *path, 
	void *devDsc, 
	void *dirInodeObj, 
	int type)
{
	return -ENOTSUP;
}

STATIC int stat(
	void *devDsc, 
	void *inodeObj, 
	struct stat *m_stat)
{
	return -ENOTSUP;
}

STATIC int rename(
	void *devDsc, 
	void *oldDirInodeObj, 
	const char *oldPath, 
	void *newDirInodeObj, 
	const char *newPath)
{
	return -ENOTSUP;
}

STATIC int chattr(
	void *devDsc, 
	void *inodeObj, 
	uint mode, 
	uint uid, 
	uint gid, 
	uint atime, 
	uint mtime)
{
	return -ENOTSUP;
}

STATIC int link(
	void *devDsc, 
	void *dstInodeObj, 
	void *srcInodeObj, 
	const char *srcPath)
{
	return -ENOTSUP;
}

STATIC int symlink(
	const char *filePath, 
	void *devDsc, 
	void *dirInodeObj, 
	char *linkPath)
{
	return -ENOTSUP;
}

STATIC int ioctl(
	void *devDsc, 
	void *inodeObj, 
	int cmd, 
	caddr_t param, 
	int fflag)
{
	return -ENOTSUP;
}

STATIC int poll(
	void *inodeObj, 
	int events)
{
	return -ENOTSUP;
}

STATIC int statfs(
	void *devDsc, 
	struct statfs *m_statfs)
{
	return -ENOTSUP;
}

static FS bootfs={
	"bootfs",
	mount,
	umount,
	lookup,
	creat,
	open,
	close,
	read,
	write,
	ioctl,
	poll,
	opendir,
	readdir,
	rename,
	mknod,
	mkdir,
	stat,
	delete,
	chattr,
	link,
	symlink,
	statfs,
};

//===================================== PUBLIC =====================================================

int BootfsInit()
{
#ifdef TEST_BOOTFS
	extern void testBootfs();
	testBootfs();
#endif

	return regist_fs(&bootfs);
}

//===================================== TEST =======================================================

#ifdef TEST_BOOTFS
void testBootfs()
{
	static char *bootSign = (char*) 0x60000;
	char *pointa;
	char magicStr[] = {'B', 'O', 'O', 'T', 'F', 'S', '\0'};
	char test1[] = {'t', 'e', 's', 't', '1', '\0'};
	int test1Size = 5;
	char test1Data[] = {'t', 'e', 's', 't', '1'};
	char test2[] = {'t', 'e', 's', 't', '2', '\0'};
	int test2Size = 5;
	char test2Data[] = {'t', 'e', 's', 't', '2'};

	pointa = bootSign;
	memcpy(pointa, magicStr, sizeof(magicStr));
	pointa += sizeof(magicStr);
	memcpy(pointa, test1, sizeof(test1));
	pointa += sizeof(test1);
	memcpy(pointa, &test1Size, sizeof(test1Size));
	pointa += sizeof(test1Size);
	memcpy(pointa, test1Data, sizeof(test1Data));
	pointa += sizeof(test1Data);
	memcpy(pointa, test2, sizeof(test2));
	pointa += sizeof(test2);
	memcpy(pointa, &test2Size, sizeof(test2Size));
	pointa += sizeof(test2Size);
	memcpy(pointa, test2Data, sizeof(test2Data));

	startEntry = searchStartEntry();
	if (startEntry != bootSign + sizeof(magicStr)) {
	 	printk("searchStartEntry error! : %s line=%d \n",__FILE__, __LINE__);
	 	idle();
	}
	if (strcmp(searchEntry(test1), test1) != 0) {
	 	printk("searchEntry error! : %s line=%d \n",__FILE__, __LINE__);
	 	idle();
	}
	if (strcmp(searchEntry(test2), test2) != 0) {
	 	printk("searchEntry error! : %s line=%d \n",__FILE__, __LINE__);
	 	idle();
	}
	if (getNextEntry(NULL) != startEntry) {
	 	printk("getNextEntry error! : %s line=%d \n",__FILE__, __LINE__);
	 	idle();
	}
	if (getNextEntry(startEntry) != startEntry + sizeof(test1) + sizeof(test1Size) + sizeof(test1Data)) {
	 	printk("getNextEntry error! : %s line=%d \n",__FILE__, __LINE__);
	 	idle();
	}
	{
		INODE *inode = getInodeFromEntry(searchEntry(test2));
		if (inode->size != 5) {
		 	printk("getInodeFromEntry error! %x : %s line=%d \n", inode, __FILE__, __LINE__);
		 	idle();
		}
	}
	
	printk("testBootfs OK\n");

	{
		char space[] = {' ', ' ', ' ', ' ', ' ', ' ', ' '};
		memcpy(bootSign, space, sizeof(space));
	}
}
#endif
