/*
 * DevInterrupt.c
 *
 * Copyright 2008, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 *Գס
 *
 *
 *
 *ԸƤ
 */


#include <sys/config.h>
#include <sys/types.h>
#include <sys/param.h>
#include <lib/lib.h>
#include <sys/Thread.h>
#include <kern/TaskWait.h>
#include <kern/vm.h>
#include <module/interrupt.h>
#include <i386/interrupt.h>

#include <kern/debug.h>


//#define DEBUG_DEVINTERRUPT 1
#ifdef DEBUG_DEVINTERRUPT
	#define STATIC
	#define INLINE
#else
	#define STATIC	static
	#define INLINE	inline
#endif


//=====================================  ===================================================

//===================================== Х륤ݡ =======================================

//===================================== PRIVATE ====================================================

/*
 * return : task switch NO
 */
STATIC int defaultIntrHandler(int irq)
{
	printk("interrupt : %d\n", irq);
	return NO;
}

//===================================== PUBLIC =====================================================

/*
 * ͥߥϥɥơ֥
 * returns : task switch on 1,off 0
 */
int (*irq_entry[IRQ_ENTRY])(int) = {
	defaultIntrHandler,
	defaultIntrHandler,
	defaultIntrHandler,
	defaultIntrHandler,
	defaultIntrHandler,
	defaultIntrHandler,
	defaultIntrHandler,
	defaultIntrHandler,
	defaultIntrHandler,
	defaultIntrHandler,
	defaultIntrHandler,
	defaultIntrHandler,
	defaultIntrHandler,
	defaultIntrHandler,
	defaultIntrHandler,
	defaultIntrHandler,
	defaultIntrHandler,
	defaultIntrHandler,
	defaultIntrHandler,
	defaultIntrHandler
};

/*
 * Release hard interrupt mask
 * parameters : IRQ number
 */
void (*release_irq_mask)(uchar);

/*
 * Set hard interrupt mask
 * parameters : IRQ number
 */
void (*set_irq_mask)(uchar);

/*
 * ϡɳѣţϣɴؿ
 * parameters : IRQ number
 */
void (*irq_eoi)(const int);

/*
 * ͥߥϥɥƤӽФ
 *Գ
 *ԸƤեƥࡦ桼֤η¬ˡ
 * return : task switch YES or NO
 */
int doKernIntrHandler(
	const int i_irq)		// IRQֹ
{
	int isTaskSwitch;

	// ߻
	calcTaskUserTime();
	setTaskCurrentTime();

	// ϥɥ顼ƤӽФ
	isTaskSwitch = irq_entry[i_irq](i_irq);

	// ߻
	calcTaskSysTime();
	setTaskCurrentTime();

	return isTaskSwitch;
}

/*
 * 桼ߥϥɥѥ᡼򥻥åȤ
 * return : user esp
 */
uint setUserIntrParam(
	const int i_irq)		// IRQֹ
{
	return setUserModuleParam(
		IntrDscGetStackPoint(i_irq),
		IntrDscGetReturnMethod(i_irq), 
		(uint) IntrDscGetArg(i_irq), 
		0, 0, 0, 0, 0);
}

/*
 * ɥ饤С˰ܹԤ
 * return : ڡǥ쥯ȥ
 */
void *switchDriverTask(
	const int i_irq)		// IRQֹ
{
	// 塼˥ɥ饤Сɲäܹ
	addScheduleDaemon(IntrDscGetTask(i_irq));

	// 桼⡼ɤɣľܤǤ褦
	setUserModeIo();

	return switchTask();
}

//*************************************************************************************************

#ifdef DEBUG
void testDevInterrupt(
	const int flag)
{
}
#endif
