/*
 * Entry.c
 *
 * Copyright 2008, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 *Գס
 *
 *
 *
 *ԸƤ
 */


#include <sys/config.h>
#include <sys/types.h>
#include <sys/param.h>
#include <kern/vm.h>
#include <i386/interrupt.h>
#include <i386/Entry.h>

#include <kern/debug.h>

//=====================================  ===================================================

enum {
	EXEPT_ENTRY_NUM		= 20,		// 㳰ߥȥ꡼
	DEVINTR_ENTRY_NUM	= 20,		// ǥХߥȥ꡼
#ifdef DEBUG
	ENTRY_MAX			= 5,
#endif
};

typedef struct Entry {
	uint	paramAllocSize;		// 桼⥸塼ݥ󥿰ѥ꡼ƥ
#ifdef DEBUG
	uint	entry[ENTRY_MAX];	// ߡƥॳ륨ȥ꡼ɥ쥹
	int		entryIdx;
	uint	eip;
#endif
} Entry;

//===================================== Х륤ݡ =======================================

extern void except0();
extern void except1();
extern void except2();
extern void except3();
extern void except4();
extern void except5();
extern void except6();
extern void except7();
extern void except8();
extern void except9();
extern void except10();
extern void except11();
extern void except12();
extern void except13();
extern void except14();
extern void except15();
extern void except16();
extern void except17();
extern void except18();
extern void except19();
extern void devIrq0();
extern void devIrq1();
extern void devIrq2();
extern void devIrq3();
extern void devIrq4();
extern void devIrq5();
extern void devIrq6();
extern void devIrq7();
extern void devIrq8();
extern void devIrq9();
extern void devIrq10();
extern void devIrq11();
extern void devIrq12();
extern void devIrq13();
extern void devIrq14();
extern void devIrq15();
extern void devIrq16();
extern void devIrq17();
extern void devIrq18();
extern void devIrq19();

extern int doCallUserHandler(const void*, const uint);
extern int callUserModuleMethod(const void *method, const uint userEsp);

//===================================== PRIVATE ====================================================

/*
 * 㳰ȥ꡼ơ֥
 */
static void *exceptEntry[EXEPT_ENTRY_NUM] = {
	except0,
	except1,
	except2,
	except3,
	except4,
	except5,
	except6,
	except7,
	except8,
	except9,
	except10,
	except11,
	except12,
	except13,
	except14,
	except15,
	except16,
	except17,
	except18,
	except19,
};

/*
 * ǥХߥȥ꡼ơ֥
 */
static void *devIntrEntry[DEVINTR_ENTRY_NUM] = {
	devIrq0,
	devIrq1,
	devIrq2,
	devIrq3,
	devIrq4,
	devIrq5,
	devIrq6,
	devIrq7,
	devIrq8,
	devIrq9,
	devIrq10,
	devIrq11,
	devIrq12,
	devIrq13,
	devIrq14,
	devIrq15,
	devIrq16,
	devIrq17,
	devIrq18,
	devIrq19,
};

#ifdef DEBUG
static void saveEntry(
	const uint entry,
	const uint eip)
{
	Entry *this = (Entry*) getEntry(getCurrentTask());

	this->entry[this->entryIdx] = entry;
	this->entryIdx = ++this->entryIdx % ENTRY_MAX;
	this->eip = eip;
}
#endif

//===================================== PUBLIC =====================================================

/*
 * 㳰ϥɥơ֥
 */
void *exceptHandler[EXEPT_ENTRY_NUM];

/*
 * ǥХEOIơ֥
 */
void (*devEoi)(const int i_irq);

int EntryInit()
{
#ifdef DEBUG
	if (sizeof(Entry) != sizeof(EntryObj)) {
		printk("EntryInit() object size error! Entry=%d EntryObj=%d\n", sizeof(Entry), sizeof(EntryObj));
		idle();
	}
#endif

	return NOERR;
}

void EntryConstructor(
	EntryObj *entryObj)
{
	Entry *entry = (Entry*) entryObj;
	memset(entry, 0, sizeof(*entry));
}

void EntryDestructor(
	EntryObj *entryObj)
{
	// ⤷ʤ
}

/*
 * 㳰ȥ꡼
 */
void setExceptEntry(
	const int i_intr,		// ID
	void *i_handler)		// 㳰ϥɥ
{
	ASSERT(0 <= i_intr && i_intr < EXEPT_ENTRY_NUM);

	exceptHandler[i_intr] = i_handler;

	// Ͽ
	set_idt(i_intr, exceptEntry[i_intr], IDT_TRAP);

}

/*
 * 㳰߶ػߥȥ꡼
 */
void setExceptIntrEntry(
	const int i_intr,		// ID
	void *i_handler)		// 㳰ϥɥ
{
	ASSERT(0 <= i_intr && i_intr < EXEPT_ENTRY_NUM);

	exceptHandler[i_intr] = i_handler;

	// Ͽ
	set_idt(i_intr, exceptEntry[i_intr], IDT_INTR);
}

/*
 * ǥХߤ
 */
void setDevIntrEntry(
	const int i_intr,		// ID
	const int i_irq,		// IRQ
	void *i_eoi)			// EOIȯ
{
	ASSERT(0 <= i_irq && i_irq < DEVINTR_ENTRY_NUM);

	devEoi = i_eoi;

	// Ͽ
	set_idt(i_intr, devIntrEntry[i_irq], IDT_INTR);
}

/*
 * ɥ롼פ򳫻Ϥ
 */
void startIdle()
{
	sti();
	asm volatile(
		"movl	%0, %%esp\n"
		"jmp	idle"
		::"i"(KERNEL_ESP_BEG)
	);
}

/*
 * 桼ΰ襹åݥ󥿤
 * return : 桼ΰ襹åݥ
 */
void *getUserStackPoint()
{
	TaskContext *context = (TaskContext*) (KERNEL_ESP_BEG - sizeof(TaskContext));

	ASSERT((USER_BEG < (uint) context->user_esp) && ((uint) context->user_esp <= USER_ESP_BEG));

	return (uint*) context->user_esp;
}

/*
 * getUserStackPoint()ǻȤ桼ΰ襹åݥ󥿤ꤹ
 * return : 桼ΰ襹åݥ
 */
void setUserStackPoint(
	const uint userEsp)
{
	TaskContext *context = (TaskContext*) (KERNEL_ESP_BEG - sizeof(TaskContext));

	context->user_esp = userEsp;
}

/*
 * ⥸塼륹å꡼Ƥ
 *ռƤФ
 *աե⥸塼ƽФ˳ΤǡƤʣ⥸塼ƤӽФȡƤƥ⥸塼ƤӽФꡣ
 * return : ɥ쥹
 */
void *entryAllocParamMem(
	uchar *userEsp,				// 桼ΰ襹åݥ
	const uint size)
{
	Entry *entry = (Entry*) getEntry(getCurrentTask());
	entry->paramAllocSize += size;
	return userEsp - entry->paramAllocSize;
}

/*
 * 桼᥽åɥѥ᡼ꤹ
 * return : 桼ΰƬåݥ
 */
uint setUserModuleParam(
	uchar *userEsp,				// 桼ΰ襹åݥ
	const void *returnMethod,
	uint param1,
	uint param2,
	uint param3,
	uint param4,
	uint param5,
	uint param6)
{
	Entry *entry = (Entry*) getEntry(getCurrentTask());
	uint *startEsp = (uint*) (userEsp - ROUNDUP(entry->paramAllocSize, sizeof(int)));

	*--startEsp = param6;
	*--startEsp = param5;
	*--startEsp = param4;
	*--startEsp = param3;
	*--startEsp = param2;
	*--startEsp = param1;
	*--startEsp = (uint) returnMethod;
	
	entry->paramAllocSize = 0;
	
	return (uint) startEsp;
}

/*
 * 桼ϥɥƤӽФ
 */
void callUserHandler(
	const void *handler,		// 桼ϥɥ
	const void *returnMethod,	// 桼ϥɥ餫᥽å
	const int param)			// ʥֹ
{
	// ѥ᡼
	uint userEsp = setUserModuleParam(
		getUserStackPoint(),
		returnMethod, 
		param,
		0,
		0,
		0,
		0,
		0);

	doCallUserHandler(handler, userEsp);
}

/*
 * ̥桼᥽åɤƤӽФ
 */
int callUserMethod(
	ThreadObj *moduleTask,		// ⥸塼륿
	const void *method,			// 桼᥽å
	const void *returnMethod,	// 桼꥿᥽å
	const uint param1,			// ѥ᡼
	const uint param2,			// ѥ᡼
	const uint param3,			// ѥ᡼
	const uint param4,			// ѥ᡼
	const uint param5,			// ѥ᡼
	const uint param6)			// ѥ᡼
{
	uint userEsp;
	int error;

	// ѥ᡼
	userEsp = setUserModuleParam(
		getUserStackPoint(),
		returnMethod, 
		param1,
		param2,
		param3,
		param4,
		param5,
		param6);

	// ⥸塼ƤӽФۥ꡼Ķꤹ
	vmSetModuleCall(getVmTask(moduleTask));

	// 桼⡼ɤɣľܤǤ褦ꤹ
	setUserModeIo();

	// 桼᥽åɤƤӽФ
	error = callUserModuleMethod(method, userEsp);

	// ͥ⡼ɣɣϤ᤹
//	setKernelModeIo();
	
	return error;
}

#ifdef DEBUG

void saveEntryExcept(
	const uint entry,
	const TaskContext context)
{
	saveEntry(entry, context.eip);
}

void saveEntryTrap(
	const uint entry,
	const uint kernelSwitchEsp,
	const TaskContext context)
{
	saveEntry(entry, context.eip);
}

void saveEntrySyscall(
	const uint entry,
	const SYSCALL_FRAME context)
{
	saveEntry(entry, context.eip);
}

uint EntryGetUserEip()
{
	Entry *this = (Entry*) getEntry(getCurrentTask());
	return this->eip;
}

/*
 * ߡƥॳ륨ȥ꡼ɽ
 */
void printEntry()
{
	Entry *this = (Entry*) getEntry(getCurrentTask());
	int i;

	printk("Task entry = ");
	for (i = this->entryIdx - 1;; --i) {
		if (i < 0) {
			i = ENTRY_MAX - 1;
		}
		printk("%x ", this->entry[i]);
		
		if (i == this->entryIdx) {
			break;
		}
	}
	printk("\n");
}
#endif

#ifdef DEBUG
void testEntry(
	void *task,
	const int line)
{
	Entry *this = (Entry*) getEntry(task);
	printDebug(80 * line + 70, "%x  ", this->eip);
}
#endif
