/*
 * Entry.h
 *
 * Copyright 2008, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#ifndef i386_Entry_h
#define i386_Entry_h

#include <sys/config.h>
#include <sys/config.h>

#ifndef ASM_FILE

/*
 * ȥ꡼¤
 *԰¸EntryƱ
 */
typedef struct {
	char dummy[32];
} EntryObj;

/*
 * ƥ
 */
typedef struct {
//	uint gs;
//	uint fs;
	uint ds;
	uint es;
	uint edi;
	uint esi;
	uint ebp;
	uint esp;
	uint ebx;
	uint edx;
	uint ecx;
	uint eax;
	uint error;
	uint eip;
	uint cs;
	uint eflags;
	uint user_esp;
	uint ss;
} TaskContext;

extern int EntryInit();
extern void EntryConstructor(EntryObj*);
extern void EntryDestructor(EntryObj*);
extern void startIdle();
extern void wait_task();
extern uint setChildContext(void*);
extern void saveStackEsp(void*);
extern void setExceptEntry(const int, void*);
extern void setExceptIntrEntry(const int, void*);
extern void setDevIntrEntry(const int, const int, void*);
extern void *getUserStackPoint();
extern void setUserStackPoint();
extern void *entryAllocParamMem(uchar*, const uint);
extern uint setUserModuleParam(uchar*, const void*, uint, uint, uint, uint, uint, uint);
extern int syscall();
extern int syscallModule();
extern void moduleInit();
extern void callUserHandler(const void *, const void *, const int);
extern void returnUserMethod();
extern void changeUserCall();
#ifdef DEBUG
extern uint EntryGetUserEip();
extern void printEntry();
#endif


#endif // ASM_FILE

#endif // i386_Entry_h
