/*
 * Entry_asm.S
 *
 * Copyright 2008, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 *Գסեͥ롦桼⡼ɡְܹ
 *
 *
 *
 *ԸƤ
 */

#define ASM_FILE

#include <sys/config.h>
#include <sys/param.h>
#include <sys/syscall.h>
#include <sys/Thread.h>
#include <i386/segment.h>
#include <i386/interrupt.h>

#include <kern/debug.h>

//--------------------------------------------------------------------------------------------------
// ޥ
//--------------------------------------------------------------------------------------------------

#define GLOBAL(x)	.globl x; x:

/*
 * ƥȥ֤ѹϡproc.cset_context()˱ƶ
 */
.macro SAVE
	pushal
	pushl	%es
	pushl	%ds
/*	pushl	%fs
	pushl	%gs*/
	movl	$KERNEL_DATA_DES, %eax
	movl	%eax, %es
	movl	%eax, %ds
	cld
.endm

/*
 * ƥᤷ
 */
.macro RESTORE
/*	popl	%gs
	popl	%fs*/
	popl	%ds
	popl	%es
	popal
	addl	$4, %esp		// 顼ʬ
	iret
.endm

/*
 * ƥȥƬESPΥ
 */
.macro SAVE_ESP
	pushl	KERNEL_SWITCH_ESP
	movl	%esp, KERNEL_SWITCH_ESP
.endm

/*
 * ƥȥƬESPᤷ
 */
.macro RESTORE_ESP
	movl	KERNEL_SWITCH_ESP, %esp
	popl	KERNEL_SWITCH_ESP
.endm

/*
 * ۥ꡼֤Υå
 *ճ߶ػߤǸƤФ뤳
 * in   : eax = ڡǥ쥯ȥ
 * work : ecx, edx
 */
.macro SWITCH
	call	switchTask
	SAVE_ESP

	// ۥ꡼֤򥹥å
	movl	%eax, %cr3

	RESTORE_ESP

	// FPUԲ㳰Ĥˤ
	call	setTs
.endm

/*
 * Υƥȥ
 * parameter : esp = ʪåɥ쥹
 */
.macro SAVE_CREATE_ESP
	pushl	$0							// 
	movl	%esp, %eax
	andl	$~(PAGE_SIZE - 1), %eax
	orl		$(KERNEL_SWITCH_ESP & (PAGE_SIZE - 1)), %eax
	movl	%esp, %edx
	andl	$(PAGE_SIZE - 1), %edx
	addl	$(KERNEL_STACK_END - PAGE_SIZE), %edx
	movl	%edx, (%eax)
.endm

/*
 * 㳰ϥɥ顼ƤӽФ
 */
.macro EXCEPT intr
	SAVE
	call	incrementNest

#ifdef DEBUG
	pushl	$\intr
	call	saveEntryExcept
	addl	$4, %esp
#endif
	call	*(exceptHandler + (\intr * 4))

	call	doSignal
	movl	%eax, %esi

	cli
	call	decrementNest
	cmpl	$YES, %esi		// åġԲĥե饰
	jne		1f
	SWITCH
1:
	RESTORE
.endm

/*
 * ǥХߥͥɥ饤С
 *ճԲĤǸƤӽФ
 */
.macro TRAP irq
	pushl	$0				// 顼
	SAVE
	call	incrementNest
	sti

	// 桼ߥϥɥ饿ɲä뤿ᤳesp¸Ƥ
	SAVE_ESP

#ifdef DEBUG
	pushl	$\irq + 30
	call	saveEntryTrap
	addl	$4, %esp
#endif
	pushl	$\irq
	call	doKernIntrHandler
	addl	$4, %esp
	movl	%eax, %esi		// ֤ͤ¸

	RESTORE_ESP

	call	doSignal
	orl		%eax, %esi		// ϥɥ֤ͤȥӥå

	// Υ˰ܹԤޤǳ߶ػ
	cli
	call	decrementNest

	cmpl	$YES, %esi
	jne		1f
	SWITCH
1:
	pushl	$\irq
	call	*devEoi
	addl	$4, %esp

	RESTORE
.endm

/*
 * ǥХߥ桼ɥ饤С
 *ճԲĤǸƤӽФ
 */
.macro USER_TRAP irq jump
	pushl	$0							// 顼
	SAVE

	// ޤ줿ΥƥȥESP򤳤¸
	SAVE_ESP

	// ߥǥХɥ饤С˰ܹ
#ifdef DEBUG
	pushl	$\irq + 30
	call	saveEntryTrap
	addl	$4, %esp
#endif
	pushl	$\irq
	call	switchDriverTask			// eax = ڡǥ쥯ȥ

	// ۥ꡼ְܹ
	movl	%eax, %cr3
	call	setTs						// FPUԲ㳰Ĥˤ

	call	incrementNest
	sti

	// ߥϥɥѥ᡼򥻥å
	pushl	$\irq
	call	setUserIntrParam
	movl	%eax, %edi					// user esp    edi = userCall parameter

	// ߥϥɥ鳫ϥݥ󥿤
	pushl	$\irq
	call	IntrDscGetHandler
	movl	%eax, %esi					// user method esi = userCall parameter

	movl	$\jump, KERNEL_RETURN_POINT	// ¹Գϥݥ󥿤

	// 桼᥽åɤƤӽФ
	jmp		*userCall					// changeUserCall()ꤵ

\jump:
	cli
	call	decrementNest

	pushl	$TASK_INTR_WAIT
	call	delFromSchedule
	SWITCH

	/*
	 * EOIȯԤϡۥ꡼֤ܹԤƤǤʤȡCPUǥåƱѤ
	 */
	pushl	$\irq
	call	*devEoi
	addl	$4, %esp

	RESTORE
.endm


.text

//--------------------------------------------------------------------------------------------------
// 㳰
//--------------------------------------------------------------------------------------------------

GLOBAL(except0)
	pushl	$0
	EXCEPT 0
GLOBAL(except1)
	pushl	$0
	EXCEPT 1
GLOBAL(except2)
	pushl	$0
	EXCEPT 2
GLOBAL(except3)
	pushl	$0
	EXCEPT 3
GLOBAL(except4)
	pushl	$0
	EXCEPT 4
GLOBAL(except5)
	pushl	$0
	EXCEPT 5
GLOBAL(except6)
	pushl	$0
	EXCEPT 6
GLOBAL(except7)
	pushl	$0
	EXCEPT 7
GLOBAL(except8)
	EXCEPT 8
GLOBAL(except9)
	pushl	$0
	EXCEPT 9
GLOBAL(except10)
	EXCEPT 10
GLOBAL(except11)
	EXCEPT 11
GLOBAL(except12)
	EXCEPT 12
GLOBAL(except13)
	EXCEPT 13
GLOBAL(except14)
	EXCEPT 14
GLOBAL(except15)
	pushl	$0
	EXCEPT 15
GLOBAL(except16)
	pushl	$0
	EXCEPT 16
GLOBAL(except17)
	EXCEPT 17
GLOBAL(except18)
	pushl	$0
	EXCEPT 18
GLOBAL(except19)
	pushl	$0
	EXCEPT 19

//--------------------------------------------------------------------------------------------------
// ǥХ
//--------------------------------------------------------------------------------------------------

GLOBAL(devIrq0)
	TRAP 0
GLOBAL(devIrq1)
	USER_TRAP 1 returnDev1
GLOBAL(devIrq2)
	TRAP 2
GLOBAL(devIrq3)
	TRAP 3
GLOBAL(devIrq4)
	TRAP 4
GLOBAL(devIrq5)
	TRAP 5
GLOBAL(devIrq6)
	TRAP 6
GLOBAL(devIrq7)
	TRAP 7
GLOBAL(devIrq8)
	TRAP 8
GLOBAL(devIrq9)
	TRAP 9
GLOBAL(devIrq10)
	TRAP 10
GLOBAL(devIrq11)
	TRAP 11
GLOBAL(devIrq12)
	TRAP 12
GLOBAL(devIrq13)
	TRAP 13
GLOBAL(devIrq14)
	USER_TRAP 14 returnDev14
GLOBAL(devIrq15)
	USER_TRAP 15 returnDev15
GLOBAL(devIrq16)
	TRAP 16
GLOBAL(devIrq17)
	TRAP 17
GLOBAL(devIrq18)
	USER_TRAP 18 returnDev18
GLOBAL(devIrq19)
	USER_TRAP 19 returnDev19

//--------------------------------------------------------------------------------------------------
// ƥॳ
//--------------------------------------------------------------------------------------------------

/*
 *աեå¸ѹ"SYSCALL_PARAM""SYSCALL*_FRAME"ѹɬ
 * eax = ƥॳֹ
 */
#define SYSCALL_PARAM 44			// ƥॳѥ᡼
GLOBAL(syscall)
	pushl	%esi
	pushl	%edi
	pushl	%ebp
	movl	%eax, %esi				// ƥॳֹesi¸
	movl	$KERNEL_DATA_DES, %edx
	movl	%edx, %ds
	movl	%edx, %es
	cld

	call	incrementNest
	call	calcTaskUserTime
	call	setTaskCurrentTime
#ifdef DEBUG
	pushl	syscall_table(,%esi, 4)
	call	saveEntrySyscall
	call	displaySyscallStart
	addl	$4, %esp
#endif

	movl	SYSCALL_PARAM(%esp), %eax
	pushl	%eax
	movl	SYSCALL_PARAM(%esp), %ecx
	pushl	%ecx
	movl	SYSCALL_PARAM(%esp), %edx
	pushl	%edx
	movl	SYSCALL_PARAM(%esp), %eax
	pushl	%eax
	movl	SYSCALL_PARAM(%esp), %ecx
	pushl	%ecx
	movl	SYSCALL_PARAM(%esp), %edx
	pushl	%edx
	call	*syscall_table(, %esi, 4)
	addl	$4 * 6, %esp
	movl	%eax, %esi				// ͤesi¸
	movl	%edx, %edi				// ͤedi¸

	call	calcTaskSysTime
	call	setTaskCurrentTime
#ifdef DEBUG
	call	displaySyscallEnd
#endif
	call    doSignal
	movl	%eax, %ebp				// ͤ¸
	call	decrementNest

	// å
	cmpl	$YES, %ebp
	jne		1f
	call	wait_task
1:
	movl	$USER_DATA_DES, %edx
	movl	%edx, %ds
	movl	%edx, %es
	movl	%esi, %eax
	movl	%edi, %edx
	popl	%ebp
	popl	%edi
	popl	%esi

	// 桼espss򥷥ƥॳѥ᡼ʬ夲
	movl	4 * 9(%esp), %ecx
	movl	%ecx, 4 * 2(%esp)
	movl	4 * 10(%esp), %ecx
	movl	%ecx, 4 * 3(%esp)
	lret

/*
 * ⥸塼ѥƥॳ
 * eax = ƥॳֹ
 */
#define SYSCALL_PARAM_MODULE 32			// ƥॳѥ᡼
GLOBAL(syscallModule)
	movl	$KERNEL_DATA_DES, %edx
	movl	%edx, %ds
	movl	%edx, %es
	cld

	pushl	%eax
	call	incrementNest
	popl	%eax

	movl	SYSCALL_PARAM_MODULE(%esp), %ecx
	pushl	%ecx
	movl	SYSCALL_PARAM_MODULE(%esp), %edx
	pushl	%edx
	movl	SYSCALL_PARAM_MODULE(%esp), %ecx
	pushl	%ecx
	movl	SYSCALL_PARAM_MODULE(%esp), %edx
	pushl	%edx
	movl	SYSCALL_PARAM_MODULE(%esp), %ecx
	pushl	%ecx
	movl	SYSCALL_PARAM_MODULE(%esp), %edx
	pushl	%edx
	call	*syscall_table(, %eax, 4)
	addl	$4 * 6, %esp

	pushl	%eax
	call	decrementNest
	popl	%eax

	movl	$USER_DATA_DES, %edx
	movl	%edx, %ds
	movl	%edx, %es

	// 桼espss򥷥ƥॳѥ᡼ʬ夲
	movl	4 * 9(%esp), %ecx
	movl	%ecx, 4 * 2(%esp)
	movl	4 * 10(%esp), %ecx
	movl	%ecx, 4 * 3(%esp)
	lret

/*
 * ⥸塼ĥƥॳ
 * eax = ƥॳֹ
 * ebx = 
 * ecx = 
 * edx = 
 * esi = 
 * edi = 
 * ebp = 
 */
GLOBAL(moduleInit)
	pushl	$0
	pushal
	pushl	%es
	pushl	%ds
/*	pushl	%fs
	pushl	%gs*/
	pushl	%eax			// ƥॳֹ
	movl	$KERNEL_DATA_DES, %eax
	movl	%eax, %es
	movl	%eax, %ds
	cld
	popl	%eax

	pushl	%ebp			// 
	pushl	%edi			// 
	pushl	%esi			// 
	pushl	%edx			// 
	pushl	%ecx			// 
	pushl	%ebx			// 
	call	*syscall_table(,%eax,4)

	addl	$4 * 6, %esp

	RESTORE

/*
 * ưǽEXEC
 */
GLOBAL(startExec)
	pushl	0
	pushl	0
	pushl	0
	pushl	0
	pushl	28(%esp)
	pushl	28(%esp)
	pushl	28(%esp)
	pushl	$0					// 桼ƥॳߡEIP
	pushl	$KERNEL_CODE_DES
	movl	$SYS_EXEC, %eax
	call	syscall
	addl	$4, %esp			// lretΤESPϥߡEIPʬ᤹
	ret

//--------------------------------------------------------------------------------------------------
// å
//--------------------------------------------------------------------------------------------------

/*
 * void wait_task()
 *Ի߶ػߤˤʤ
 */
GLOBAL(wait_task)
	// åΥƥȤ
	popl	%eax				// ƤӽФeip
	pushfl
//	orl		$0x200, (%esp)		// äƤȤ߲Ĥˤ
	pushl	$KERNEL_CODE_DES
	pushl	%eax
	pushl	$0					// 顼
	SAVE
	cli
	SWITCH
	RESTORE

/*
 * forkλҥץΥƥȤۤ롣
 * ҥץϤδؿ꤫鳫Ϥ롣
 * int setChildContext(
 *	void*);				// ҥץͥ륹åʪɥ쥹
 * return : YES = ҥץ or NO = ƥץ
 */
GLOBAL(setChildContext)
	// åƤҥåإԡ
	movl	$KERNEL_STACK_END, %eax
	subl	%esp, %eax				// ԡ
	movl	4(%esp), %edx			// ҥץåѥ꡼
	addl	$PAGE_SIZE, %edx
	subl	%eax, %edx				// ԡ襢ɥ쥹
	movl	%esp, %ecx
	pushl	%eax
	pushl	%ecx
	pushl	%edx
	call	memcpy
	addl	$12, %esp

	// espҥץå꡼
	movl	%esp, %edx				// setChildContextƤӽФesp
	addl	$4, %edx				// setChildContextƤӽФesp
	andl	$0xfff, %edx
	movl	4(%esp), %eax			// ҥץåѥ꡼
	orl		%edx, %eax

	// ƥȤ
	movl	%esp, %ecx				// esp¸
	cli
	movl	%eax, %esp
	pushfl
	orl		$0x200, (%esp)			// ߲Ĥ˥å
	pushl	%cs
	pushl	(%ecx)					// setChildContexteip
	movl	$YES, %eax				// ҥץ꥿ = YES
	pushl	$0						// 顼
	SAVE
	SAVE_CREATE_ESP
	movl	%ecx, %esp				// esp᤹
	sti

	movl	$NO, %eax
	ret

/*
 * ʪåɥ쥹˥ƥȤꤹ
 * void saveStackEsp(
 *	void *)		// ʪåƥȥƬݥ
 */
GLOBAL(saveStackEsp)
	movl	%esp, %ebx
	movl	4(%esp), %esp
	SAVE_CREATE_ESP
	movl	%ebx, %esp
	ret

//--------------------------------------------------------------------------------------------------
// ͥ桼֥å
//--------------------------------------------------------------------------------------------------

/*
 * 桼ϥɥƤӽФ
 * int doCallUserHandler(
 *	const void *method,			// user method pointa
 *	const uint userEsp)			// user esp
 */
GLOBAL(doCallUserHandler)
	pushl	%ebp
	pushl	%esi
	pushl	%edi
	pushl	%ebx

	movl	4 * 5(%esp), %esi			// user method esi = userCall parameter
	movl	4 * 6(%esp), %edi			// user esp    edi = userCall parameter

	cli

	// ܹԤ
	call	vmChangeSignalHandlerStack	// eax = Page directory

	// ۥ꡼֤ܹԤ
	movl	%esp, KERNEL_SAVE_ESP		// åľESP¸
	movl	%eax, %cr3
	call	setTs						// FPUԲ㳰Ĥˤ
	sti

	movl	$returnCallUserMethod, KERNEL_RETURN_POINT

	// 桼˰ܹ
	jmp		*userCall					// changeUserCall()ꤵ

returnCallUserMethod:
	// ֤ͤ
	movl	%eax, %ebp

	cli

	// FPU֥ɥ쥹򥯥ꥢ
	call	clearFpuSaveAddr

	// ۥ꡼֤᤹
	call	vmChangeSignalHandlerStack	// eax = Page directory
	movl	%eax, %cr3
	movl	KERNEL_SAVE_ESP, %esp		// ͥ륹åݥ󥿤᤹

	sti

	// ǥХԲ㳰
	call	setTs

	// ֤᤹ͤ
	movl	%ebp, %eax

	// callUserMethodƤӽФ
	popl	%ebx
	popl	%edi
	popl	%esi
	popl	%ebp
	ret

/*
 * 桼⥸塼᥽åɤƤӽФ
 * int callUserModuleMethod(
 *	const void *method,			// user method pointa
 *	const uint userEsp)			// user esp
 */
GLOBAL(callUserModuleMethod)
	pushl	%ebp
	pushl	%esi
	pushl	%edi
	pushl	%ebx

	movl	4 * 5(%esp), %esi			// user method esi = userCall parameter
	movl	4 * 6(%esp), %edi			// user esp    edi = userCall parameter

	cli

	// ܹԤ
	call	vmChangeKernelStack			// eax = Page directory

	// ۥ꡼֤ܹԤ
	movl	%esp, KERNEL_SAVE_ESP		// åľESP¸
	movl	%eax, %cr3
	call	setTs						// FPUԲ㳰Ĥˤ
	sti

	movl	$returnUserModuleMethod, KERNEL_RETURN_POINT

	// 桼˰ܹ
	jmp		*userCall					// changeUserCall()ꤵ

returnUserModuleMethod:
	// ֤ͤ
	movl	%eax, %ebp

	cli

	// FPU֥ɥ쥹򥯥ꥢ
	call	clearFpuSaveAddr

	// ۥ꡼֤᤹
	call	vmResetModuleCall
	call	vmChangeKernelStack			// eax = Page directory
	movl	%eax, %cr3
	movl	KERNEL_SAVE_ESP, %esp		// ͥ륹åݥ󥿤᤹

	sti

	// ǥХԲ㳰
	call	setTs

	// ֤᤹ͤ
	movl	%ebp, %eax

	// callUserMethodƤӽФ
	popl	%ebx
	popl	%edi
	popl	%esi
	popl	%ebp
	ret

/*
 * 桼᥽åɤ
 */
GLOBAL(returnUserMethod)
	movl	$KERNEL_DATA_DES, %edx
	movl	%edx, %ds
	movl	%edx, %es
	cld
	jmp		*KERNEL_RETURN_POINT

/*
 * 桼ܹԥ롼󥢥ɥ쥹ѹ
 * changeUserCall()
 */
GLOBAL(changeUserCall)
	movl	$userCallSysexit, userCall
	ret

// 桼ܹԥ롼󥢥ɥ쥹
GLOBAL(userCall)
	.long	userCallRet

/*
 * ̾桼ϥɥܹ
 * in   : esi = ⥸塼ɥ쥹, edi = 桼ESP
 * work : eax
 */
GLOBAL(userCallRet)
	movl	$USER_DATA_DES, %eax
	movl	%eax, %ds
	movl	%eax, %es
	pushl	$USER_DATA_DES				// 桼SS
	pushl	%edi						// 桼ESP
	pushl	$USER_CODE_DES				// 桼CS
	pushl	%esi						// ⥸塼ɥ쥹
	lret

/*
 * sysexit桼ϥɥܹ
 * in   : esi = user method, edi = user esp
 * work : eax
 */
GLOBAL(userCallSysexit)
	movl	$USER_DATA_DES, %eax
	movl	%eax, %ds
	movl	%eax, %es
	movl	%edi, %ecx					// 桼ESP
	movl	%esi, %edx					// ⥸塼ɥ쥹
	sysexit
