/*
 * fpu.c
 *
 * Copyright 2007, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * FPU
 */


#include <sys/config.h>
#include <sys/types.h>
#include <sys/param.h>
#include <lib/lib.h>
#include <sys/Thread.h>
#include <kern/vm.h>
#include <i386/lock.h>
#include <i386/interrupt.h>
#include <i386/Cpu.h>

#include <kern/debug.h>


//#define DEBUG_I386_FPU 1
#ifdef DEBUG_I386_FPU
	#define STATIC
	#define INLINE
#else
	#define STATIC	static
	#define INLINE	inline
#endif


//===================================== Х륤ݡ =======================================

extern void clearTs();
extern void fpuStore(uint);

//================================== PRIVATE ============================================

// ľΥǥХԲ㳰򵯤ץFPUʪɥ쥹
static uint fpuSaveAddr[MAX_CPU];

//================================== PUBLIC =============================================

/*
 * ưFPUν
 */
void initFpu()
{
	asm("fninit");
}

/*
 * ȥFPUΰ򥳥ԡ
 */
void copyFpuSaveArea(
	char *m_dstKernStack)		// ԡͥ륹åڡ
{
	memcpy(m_dstKernStack + (KERNEL_SAVE_FPU & (PAGE_SIZE - 1)), (char*) KERNEL_SAVE_FPU, FPU_SAVE_SIZE);
}

/*
 * FPU֥ɥ쥹򥯥ꥢ
 *ռƤӽФ
 */
void clearFpuSaveAddr()
{
	int eflags;
	uint physFpuSave = getPhysicalFromLogicalAddr(getVmTask(getCurrentTask()), KERNEL_SAVE_FPU);

	eflags = enterCli();
	{
		if (physFpuSave == fpuSaveAddr[getCpu()]) {
			fpuSaveAddr[getCpu()] = 0;
		}
	}
	exitCli(eflags);
}

/*
 * ǥХԲ㳰
 *ճԲĤǸƤӽФ롣
 */
void doCoprocessorNotAvailable()
{
	uint saveAddr;

	saveAddr = getPhysicalFromLogicalAddr(getVmTask(getCurrentTask()), KERNEL_SAVE_FPU);

	// ǥХԲ㳰ȥå
	clearTs();
	/*
	 * ǥХԲ㳰ȥåפ㳰ȯץFPU³Ԥ
	 * ǥХԲ㳰ϥѤȤ˥Ȥ
	 */
	if (saveAddr != fpuSaveAddr[getCpu()]) {
		if (0 != fpuSaveAddr[getCpu()]) {
			// FPU쥸򥻡֤
			fpuSave(fpuSaveAddr[getCpu()]);
		}

		// ץΥ֤ƤFPU쥸ƥȤ᤹
		fpuStore(KERNEL_SAVE_FPU);

		// ץFPUΰ򼡤FPU쥸򥻡֥ɥ쥹ꤹ
		fpuSaveAddr[getCpu()] = saveAddr;
	}
}

/*************************************************************************************************/
void test_fpu()
{
}
/**************************************************************************************************/
